/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.OriginMatcher;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.TokenBindingValidator;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.UserVerificationRequirement;
import com.yubico.webauthn.exception.InvalidSignatureCountException;
import com.yubico.webauthn.extension.appid.AppId;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FinishAssertionSteps {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishAssertionSteps.class);
    private static final String CLIENT_DATA_TYPE = "webauthn.get";
    private final AssertionRequest request;
    private final PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response;
    private final Optional<ByteArray> callerTokenBindingId;
    private final Set<String> origins;
    private final String rpId;
    private final CredentialRepository credentialRepository;
    private final boolean allowOriginPort;
    private final boolean allowOriginSubdomain;
    private final boolean allowUnrequestedExtensions;
    private final boolean validateSignatureCounter;

    public Step5 begin() {
        return new Step5();
    }

    public AssertionResult run() throws InvalidSignatureCountException {
        return this.begin().run();
    }

    @Generated
    private static boolean $default$allowOriginPort() {
        return false;
    }

    @Generated
    private static boolean $default$allowOriginSubdomain() {
        return false;
    }

    @Generated
    private static boolean $default$allowUnrequestedExtensions() {
        return false;
    }

    @Generated
    private static boolean $default$validateSignatureCounter() {
        return true;
    }

    @Generated
    FinishAssertionSteps(AssertionRequest request, PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId, Set<String> origins, String rpId, CredentialRepository credentialRepository, boolean allowOriginPort, boolean allowOriginSubdomain, boolean allowUnrequestedExtensions, boolean validateSignatureCounter) {
        this.request = request;
        this.response = response;
        this.callerTokenBindingId = callerTokenBindingId;
        this.origins = origins;
        this.rpId = rpId;
        this.credentialRepository = credentialRepository;
        this.allowOriginPort = allowOriginPort;
        this.allowOriginSubdomain = allowOriginSubdomain;
        this.allowUnrequestedExtensions = allowUnrequestedExtensions;
        this.validateSignatureCounter = validateSignatureCounter;
    }

    @Generated
    public static FinishAssertionStepsBuilder builder() {
        return new FinishAssertionStepsBuilder();
    }

    @Generated
    public static class FinishAssertionStepsBuilder {
        @Generated
        private AssertionRequest request;
        @Generated
        private PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response;
        @Generated
        private Optional<ByteArray> callerTokenBindingId;
        @Generated
        private Set<String> origins;
        @Generated
        private String rpId;
        @Generated
        private CredentialRepository credentialRepository;
        @Generated
        private boolean allowOriginPort$set;
        @Generated
        private boolean allowOriginPort$value;
        @Generated
        private boolean allowOriginSubdomain$set;
        @Generated
        private boolean allowOriginSubdomain$value;
        @Generated
        private boolean allowUnrequestedExtensions$set;
        @Generated
        private boolean allowUnrequestedExtensions$value;
        @Generated
        private boolean validateSignatureCounter$set;
        @Generated
        private boolean validateSignatureCounter$value;

        @Generated
        FinishAssertionStepsBuilder() {
        }

        @Generated
        public FinishAssertionStepsBuilder request(AssertionRequest request) {
            this.request = request;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder response(PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response) {
            this.response = response;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder callerTokenBindingId(Optional<ByteArray> callerTokenBindingId) {
            this.callerTokenBindingId = callerTokenBindingId;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder origins(Set<String> origins) {
            this.origins = origins;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder rpId(String rpId) {
            this.rpId = rpId;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder credentialRepository(CredentialRepository credentialRepository) {
            this.credentialRepository = credentialRepository;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder allowOriginPort(boolean allowOriginPort) {
            this.allowOriginPort$value = allowOriginPort;
            this.allowOriginPort$set = true;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder allowOriginSubdomain(boolean allowOriginSubdomain) {
            this.allowOriginSubdomain$value = allowOriginSubdomain;
            this.allowOriginSubdomain$set = true;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder allowUnrequestedExtensions(boolean allowUnrequestedExtensions) {
            this.allowUnrequestedExtensions$value = allowUnrequestedExtensions;
            this.allowUnrequestedExtensions$set = true;
            return this;
        }

        @Generated
        public FinishAssertionStepsBuilder validateSignatureCounter(boolean validateSignatureCounter) {
            this.validateSignatureCounter$value = validateSignatureCounter;
            this.validateSignatureCounter$set = true;
            return this;
        }

        @Generated
        public FinishAssertionSteps build() {
            boolean allowOriginPort$value = this.allowOriginPort$value;
            if (!this.allowOriginPort$set) {
                allowOriginPort$value = FinishAssertionSteps.$default$allowOriginPort();
            }
            boolean allowOriginSubdomain$value = this.allowOriginSubdomain$value;
            if (!this.allowOriginSubdomain$set) {
                allowOriginSubdomain$value = FinishAssertionSteps.$default$allowOriginSubdomain();
            }
            boolean allowUnrequestedExtensions$value = this.allowUnrequestedExtensions$value;
            if (!this.allowUnrequestedExtensions$set) {
                allowUnrequestedExtensions$value = FinishAssertionSteps.$default$allowUnrequestedExtensions();
            }
            boolean validateSignatureCounter$value = this.validateSignatureCounter$value;
            if (!this.validateSignatureCounter$set) {
                validateSignatureCounter$value = FinishAssertionSteps.$default$validateSignatureCounter();
            }
            return new FinishAssertionSteps(this.request, this.response, this.callerTokenBindingId, this.origins, this.rpId, this.credentialRepository, allowOriginPort$value, allowOriginSubdomain$value, allowUnrequestedExtensions$value, validateSignatureCounter$value);
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.FinishAssertionStepsBuilder(request=" + this.request + ", response=" + this.response + ", callerTokenBindingId=" + this.callerTokenBindingId + ", origins=" + this.origins + ", rpId=" + this.rpId + ", credentialRepository=" + this.credentialRepository + ", allowOriginPort$value=" + this.allowOriginPort$value + ", allowOriginSubdomain$value=" + this.allowOriginSubdomain$value + ", allowUnrequestedExtensions$value=" + this.allowUnrequestedExtensions$value + ", validateSignatureCounter$value=" + this.validateSignatureCounter$value + ")";
        }
    }

    final class Finished
    implements Step<Finished> {
        private final RegisteredCredential credential;
        private final String username;
        private final long assertionSignatureCount;
        private final boolean signatureCounterValid;

        @Override
        public void validate() {
        }

        @Override
        public Finished nextStep() {
            return this;
        }

        @Override
        public Optional<AssertionResult> result() {
            return Optional.of(new AssertionResult(true, FinishAssertionSteps.this.response, this.credential, this.username, this.signatureCounterValid));
        }

        @Generated
        public Finished(RegisteredCredential credential, String username, long assertionSignatureCount, boolean signatureCounterValid) {
            this.credential = credential;
            this.username = username;
            this.assertionSignatureCount = assertionSignatureCount;
            this.signatureCounterValid = signatureCounterValid;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public long getAssertionSignatureCount() {
            return this.assertionSignatureCount;
        }

        @Generated
        public boolean isSignatureCounterValid() {
            return this.signatureCounterValid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Finished)) {
                return false;
            }
            Finished other = (Finished)o;
            if (this.getAssertionSignatureCount() != other.getAssertionSignatureCount()) {
                return false;
            }
            if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            return !(this$username == null ? other$username != null : !this$username.equals(other$username));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $assertionSignatureCount = this.getAssertionSignatureCount();
            result = result * 59 + (int)($assertionSignatureCount >>> 32 ^ $assertionSignatureCount);
            result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Finished(credential=" + this.getCredential() + ", username=" + this.getUsername() + ", assertionSignatureCount=" + this.getAssertionSignatureCount() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ")";
        }
    }

    final class Step21
    implements Step<Finished> {
        private final String username;
        private final RegisteredCredential credential;
        private final long assertionSignatureCount;
        private final long storedSignatureCountBefore;

        public Step21(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
            this.assertionSignatureCount = ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData().getSignatureCounter();
            this.storedSignatureCountBefore = credential.getSignatureCount();
        }

        @Override
        public void validate() throws InvalidSignatureCountException {
            if (FinishAssertionSteps.this.validateSignatureCounter && !this.signatureCounterValid()) {
                throw new InvalidSignatureCountException(FinishAssertionSteps.this.response.getId(), this.storedSignatureCountBefore + 1L, this.assertionSignatureCount);
            }
        }

        private boolean signatureCounterValid() {
            return this.assertionSignatureCount == 0L && this.storedSignatureCountBefore == 0L || this.assertionSignatureCount > this.storedSignatureCountBefore;
        }

        @Override
        public Finished nextStep() {
            return new Finished(this.credential, this.username, this.assertionSignatureCount, this.signatureCounterValid());
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public long getAssertionSignatureCount() {
            return this.assertionSignatureCount;
        }

        @Generated
        public long getStoredSignatureCountBefore() {
            return this.storedSignatureCountBefore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step21)) {
                return false;
            }
            Step21 other = (Step21)o;
            if (this.getAssertionSignatureCount() != other.getAssertionSignatureCount()) {
                return false;
            }
            if (this.getStoredSignatureCountBefore() != other.getStoredSignatureCountBefore()) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $assertionSignatureCount = this.getAssertionSignatureCount();
            result = result * 59 + (int)($assertionSignatureCount >>> 32 ^ $assertionSignatureCount);
            long $storedSignatureCountBefore = this.getStoredSignatureCountBefore();
            result = result * 59 + (int)($storedSignatureCountBefore >>> 32 ^ $storedSignatureCountBefore);
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step21(username=" + this.getUsername() + ", credential=" + this.getCredential() + ", assertionSignatureCount=" + this.getAssertionSignatureCount() + ", storedSignatureCountBefore=" + this.getStoredSignatureCountBefore() + ")";
        }
    }

    final class Step20
    implements Step<Step21> {
        private final String username;
        private final RegisteredCredential credential;
        private final ByteArray clientDataJsonHash;

        @Override
        public void validate() {
            PublicKey key;
            ByteArray cose = this.credential.getPublicKeyCose();
            try {
                key = WebAuthnCodecs.importCosePublicKey(cose);
            }
            catch (CoseException | IOException | InvalidKeySpecException e) {
                throw new IllegalArgumentException(String.format("Failed to decode public key: Credential ID: %s COSE: %s", this.credential.getCredentialId().getBase64Url(), cose.getBase64Url()), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            COSEAlgorithmIdentifier alg = COSEAlgorithmIdentifier.fromPublicKey(cose).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to decode \"alg\" from COSE key: %s", cose)));
            if (!Crypto.verifySignature(key, this.signedBytes(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getSignature(), alg)) {
                throw new IllegalArgumentException("Invalid assertion signature.");
            }
        }

        @Override
        public Step21 nextStep() {
            return new Step21(this.username, this.credential);
        }

        public ByteArray signedBytes() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getAuthenticatorData().concat(this.clientDataJsonHash);
        }

        @Generated
        public Step20(String username, RegisteredCredential credential, ByteArray clientDataJsonHash) {
            this.username = username;
            this.credential = credential;
            this.clientDataJsonHash = clientDataJsonHash;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step20)) {
                return false;
            }
            Step20 other = (Step20)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            return !(this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step20(username=" + this.getUsername() + ", credential=" + this.getCredential() + ", clientDataJsonHash=" + this.getClientDataJsonHash() + ")";
        }
    }

    final class Step19
    implements Step<Step20> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientDataJsonHash().size() == 32 ? 1 : 0) != 0, (String)"Failed to compute hash of client data", (Object[])new Object[0]);
        }

        @Override
        public Step20 nextStep() {
            return new Step20(this.username, this.credential, this.clientDataJsonHash());
        }

        public ByteArray clientDataJsonHash() {
            return Crypto.sha256(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientDataJSON());
        }

        @Generated
        public Step19(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step19)) {
                return false;
            }
            Step19 other = (Step19)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step19(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step18
    implements Step<Step19> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
        }

        @Override
        public Step19 nextStep() {
            return new Step19(this.username, this.credential);
        }

        @Generated
        public Step18(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step18)) {
                return false;
            }
            Step18 other = (Step18)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step18(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class PendingStep16
    implements Step<Step18> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((!this.credential.isBackupEligible().isPresent() || ((AuthenticatorAssertionResponse)((FinishAssertionSteps)FinishAssertionSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().BE == this.credential.isBackupEligible().get() ? 1 : 0) != 0, (String)"Backup eligibility must not change; Stored: BE=%s, received: BE=%s for credential: %s", (Object[])new Object[]{this.credential.isBackupEligible(), ((AuthenticatorAssertionResponse)((FinishAssertionSteps)FinishAssertionSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().BE, this.credential.getCredentialId()});
        }

        @Override
        public Step18 nextStep() {
            return new Step18(this.username, this.credential);
        }

        @Generated
        public PendingStep16(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingStep16)) {
                return false;
            }
            PendingStep16 other = (PendingStep16)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.PendingStep16(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step17
    implements Step<PendingStep16> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            if (FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getUserVerification().equals(Optional.of(UserVerificationRequirement.REQUIRED))) {
                ExceptionUtil.assertTrue((boolean)((AuthenticatorAssertionResponse)((FinishAssertionSteps)FinishAssertionSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UV, (String)"User Verification is required.", (Object[])new Object[0]);
            }
        }

        @Override
        public PendingStep16 nextStep() {
            return new PendingStep16(this.username, this.credential);
        }

        @Generated
        public Step17(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step17)) {
                return false;
            }
            Step17 other = (Step17)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step17(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step16
    implements Step<Step17> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)((AuthenticatorAssertionResponse)((FinishAssertionSteps)FinishAssertionSteps.this).response.getResponse()).getParsedAuthenticatorData().getFlags().UP, (String)"User Presence is required.", (Object[])new Object[0]);
        }

        @Override
        public Step17 nextStep() {
            return new Step17(this.username, this.credential);
        }

        @Generated
        public Step16(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step16)) {
                return false;
            }
            Step16 other = (Step16)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step16(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step15
    implements Step<Step16> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            try {
                ExceptionUtil.assertTrue((boolean)Crypto.sha256(FinishAssertionSteps.this.rpId).equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
            }
            catch (IllegalArgumentException e) {
                Optional<AppId> appid = FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getExtensions().getAppid();
                if (appid.isPresent()) {
                    ExceptionUtil.assertTrue((boolean)Crypto.sha256(appid.get().getId()).equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getParsedAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
                }
                throw e;
            }
        }

        @Override
        public Step16 nextStep() {
            return new Step16(this.username, this.credential);
        }

        @Generated
        public Step15(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step15)) {
                return false;
            }
            Step15 other = (Step15)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step15(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step14
    implements Step<Step15> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            TokenBindingValidator.validate(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData().getTokenBinding(), FinishAssertionSteps.this.callerTokenBindingId);
        }

        @Override
        public Step15 nextStep() {
            return new Step15(this.username, this.credential);
        }

        @Generated
        public Step14(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step14)) {
                return false;
            }
            Step14 other = (Step14)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step14(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step13
    implements Step<Step14> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            String responseOrigin = ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData().getOrigin();
            ExceptionUtil.assertTrue((boolean)OriginMatcher.isAllowed(responseOrigin, FinishAssertionSteps.this.origins, FinishAssertionSteps.this.allowOriginPort, FinishAssertionSteps.this.allowOriginSubdomain), (String)("Incorrect origin: " + responseOrigin), (Object[])new Object[0]);
        }

        @Override
        public Step14 nextStep() {
            return new Step14(this.username, this.credential);
        }

        @Generated
        public Step13(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step13)) {
                return false;
            }
            Step13 other = (Step13)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step13(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step12
    implements Step<Step13> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getChallenge().equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData().getChallenge()), (String)"Incorrect challenge.", (Object[])new Object[0]);
        }

        @Override
        public Step13 nextStep() {
            return new Step13(this.username, this.credential);
        }

        @Generated
        public Step12(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step12)) {
                return false;
            }
            Step12 other = (Step12)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step12(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step11
    implements Step<Step12> {
        private final String username;
        private final RegisteredCredential credential;
        private final CollectedClientData clientData;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)FinishAssertionSteps.CLIENT_DATA_TYPE.equals(this.clientData.getType()), (String)"The \"type\" in the client data must be exactly \"%s\", was: %s", (Object[])new Object[]{FinishAssertionSteps.CLIENT_DATA_TYPE, this.clientData.getType()});
        }

        @Override
        public Step12 nextStep() {
            return new Step12(this.username, this.credential);
        }

        @Generated
        public Step11(String username, RegisteredCredential credential, CollectedClientData clientData) {
            this.username = username;
            this.credential = credential;
            this.clientData = clientData;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step11)) {
                return false;
            }
            Step11 other = (Step11)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential)) {
                return false;
            }
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            return !(this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step11(username=" + this.getUsername() + ", credential=" + this.getCredential() + ", clientData=" + this.getClientData() + ")";
        }
    }

    final class Step10
    implements Step<Step11> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientData() != null ? 1 : 0) != 0, (String)"Missing client data.", (Object[])new Object[0]);
        }

        @Override
        public Step11 nextStep() {
            return new Step11(this.username, this.credential, this.clientData());
        }

        public CollectedClientData clientData() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientData();
        }

        @Generated
        public Step10(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step10)) {
                return false;
            }
            Step10 other = (Step10)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step10(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step8
    implements Step<Step10> {
        private final String username;
        private final RegisteredCredential credential;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientData() != null ? 1 : 0) != 0, (String)"Missing client data.", (Object[])new Object[0]);
            ExceptionUtil.assertTrue((this.authenticatorData() != null ? 1 : 0) != 0, (String)"Missing authenticator data.", (Object[])new Object[0]);
            ExceptionUtil.assertTrue((this.signature() != null ? 1 : 0) != 0, (String)"Missing signature.", (Object[])new Object[0]);
        }

        @Override
        public Step10 nextStep() {
            return new Step10(this.username, this.credential);
        }

        public ByteArray authenticatorData() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getAuthenticatorData();
        }

        public ByteArray clientData() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getClientDataJSON();
        }

        public ByteArray signature() {
            return ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getSignature();
        }

        @Generated
        public Step8(String username, RegisteredCredential credential) {
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public RegisteredCredential getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step8)) {
                return false;
            }
            Step8 other = (Step8)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            RegisteredCredential this$credential = this.getCredential();
            RegisteredCredential other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            RegisteredCredential $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step8(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step7
    implements Step<Step8> {
        private final String username;
        private final ByteArray userHandle;
        private final Optional<RegisteredCredential> credential;

        @Override
        public Step8 nextStep() {
            return new Step8(this.username, this.credential.get());
        }

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)this.credential.isPresent(), (String)"Unknown credential. Credential ID: %s, user handle: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId(), this.userHandle});
        }

        @Generated
        public Step7(String username, ByteArray userHandle, Optional<RegisteredCredential> credential) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
        }

        @Generated
        public String getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public Optional<RegisteredCredential> getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step7)) {
                return false;
            }
            Step7 other = (Step7)o;
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            Optional<RegisteredCredential> this$credential = this.getCredential();
            Optional<RegisteredCredential> other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            Optional<RegisteredCredential> $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step7(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step6
    implements Step<Step7> {
        private final Optional<ByteArray> userHandle;
        private final Optional<String> username;
        private final Optional<RegisteredCredential> registration;

        @Override
        public Step7 nextStep() {
            return new Step7(this.username.get(), this.userHandle.get(), this.registration);
        }

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((FinishAssertionSteps.this.request.getUsername().isPresent() || FinishAssertionSteps.this.request.getUserHandle().isPresent() || ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().isPresent() ? 1 : 0) != 0, (String)"At least one of username and user handle must be given; none was.", (Object[])new Object[0]);
            if (FinishAssertionSteps.this.request.getUserHandle().isPresent() && ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().isPresent()) {
                ExceptionUtil.assertTrue((boolean)FinishAssertionSteps.this.request.getUserHandle().get().equals(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().get()), (String)"User handle set in request (%s) does not match user handle in response (%s).", (Object[])new Object[]{FinishAssertionSteps.this.request.getUserHandle().get(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle().get()});
            }
            ExceptionUtil.assertTrue((boolean)this.userHandle.isPresent(), (String)"User handle not found for username: %s", (Object[])new Object[]{FinishAssertionSteps.this.request.getUsername(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle()});
            ExceptionUtil.assertTrue((boolean)this.username.isPresent(), (String)"Username not found for userHandle: %s", (Object[])new Object[]{FinishAssertionSteps.this.request.getUsername(), ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle()});
            ExceptionUtil.assertTrue((boolean)this.registration.isPresent(), (String)"Unknown credential: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId()});
            ExceptionUtil.assertTrue((boolean)this.userHandle.get().equals(this.registration.get().getUserHandle()), (String)"User handle %s does not own credential %s", (Object[])new Object[]{this.userHandle.get(), FinishAssertionSteps.this.response.getId()});
            Optional<String> usernameFromRequest = FinishAssertionSteps.this.request.getUsername();
            Optional<ByteArray> userHandleFromResponse = ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle();
            if (usernameFromRequest.isPresent() && userHandleFromResponse.isPresent()) {
                ExceptionUtil.assertTrue((boolean)userHandleFromResponse.equals(FinishAssertionSteps.this.credentialRepository.getUserHandleForUsername(usernameFromRequest.get())), (String)"User handle %s in response does not match username %s in request", (Object[])new Object[]{userHandleFromResponse, usernameFromRequest});
            }
        }

        @Generated
        public Step6() {
            this.userHandle = OptionalUtil.orElseOptional(FinishAssertionSteps.this.request.getUserHandle(), () -> OptionalUtil.orElseOptional(((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle(), () -> FinishAssertionSteps.this.request.getUsername().flatMap(FinishAssertionSteps.this.credentialRepository::getUserHandleForUsername)));
            this.username = OptionalUtil.orElseOptional(FinishAssertionSteps.this.request.getUsername(), () -> this.userHandle.flatMap(FinishAssertionSteps.this.credentialRepository::getUsernameForUserHandle));
            this.registration = this.userHandle.flatMap(uh -> FinishAssertionSteps.this.credentialRepository.lookup(FinishAssertionSteps.this.response.getId(), (ByteArray)uh));
        }

        @Generated
        public Optional<ByteArray> getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public Optional<RegisteredCredential> getRegistration() {
            return this.registration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step6)) {
                return false;
            }
            Step6 other = (Step6)o;
            Optional<ByteArray> this$userHandle = this.getUserHandle();
            Optional<ByteArray> other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Optional<RegisteredCredential> this$registration = this.getRegistration();
            Optional<RegisteredCredential> other$registration = other.getRegistration();
            return !(this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<ByteArray> $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Optional<RegisteredCredential> $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step6(userHandle=" + this.getUserHandle() + ", username=" + this.getUsername() + ", registration=" + this.getRegistration() + ")";
        }
    }

    final class Step5
    implements Step<Step6> {
        @Override
        public Step6 nextStep() {
            return new Step6();
        }

        @Override
        public void validate() {
            FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getAllowCredentials().ifPresent(allowed -> ExceptionUtil.assertTrue((boolean)allowed.stream().anyMatch(allow -> allow.getId().equals(FinishAssertionSteps.this.response.getId())), (String)"Unrequested credential ID: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId()}));
        }

        @Generated
        public Step5() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Step5;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step5()";
        }
    }

    static interface Step<Next extends Step<?>> {
        public Next nextStep();

        public void validate() throws InvalidSignatureCountException;

        default public Optional<AssertionResult> result() {
            return Optional.empty();
        }

        default public Next next() throws InvalidSignatureCountException {
            this.validate();
            return this.nextStep();
        }

        default public AssertionResult run() throws InvalidSignatureCountException {
            if (this.result().isPresent()) {
                return this.result().get();
            }
            return this.next().run();
        }
    }
}

