/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import COSE.OneKey;
import com.google.common.primitives.Bytes;
import com.upokecenter.cbor.CBORObject;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;

final class WebAuthnCodecs {
    private static final ByteArray ED25519_CURVE_OID = new ByteArray(new byte[]{48, 5, 6, 3, 43, 101, 112});

    WebAuthnCodecs() {
    }

    static ByteArray ecPublicKeyToRaw(ECPublicKey key) {
        int fieldSizeBytes = Math.toIntExact(Math.round(Math.ceil((double)key.getParams().getCurve().getField().getFieldSize() / 8.0)));
        byte[] x = key.getW().getAffineX().toByteArray();
        byte[] y = key.getW().getAffineY().toByteArray();
        byte[] xPadding = new byte[Math.max(0, fieldSizeBytes - x.length)];
        byte[] yPadding = new byte[Math.max(0, fieldSizeBytes - y.length)];
        Arrays.fill(xPadding, (byte)0);
        Arrays.fill(yPadding, (byte)0);
        return new ByteArray(Bytes.concat((byte[][])new byte[][]{{4}, xPadding, Arrays.copyOfRange(x, Math.max(0, x.length - fieldSizeBytes), x.length), yPadding, Arrays.copyOfRange(y, Math.max(0, y.length - fieldSizeBytes), y.length)}));
    }

    static ByteArray rawEcKeyToCose(ByteArray key) {
        int coseCrv;
        COSEAlgorithmIdentifier coseAlg;
        byte[] keyBytes = key.getBytes();
        int len = keyBytes.length;
        int lenSub1 = keyBytes.length - 1;
        if (len != 64 && len != 96 && len != 132 && (keyBytes[0] != 4 || lenSub1 != 64 && lenSub1 != 96 && lenSub1 != 132)) {
            throw new IllegalArgumentException(String.format("Raw key must be 64, 96 or 132 bytes long, or start with 0x04 and be 65, 97 or 133 bytes long; was %d bytes starting with %02x", keyBytes.length, keyBytes[0]));
        }
        int start = len == 64 || len == 96 || len == 132 ? 0 : 1;
        int coordinateLength = (len - start) / 2;
        HashMap<Long, Object> coseKey = new HashMap<Long, Object>();
        coseKey.put(1L, 2L);
        switch (len - start) {
            case 64: {
                coseAlg = COSEAlgorithmIdentifier.ES256;
                coseCrv = 1;
                break;
            }
            case 96: {
                coseAlg = COSEAlgorithmIdentifier.ES384;
                coseCrv = 2;
                break;
            }
            case 132: {
                coseAlg = COSEAlgorithmIdentifier.ES512;
                coseCrv = 3;
                break;
            }
            default: {
                throw new RuntimeException("Failed to determine COSE EC algorithm. This should not be possible, please file a bug report.");
            }
        }
        coseKey.put(3L, coseAlg.getId());
        coseKey.put(-1L, coseCrv);
        coseKey.put(-2L, Arrays.copyOfRange(keyBytes, start, start + coordinateLength));
        coseKey.put(-3L, Arrays.copyOfRange(keyBytes, start + coordinateLength, start + 2 * coordinateLength));
        return new ByteArray(CBORObject.FromObject(coseKey).EncodeToBytes());
    }

    static PublicKey importCosePublicKey(ByteArray key) throws CoseException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        CBORObject cose = CBORObject.DecodeFromBytes((byte[])key.getBytes());
        int kty = cose.get(CBORObject.FromObject((int)1)).AsInt32();
        switch (kty) {
            case 1: {
                return WebAuthnCodecs.importCoseEdDsaPublicKey(cose);
            }
            case 2: 
            case 3: {
                return new OneKey(cose).AsPublicKey();
            }
        }
        throw new IllegalArgumentException("Unsupported key type: " + kty);
    }

    private static PublicKey importCoseEdDsaPublicKey(CBORObject cose) throws InvalidKeySpecException, NoSuchAlgorithmException {
        int curveId = cose.get(CBORObject.FromObject((int)-1)).AsInt32();
        switch (curveId) {
            case 6: {
                return WebAuthnCodecs.importCoseEd25519PublicKey(cose);
            }
        }
        throw new IllegalArgumentException("Unsupported EdDSA curve: " + curveId);
    }

    private static PublicKey importCoseEd25519PublicKey(CBORObject cose) throws InvalidKeySpecException, NoSuchAlgorithmException {
        ByteArray rawKey = new ByteArray(cose.get(CBORObject.FromObject((int)-2)).GetByteString());
        ByteArray x509Key = new ByteArray(new byte[]{48, (byte)(ED25519_CURVE_OID.size() + 3 + rawKey.size())}).concat(ED25519_CURVE_OID).concat(new ByteArray(new byte[]{3, (byte)(rawKey.size() + 1), 0})).concat(rawKey);
        KeyFactory kFact = KeyFactory.getInstance("EdDSA");
        return kFact.generatePublic(new X509EncodedKeySpec(x509Key.getBytes()));
    }

    static String getJavaAlgorithmName(COSEAlgorithmIdentifier alg) {
        switch (alg) {
            case EdDSA: {
                return "EDDSA";
            }
            case ES256: {
                return "SHA256withECDSA";
            }
            case ES384: {
                return "SHA384withECDSA";
            }
            case ES512: {
                return "SHA512withECDSA";
            }
            case RS256: {
                return "SHA256withRSA";
            }
            case RS384: {
                return "SHA384withRSA";
            }
            case RS512: {
                return "SHA512withRSA";
            }
            case RS1: {
                return "SHA1withRSA";
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + (Object)((Object)alg));
    }

    static String jwsAlgorithmNameToJavaAlgorithmName(String alg) {
        switch (alg) {
            case "RS256": {
                return "SHA256withRSA";
            }
        }
        throw new IllegalArgumentException("Unknown algorithm: " + alg);
    }
}

