/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.yubico.webauthn.data.ExtensionInputs;
import com.yubico.webauthn.data.Extensions;
import com.yubico.webauthn.extension.appid.AppId;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class AssertionExtensionInputs
implements ExtensionInputs {
    private final AppId appid;
    private final Extensions.LargeBlob.LargeBlobAuthenticationInput largeBlob;
    private final Boolean uvm;

    @JsonCreator
    private AssertionExtensionInputs(@JsonProperty(value="appid") AppId appid, @JsonProperty(value="largeBlob") Extensions.LargeBlob.LargeBlobAuthenticationInput largeBlob, @JsonProperty(value="uvm") Boolean uvm) {
        this.appid = appid;
        this.largeBlob = largeBlob;
        this.uvm = uvm != null && uvm != false ? Boolean.valueOf(true) : null;
    }

    public AssertionExtensionInputs merge(AssertionExtensionInputs other) {
        return new AssertionExtensionInputs(this.appid != null ? this.appid : other.appid, this.largeBlob != null ? this.largeBlob : other.largeBlob, this.uvm != null ? this.uvm : other.uvm);
    }

    @Override
    public Set<String> getExtensionIds() {
        HashSet<String> ids = new HashSet<String>();
        if (this.appid != null) {
            ids.add("appid");
        }
        if (this.largeBlob != null) {
            ids.add("largeBlob");
        }
        if (this.getUvm()) {
            ids.add("uvm");
        }
        return ids;
    }

    public Optional<AppId> getAppid() {
        return Optional.ofNullable(this.appid);
    }

    public Optional<Extensions.LargeBlob.LargeBlobAuthenticationInput> getLargeBlob() {
        return Optional.ofNullable(this.largeBlob);
    }

    @JsonProperty(value="largeBlob")
    private Extensions.LargeBlob.LargeBlobAuthenticationInput getLargeBlobJson() {
        return this.largeBlob != null && (this.largeBlob.getRead() || this.largeBlob.getWrite().isPresent()) ? this.largeBlob : null;
    }

    public boolean getUvm() {
        return this.uvm != null && this.uvm != false;
    }

    @JsonProperty(value="uvm")
    private Boolean getUvmJson() {
        return this.getUvm() ? Boolean.valueOf(true) : null;
    }

    @Generated
    public static AssertionExtensionInputsBuilder builder() {
        return new AssertionExtensionInputsBuilder();
    }

    @Generated
    public AssertionExtensionInputsBuilder toBuilder() {
        return new AssertionExtensionInputsBuilder().appid(this.appid).largeBlob(this.largeBlob).uvm(this.uvm);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssertionExtensionInputs)) {
            return false;
        }
        AssertionExtensionInputs other = (AssertionExtensionInputs)o;
        if (this.getUvm() != other.getUvm()) {
            return false;
        }
        Optional<AppId> this$appid = this.getAppid();
        Optional<AppId> other$appid = other.getAppid();
        if (this$appid == null ? other$appid != null : !((Object)this$appid).equals(other$appid)) {
            return false;
        }
        Optional<Extensions.LargeBlob.LargeBlobAuthenticationInput> this$largeBlob = this.getLargeBlob();
        Optional<Extensions.LargeBlob.LargeBlobAuthenticationInput> other$largeBlob = other.getLargeBlob();
        return !(this$largeBlob == null ? other$largeBlob != null : !((Object)this$largeBlob).equals(other$largeBlob));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getUvm() ? 79 : 97);
        Optional<AppId> $appid = this.getAppid();
        result = result * 59 + ($appid == null ? 43 : ((Object)$appid).hashCode());
        Optional<Extensions.LargeBlob.LargeBlobAuthenticationInput> $largeBlob = this.getLargeBlob();
        result = result * 59 + ($largeBlob == null ? 43 : ((Object)$largeBlob).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssertionExtensionInputs(appid=" + this.getAppid() + ", largeBlob=" + this.getLargeBlob() + ", uvm=" + this.getUvm() + ")";
    }

    public static class AssertionExtensionInputsBuilder {
        @Generated
        private AppId appid;
        @Generated
        private Extensions.LargeBlob.LargeBlobAuthenticationInput largeBlob;
        @Generated
        private Boolean uvm;

        public AssertionExtensionInputsBuilder appid(@NonNull Optional<AppId> appid) {
            if (appid == null) {
                throw new NullPointerException("appid is marked non-null but is null");
            }
            return this.appid((AppId)appid.orElse(null));
        }

        public AssertionExtensionInputsBuilder appid(AppId appid) {
            this.appid = appid;
            return this;
        }

        public AssertionExtensionInputsBuilder largeBlob(Extensions.LargeBlob.LargeBlobAuthenticationInput largeBlob) {
            this.largeBlob = largeBlob;
            return this;
        }

        public AssertionExtensionInputsBuilder uvm() {
            this.uvm = true;
            return this;
        }

        private AssertionExtensionInputsBuilder uvm(Boolean uvm) {
            this.uvm = uvm;
            return this;
        }

        @Generated
        AssertionExtensionInputsBuilder() {
        }

        @Generated
        public AssertionExtensionInputs build() {
            return new AssertionExtensionInputs(this.appid, this.largeBlob, this.uvm);
        }

        @Generated
        public String toString() {
            return "AssertionExtensionInputs.AssertionExtensionInputsBuilder(appid=" + this.appid + ", largeBlob=" + this.largeBlob + ", uvm=" + this.uvm + ")";
        }
    }
}

