/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.internal.util.CollectionUtil;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.FinishAssertionSteps;
import com.yubico.webauthn.FinishRegistrationOptions;
import com.yubico.webauthn.FinishRegistrationSteps;
import com.yubico.webauthn.RegistrationResult;
import com.yubico.webauthn.StartAssertionOptions;
import com.yubico.webauthn.StartRegistrationOptions;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.attestation.AttestationTrustSource;
import com.yubico.webauthn.data.AttestationConveyancePreference;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.PublicKeyCredentialCreationOptions;
import com.yubico.webauthn.data.PublicKeyCredentialDescriptor;
import com.yubico.webauthn.data.PublicKeyCredentialParameters;
import com.yubico.webauthn.data.PublicKeyCredentialRequestOptions;
import com.yubico.webauthn.data.RegistrationExtensionInputs;
import com.yubico.webauthn.data.RelyingPartyIdentity;
import com.yubico.webauthn.exception.AssertionFailedException;
import com.yubico.webauthn.exception.RegistrationFailedException;
import com.yubico.webauthn.extension.appid.AppId;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelyingParty {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelyingParty.class);
    private static final SecureRandom random = new SecureRandom();
    @NonNull
    private final RelyingPartyIdentity identity;
    @NonNull
    private final Set<String> origins;
    @NonNull
    private final CredentialRepository credentialRepository;
    @NonNull
    private final Optional<AppId> appId;
    @NonNull
    private final Optional<AttestationConveyancePreference> attestationConveyancePreference;
    @NonNull
    private final Optional<AttestationTrustSource> attestationTrustSource;
    @NonNull
    private final List<PublicKeyCredentialParameters> preferredPubkeyParams;
    private final boolean allowOriginPort;
    private final boolean allowOriginSubdomain;
    private final boolean allowUntrustedAttestation;
    private final boolean validateSignatureCounter;
    @NonNull
    private final Clock clock;

    private RelyingParty(@NonNull RelyingPartyIdentity identity, Set<String> origins, @NonNull CredentialRepository credentialRepository, @NonNull Optional<AppId> appId, @NonNull Optional<AttestationConveyancePreference> attestationConveyancePreference, @NonNull Optional<AttestationTrustSource> attestationTrustSource, List<PublicKeyCredentialParameters> preferredPubkeyParams, boolean allowOriginPort, boolean allowOriginSubdomain, boolean allowUntrustedAttestation, boolean validateSignatureCounter, Clock clock) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (credentialRepository == null) {
            throw new NullPointerException("credentialRepository is marked non-null but is null");
        }
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (attestationConveyancePreference == null) {
            throw new NullPointerException("attestationConveyancePreference is marked non-null but is null");
        }
        if (attestationTrustSource == null) {
            throw new NullPointerException("attestationTrustSource is marked non-null but is null");
        }
        this.identity = identity;
        this.origins = origins != null ? CollectionUtil.immutableSet(origins) : Collections.singleton("https://" + identity.getId());
        for (String origin : this.origins) {
            try {
                new URL(origin);
            }
            catch (MalformedURLException e) {
                log.warn("Allowed origin is not a valid URL, it will match only by exact string equality: {}", (Object)origin);
            }
        }
        this.credentialRepository = credentialRepository;
        this.appId = appId;
        this.attestationConveyancePreference = attestationConveyancePreference;
        this.attestationTrustSource = attestationTrustSource;
        this.preferredPubkeyParams = RelyingParty.filterAvailableAlgorithms(preferredPubkeyParams);
        this.allowOriginPort = allowOriginPort;
        this.allowOriginSubdomain = allowOriginSubdomain;
        this.allowUntrustedAttestation = allowUntrustedAttestation;
        this.validateSignatureCounter = validateSignatureCounter;
        this.clock = clock;
    }

    private static ByteArray generateChallenge() {
        byte[] bytes = new byte[32];
        random.nextBytes(bytes);
        return new ByteArray(bytes);
    }

    private static List<PublicKeyCredentialParameters> filterAvailableAlgorithms(List<PublicKeyCredentialParameters> pubKeyCredParams) {
        return Collections.unmodifiableList(pubKeyCredParams.stream().filter(param -> {
            String signatureAlgName;
            try {
                switch (param.getAlg()) {
                    case EdDSA: {
                        KeyFactory.getInstance("EdDSA");
                        break;
                    }
                    case ES256: 
                    case ES384: 
                    case ES512: {
                        KeyFactory.getInstance("EC");
                        break;
                    }
                    case RS256: 
                    case RS384: 
                    case RS512: 
                    case RS1: {
                        KeyFactory.getInstance("RSA");
                        break;
                    }
                    default: {
                        log.warn("Unknown algorithm: {}. Please file a bug report.", (Object)param.getAlg());
                        break;
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("Unsupported algorithm in RelyingParty.preferredPubkeyParams: {}. No KeyFactory available; registrations with this key algorithm will fail. You may need to add a dependency and load a provider using java.security.Security.addProvider().", (Object)param.getAlg());
                return false;
            }
            try {
                signatureAlgName = WebAuthnCodecs.getJavaAlgorithmName(param.getAlg());
            }
            catch (IllegalArgumentException e) {
                log.warn("Unknown algorithm: {}. Please file a bug report.", (Object)param.getAlg());
                return false;
            }
            try {
                Signature.getInstance(signatureAlgName);
            }
            catch (NoSuchAlgorithmException e) {
                log.warn("Unsupported algorithm in RelyingParty.preferredPubkeyParams: {}. No Signature available; registrations with this key algorithm will fail. You may need to add a dependency and load a provider using java.security.Security.addProvider().", (Object)param.getAlg());
                return false;
            }
            return true;
        }).collect(Collectors.toList()));
    }

    public PublicKeyCredentialCreationOptions startRegistration(StartRegistrationOptions startRegistrationOptions) {
        PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder builder = PublicKeyCredentialCreationOptions.builder().rp(this.identity).user(startRegistrationOptions.getUser()).challenge(RelyingParty.generateChallenge()).pubKeyCredParams(this.preferredPubkeyParams).excludeCredentials(this.credentialRepository.getCredentialIdsForUsername(startRegistrationOptions.getUser().getName())).authenticatorSelection(startRegistrationOptions.getAuthenticatorSelection()).extensions(startRegistrationOptions.getExtensions().merge(RegistrationExtensionInputs.builder().appidExclude(this.appId).credProps().build())).timeout(startRegistrationOptions.getTimeout());
        this.attestationConveyancePreference.ifPresent(builder::attestation);
        return builder.build();
    }

    public RegistrationResult finishRegistration(FinishRegistrationOptions finishRegistrationOptions) throws RegistrationFailedException {
        try {
            return this._finishRegistration(finishRegistrationOptions).run();
        }
        catch (IllegalArgumentException e) {
            throw new RegistrationFailedException(e);
        }
    }

    FinishRegistrationSteps _finishRegistration(FinishRegistrationOptions options) {
        return new FinishRegistrationSteps(this, options);
    }

    public AssertionRequest startAssertion(StartAssertionOptions startAssertionOptions) {
        PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder pkcro = PublicKeyCredentialRequestOptions.builder().challenge(RelyingParty.generateChallenge()).rpId(this.identity.getId()).allowCredentials(OptionalUtil.orElseOptional(startAssertionOptions.getUsername(), () -> startAssertionOptions.getUserHandle().flatMap(this.credentialRepository::getUsernameForUserHandle)).map(un -> new ArrayList<PublicKeyCredentialDescriptor>(this.credentialRepository.getCredentialIdsForUsername((String)un)))).extensions(startAssertionOptions.getExtensions().merge(startAssertionOptions.getExtensions().toBuilder().appid(this.appId).build())).timeout(startAssertionOptions.getTimeout());
        startAssertionOptions.getUserVerification().ifPresent(pkcro::userVerification);
        return AssertionRequest.builder().publicKeyCredentialRequestOptions(pkcro.build()).username(startAssertionOptions.getUsername()).userHandle(startAssertionOptions.getUserHandle()).build();
    }

    public AssertionResult finishAssertion(FinishAssertionOptions finishAssertionOptions) throws AssertionFailedException {
        try {
            return this._finishAssertion(finishAssertionOptions).run();
        }
        catch (IllegalArgumentException e) {
            throw new AssertionFailedException(e);
        }
    }

    FinishAssertionSteps _finishAssertion(FinishAssertionOptions options) {
        return new FinishAssertionSteps(this, options);
    }

    public static RelyingPartyBuilder.MandatoryStages builder() {
        return new RelyingPartyBuilder.MandatoryStages();
    }

    @Generated
    private static List<PublicKeyCredentialParameters> $default$preferredPubkeyParams() {
        return Collections.unmodifiableList(Arrays.asList(PublicKeyCredentialParameters.ES256, PublicKeyCredentialParameters.EdDSA, PublicKeyCredentialParameters.ES384, PublicKeyCredentialParameters.ES512, PublicKeyCredentialParameters.RS256, PublicKeyCredentialParameters.RS384, PublicKeyCredentialParameters.RS512));
    }

    @Generated
    private static boolean $default$allowOriginPort() {
        return false;
    }

    @Generated
    private static boolean $default$allowOriginSubdomain() {
        return false;
    }

    @Generated
    private static boolean $default$allowUntrustedAttestation() {
        return true;
    }

    @Generated
    private static boolean $default$validateSignatureCounter() {
        return true;
    }

    @Generated
    private static Clock $default$clock() {
        return Clock.systemUTC();
    }

    @Generated
    public RelyingPartyBuilder toBuilder() {
        return new RelyingPartyBuilder().identity(this.identity).origins(this.origins).credentialRepository(this.credentialRepository).appId(this.appId).attestationConveyancePreference(this.attestationConveyancePreference).attestationTrustSource(this.attestationTrustSource).preferredPubkeyParams(this.preferredPubkeyParams).allowOriginPort(this.allowOriginPort).allowOriginSubdomain(this.allowOriginSubdomain).allowUntrustedAttestation(this.allowUntrustedAttestation).validateSignatureCounter(this.validateSignatureCounter).clock(this.clock);
    }

    @NonNull
    @Generated
    public RelyingPartyIdentity getIdentity() {
        return this.identity;
    }

    @NonNull
    @Generated
    public Set<String> getOrigins() {
        return this.origins;
    }

    @NonNull
    @Generated
    public CredentialRepository getCredentialRepository() {
        return this.credentialRepository;
    }

    @NonNull
    @Generated
    public Optional<AppId> getAppId() {
        return this.appId;
    }

    @NonNull
    @Generated
    public Optional<AttestationConveyancePreference> getAttestationConveyancePreference() {
        return this.attestationConveyancePreference;
    }

    @NonNull
    @Generated
    public Optional<AttestationTrustSource> getAttestationTrustSource() {
        return this.attestationTrustSource;
    }

    @NonNull
    @Generated
    public List<PublicKeyCredentialParameters> getPreferredPubkeyParams() {
        return this.preferredPubkeyParams;
    }

    @Generated
    public boolean isAllowOriginPort() {
        return this.allowOriginPort;
    }

    @Generated
    public boolean isAllowOriginSubdomain() {
        return this.allowOriginSubdomain;
    }

    @Generated
    public boolean isAllowUntrustedAttestation() {
        return this.allowUntrustedAttestation;
    }

    @Generated
    public boolean isValidateSignatureCounter() {
        return this.validateSignatureCounter;
    }

    @NonNull
    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelyingParty)) {
            return false;
        }
        RelyingParty other = (RelyingParty)o;
        if (this.isAllowOriginPort() != other.isAllowOriginPort()) {
            return false;
        }
        if (this.isAllowOriginSubdomain() != other.isAllowOriginSubdomain()) {
            return false;
        }
        if (this.isAllowUntrustedAttestation() != other.isAllowUntrustedAttestation()) {
            return false;
        }
        if (this.isValidateSignatureCounter() != other.isValidateSignatureCounter()) {
            return false;
        }
        RelyingPartyIdentity this$identity = this.getIdentity();
        RelyingPartyIdentity other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !((Object)this$identity).equals(other$identity)) {
            return false;
        }
        Set<String> this$origins = this.getOrigins();
        Set<String> other$origins = other.getOrigins();
        if (this$origins == null ? other$origins != null : !((Object)this$origins).equals(other$origins)) {
            return false;
        }
        CredentialRepository this$credentialRepository = this.getCredentialRepository();
        CredentialRepository other$credentialRepository = other.getCredentialRepository();
        if (this$credentialRepository == null ? other$credentialRepository != null : !this$credentialRepository.equals(other$credentialRepository)) {
            return false;
        }
        Optional<AppId> this$appId = this.getAppId();
        Optional<AppId> other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Optional<AttestationConveyancePreference> this$attestationConveyancePreference = this.getAttestationConveyancePreference();
        Optional<AttestationConveyancePreference> other$attestationConveyancePreference = other.getAttestationConveyancePreference();
        if (this$attestationConveyancePreference == null ? other$attestationConveyancePreference != null : !((Object)this$attestationConveyancePreference).equals(other$attestationConveyancePreference)) {
            return false;
        }
        Optional<AttestationTrustSource> this$attestationTrustSource = this.getAttestationTrustSource();
        Optional<AttestationTrustSource> other$attestationTrustSource = other.getAttestationTrustSource();
        if (this$attestationTrustSource == null ? other$attestationTrustSource != null : !((Object)this$attestationTrustSource).equals(other$attestationTrustSource)) {
            return false;
        }
        List<PublicKeyCredentialParameters> this$preferredPubkeyParams = this.getPreferredPubkeyParams();
        List<PublicKeyCredentialParameters> other$preferredPubkeyParams = other.getPreferredPubkeyParams();
        if (this$preferredPubkeyParams == null ? other$preferredPubkeyParams != null : !((Object)this$preferredPubkeyParams).equals(other$preferredPubkeyParams)) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        return !(this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllowOriginPort() ? 79 : 97);
        result = result * 59 + (this.isAllowOriginSubdomain() ? 79 : 97);
        result = result * 59 + (this.isAllowUntrustedAttestation() ? 79 : 97);
        result = result * 59 + (this.isValidateSignatureCounter() ? 79 : 97);
        RelyingPartyIdentity $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : ((Object)$identity).hashCode());
        Set<String> $origins = this.getOrigins();
        result = result * 59 + ($origins == null ? 43 : ((Object)$origins).hashCode());
        CredentialRepository $credentialRepository = this.getCredentialRepository();
        result = result * 59 + ($credentialRepository == null ? 43 : $credentialRepository.hashCode());
        Optional<AppId> $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Optional<AttestationConveyancePreference> $attestationConveyancePreference = this.getAttestationConveyancePreference();
        result = result * 59 + ($attestationConveyancePreference == null ? 43 : ((Object)$attestationConveyancePreference).hashCode());
        Optional<AttestationTrustSource> $attestationTrustSource = this.getAttestationTrustSource();
        result = result * 59 + ($attestationTrustSource == null ? 43 : ((Object)$attestationTrustSource).hashCode());
        List<PublicKeyCredentialParameters> $preferredPubkeyParams = this.getPreferredPubkeyParams();
        result = result * 59 + ($preferredPubkeyParams == null ? 43 : ((Object)$preferredPubkeyParams).hashCode());
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RelyingParty(identity=" + this.getIdentity() + ", origins=" + this.getOrigins() + ", credentialRepository=" + this.getCredentialRepository() + ", appId=" + this.getAppId() + ", attestationConveyancePreference=" + this.getAttestationConveyancePreference() + ", attestationTrustSource=" + this.getAttestationTrustSource() + ", preferredPubkeyParams=" + this.getPreferredPubkeyParams() + ", allowOriginPort=" + this.isAllowOriginPort() + ", allowOriginSubdomain=" + this.isAllowOriginSubdomain() + ", allowUntrustedAttestation=" + this.isAllowUntrustedAttestation() + ", validateSignatureCounter=" + this.isValidateSignatureCounter() + ", clock=" + this.getClock() + ")";
    }

    public static class RelyingPartyBuilder {
        @Generated
        private RelyingPartyIdentity identity;
        @Generated
        private Set<String> origins;
        @Generated
        private CredentialRepository credentialRepository;
        @Generated
        private boolean preferredPubkeyParams$set;
        @Generated
        private List<PublicKeyCredentialParameters> preferredPubkeyParams$value;
        @Generated
        private boolean allowOriginPort$set;
        @Generated
        private boolean allowOriginPort$value;
        @Generated
        private boolean allowOriginSubdomain$set;
        @Generated
        private boolean allowOriginSubdomain$value;
        @Generated
        private boolean allowUntrustedAttestation$set;
        @Generated
        private boolean allowUntrustedAttestation$value;
        @Generated
        private boolean validateSignatureCounter$set;
        @Generated
        private boolean validateSignatureCounter$value;
        @Generated
        private boolean clock$set;
        @Generated
        private Clock clock$value;
        @Generated
        private List<PublicKeyCredentialParameters> preferredPubkeyParams;
        @Generated
        private boolean allowOriginPort;
        @Generated
        private boolean allowOriginSubdomain;
        @Generated
        private boolean allowUntrustedAttestation;
        @Generated
        private boolean validateSignatureCounter;
        @Generated
        private Clock clock;
        @NonNull
        private Optional<AppId> appId = Optional.empty();
        @NonNull
        private Optional<AttestationConveyancePreference> attestationConveyancePreference = Optional.empty();
        @NonNull
        private Optional<AttestationTrustSource> attestationTrustSource = Optional.empty();

        public RelyingPartyBuilder appId(@NonNull Optional<AppId> appId) {
            if (appId == null) {
                throw new NullPointerException("appId is marked non-null but is null");
            }
            this.appId = appId;
            return this;
        }

        public RelyingPartyBuilder appId(@NonNull AppId appId) {
            if (appId == null) {
                throw new NullPointerException("appId is marked non-null but is null");
            }
            return this.appId(Optional.of(appId));
        }

        public RelyingPartyBuilder attestationConveyancePreference(@NonNull Optional<AttestationConveyancePreference> attestationConveyancePreference) {
            if (attestationConveyancePreference == null) {
                throw new NullPointerException("attestationConveyancePreference is marked non-null but is null");
            }
            this.attestationConveyancePreference = attestationConveyancePreference;
            return this;
        }

        public RelyingPartyBuilder attestationConveyancePreference(@NonNull AttestationConveyancePreference attestationConveyancePreference) {
            if (attestationConveyancePreference == null) {
                throw new NullPointerException("attestationConveyancePreference is marked non-null but is null");
            }
            return this.attestationConveyancePreference(Optional.of(attestationConveyancePreference));
        }

        public RelyingPartyBuilder attestationTrustSource(@NonNull Optional<AttestationTrustSource> attestationTrustSource) {
            if (attestationTrustSource == null) {
                throw new NullPointerException("attestationTrustSource is marked non-null but is null");
            }
            this.attestationTrustSource = attestationTrustSource;
            return this;
        }

        public RelyingPartyBuilder attestationTrustSource(@NonNull AttestationTrustSource attestationTrustSource) {
            if (attestationTrustSource == null) {
                throw new NullPointerException("attestationTrustSource is marked non-null but is null");
            }
            return this.attestationTrustSource(Optional.of(attestationTrustSource));
        }

        @Generated
        RelyingPartyBuilder() {
        }

        @Generated
        public RelyingPartyBuilder identity(@NonNull RelyingPartyIdentity identity) {
            if (identity == null) {
                throw new NullPointerException("identity is marked non-null but is null");
            }
            this.identity = identity;
            return this;
        }

        @Generated
        public RelyingPartyBuilder origins(@NonNull Set<String> origins) {
            if (origins == null) {
                throw new NullPointerException("origins is marked non-null but is null");
            }
            this.origins = origins;
            return this;
        }

        @Generated
        public RelyingPartyBuilder credentialRepository(@NonNull CredentialRepository credentialRepository) {
            if (credentialRepository == null) {
                throw new NullPointerException("credentialRepository is marked non-null but is null");
            }
            this.credentialRepository = credentialRepository;
            return this;
        }

        @Generated
        public RelyingPartyBuilder preferredPubkeyParams(@NonNull List<PublicKeyCredentialParameters> preferredPubkeyParams) {
            if (preferredPubkeyParams == null) {
                throw new NullPointerException("preferredPubkeyParams is marked non-null but is null");
            }
            this.preferredPubkeyParams$value = preferredPubkeyParams;
            this.preferredPubkeyParams$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder allowOriginPort(boolean allowOriginPort) {
            this.allowOriginPort$value = allowOriginPort;
            this.allowOriginPort$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder allowOriginSubdomain(boolean allowOriginSubdomain) {
            this.allowOriginSubdomain$value = allowOriginSubdomain;
            this.allowOriginSubdomain$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder allowUntrustedAttestation(boolean allowUntrustedAttestation) {
            this.allowUntrustedAttestation$value = allowUntrustedAttestation;
            this.allowUntrustedAttestation$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder validateSignatureCounter(boolean validateSignatureCounter) {
            this.validateSignatureCounter$value = validateSignatureCounter;
            this.validateSignatureCounter$set = true;
            return this;
        }

        @Generated
        public RelyingPartyBuilder clock(@NonNull Clock clock) {
            if (clock == null) {
                throw new NullPointerException("clock is marked non-null but is null");
            }
            this.clock$value = clock;
            this.clock$set = true;
            return this;
        }

        @Generated
        public RelyingParty build() {
            List preferredPubkeyParams$value = this.preferredPubkeyParams$value;
            if (!this.preferredPubkeyParams$set) {
                preferredPubkeyParams$value = RelyingParty.$default$preferredPubkeyParams();
            }
            boolean allowOriginPort$value = this.allowOriginPort$value;
            if (!this.allowOriginPort$set) {
                allowOriginPort$value = RelyingParty.$default$allowOriginPort();
            }
            boolean allowOriginSubdomain$value = this.allowOriginSubdomain$value;
            if (!this.allowOriginSubdomain$set) {
                allowOriginSubdomain$value = RelyingParty.$default$allowOriginSubdomain();
            }
            boolean allowUntrustedAttestation$value = this.allowUntrustedAttestation$value;
            if (!this.allowUntrustedAttestation$set) {
                allowUntrustedAttestation$value = RelyingParty.$default$allowUntrustedAttestation();
            }
            boolean validateSignatureCounter$value = this.validateSignatureCounter$value;
            if (!this.validateSignatureCounter$set) {
                validateSignatureCounter$value = RelyingParty.$default$validateSignatureCounter();
            }
            Clock clock$value = this.clock$value;
            if (!this.clock$set) {
                clock$value = RelyingParty.$default$clock();
            }
            return new RelyingParty(this.identity, this.origins, this.credentialRepository, this.appId, this.attestationConveyancePreference, this.attestationTrustSource, preferredPubkeyParams$value, allowOriginPort$value, allowOriginSubdomain$value, allowUntrustedAttestation$value, validateSignatureCounter$value, clock$value);
        }

        @Generated
        public String toString() {
            return "RelyingParty.RelyingPartyBuilder(identity=" + this.identity + ", origins=" + this.origins + ", credentialRepository=" + this.credentialRepository + ", appId=" + this.appId + ", attestationConveyancePreference=" + this.attestationConveyancePreference + ", attestationTrustSource=" + this.attestationTrustSource + ", preferredPubkeyParams$value=" + this.preferredPubkeyParams$value + ", allowOriginPort$value=" + this.allowOriginPort$value + ", allowOriginSubdomain$value=" + this.allowOriginSubdomain$value + ", allowUntrustedAttestation$value=" + this.allowUntrustedAttestation$value + ", validateSignatureCounter$value=" + this.validateSignatureCounter$value + ", clock$value=" + this.clock$value + ")";
        }

        public static class MandatoryStages {
            private final RelyingPartyBuilder builder = new RelyingPartyBuilder();

            public Step2 identity(RelyingPartyIdentity identity) {
                this.builder.identity(identity);
                return new Step2();
            }

            public class Step2 {
                public RelyingPartyBuilder credentialRepository(CredentialRepository credentialRepository) {
                    return MandatoryStages.this.builder.credentialRepository(credentialRepository);
                }
            }
        }
    }
}

