/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.CredentialRepositoryV2;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.ToPublicKeyCredentialDescriptor;
import com.yubico.webauthn.UsernameRepository;
import com.yubico.webauthn.data.ByteArray;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

class CredentialRepositoryV1ToV2Adapter
implements CredentialRepositoryV2<RegisteredCredential>,
UsernameRepository {
    private final CredentialRepository inner;

    @Override
    public Set<? extends ToPublicKeyCredentialDescriptor> getCredentialDescriptorsForUserHandle(ByteArray userHandle) {
        return this.inner.getUsernameForUserHandle(userHandle).map(this.inner::getCredentialIdsForUsername).orElseGet(Collections::emptySet);
    }

    @Override
    public Optional<RegisteredCredential> lookup(ByteArray credentialId, ByteArray userHandle) {
        return this.inner.lookup(credentialId, userHandle);
    }

    @Override
    public boolean credentialIdExists(ByteArray credentialId) {
        return !this.inner.lookupAll(credentialId).isEmpty();
    }

    @Override
    public Optional<ByteArray> getUserHandleForUsername(String username) {
        return this.inner.getUserHandleForUsername(username);
    }

    @Override
    public Optional<String> getUsernameForUserHandle(ByteArray userHandle) {
        return this.inner.getUsernameForUserHandle(userHandle);
    }

    @Generated
    public CredentialRepositoryV1ToV2Adapter(CredentialRepository inner) {
        this.inner = inner;
    }
}

