/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.webauthn;

import COSE.CoseException;
import com.yubico.internal.util.ExceptionUtil;
import com.yubico.internal.util.OptionalUtil;
import com.yubico.webauthn.AssertionRequest;
import com.yubico.webauthn.AssertionResult;
import com.yubico.webauthn.AssertionResultV2;
import com.yubico.webauthn.CredentialRecord;
import com.yubico.webauthn.CredentialRepository;
import com.yubico.webauthn.CredentialRepositoryV1ToV2Adapter;
import com.yubico.webauthn.CredentialRepositoryV2;
import com.yubico.webauthn.Crypto;
import com.yubico.webauthn.FinishAssertionOptions;
import com.yubico.webauthn.OriginMatcher;
import com.yubico.webauthn.RegisteredCredential;
import com.yubico.webauthn.RelyingParty;
import com.yubico.webauthn.RelyingPartyV2;
import com.yubico.webauthn.TokenBindingValidator;
import com.yubico.webauthn.UsernameRepository;
import com.yubico.webauthn.WebAuthnCodecs;
import com.yubico.webauthn.data.AuthenticatorAssertionResponse;
import com.yubico.webauthn.data.ByteArray;
import com.yubico.webauthn.data.COSEAlgorithmIdentifier;
import com.yubico.webauthn.data.ClientAssertionExtensionOutputs;
import com.yubico.webauthn.data.CollectedClientData;
import com.yubico.webauthn.data.PublicKeyCredential;
import com.yubico.webauthn.data.UserVerificationRequirement;
import com.yubico.webauthn.exception.InvalidSignatureCountException;
import com.yubico.webauthn.extension.appid.AppId;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FinishAssertionSteps<C extends CredentialRecord> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishAssertionSteps.class);
    private static final String CLIENT_DATA_TYPE = "webauthn.get";
    private static final String SPC_CLIENT_DATA_TYPE = "payment.get";
    private final AssertionRequest request;
    private final PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response;
    private final Optional<ByteArray> callerTokenBindingId;
    private final Set<String> origins;
    private final String rpId;
    private final CredentialRepositoryV2<C> credentialRepositoryV2;
    private final Optional<UsernameRepository> usernameRepository;
    private final boolean allowOriginPort;
    private final boolean allowOriginSubdomain;
    private final boolean validateSignatureCounter;
    private final boolean isSecurePaymentConfirmation;

    static FinishAssertionSteps<RegisteredCredential> fromV1(RelyingParty rp, FinishAssertionOptions options) {
        CredentialRepository credRepo = rp.getCredentialRepository();
        CredentialRepositoryV1ToV2Adapter credRepoV2 = new CredentialRepositoryV1ToV2Adapter(credRepo);
        return new FinishAssertionSteps<RegisteredCredential>(options.getRequest(), options.getResponse(), options.getCallerTokenBindingId(), rp.getOrigins(), rp.getIdentity().getId(), credRepoV2, Optional.of(credRepoV2), rp.isAllowOriginPort(), rp.isAllowOriginSubdomain(), rp.isValidateSignatureCounter(), options.isSecurePaymentConfirmation());
    }

    FinishAssertionSteps(RelyingPartyV2<C> rp, FinishAssertionOptions options) {
        this(options.getRequest(), options.getResponse(), options.getCallerTokenBindingId(), rp.getOrigins(), rp.getIdentity().getId(), rp.getCredentialRepository(), Optional.ofNullable(rp.getUsernameRepository()), rp.isAllowOriginPort(), rp.isAllowOriginSubdomain(), rp.isValidateSignatureCounter(), options.isSecurePaymentConfirmation());
    }

    private Optional<String> getUsernameForUserHandle(ByteArray userHandle) {
        return this.usernameRepository.flatMap(unameRepo -> unameRepo.getUsernameForUserHandle(userHandle));
    }

    public Step5 begin() {
        return new Step5();
    }

    public AssertionResult run() throws InvalidSignatureCountException {
        return this.begin().run();
    }

    public AssertionResultV2<C> runV2() throws InvalidSignatureCountException {
        return this.begin().runV2();
    }

    @Generated
    public FinishAssertionSteps(AssertionRequest request, PublicKeyCredential<AuthenticatorAssertionResponse, ClientAssertionExtensionOutputs> response, Optional<ByteArray> callerTokenBindingId, Set<String> origins, String rpId, CredentialRepositoryV2<C> credentialRepositoryV2, Optional<UsernameRepository> usernameRepository, boolean allowOriginPort, boolean allowOriginSubdomain, boolean validateSignatureCounter, boolean isSecurePaymentConfirmation) {
        this.request = request;
        this.response = response;
        this.callerTokenBindingId = callerTokenBindingId;
        this.origins = origins;
        this.rpId = rpId;
        this.credentialRepositoryV2 = credentialRepositoryV2;
        this.usernameRepository = usernameRepository;
        this.allowOriginPort = allowOriginPort;
        this.allowOriginSubdomain = allowOriginSubdomain;
        this.validateSignatureCounter = validateSignatureCounter;
        this.isSecurePaymentConfirmation = isSecurePaymentConfirmation;
    }

    final class Step5
    implements Step<C, Step6> {
        @Override
        public Step6 nextStep() {
            return new Step6();
        }

        @Override
        public void validate() {
            FinishAssertionSteps.this.request.getPublicKeyCredentialRequestOptions().getAllowCredentials().filter(allowCredentials -> !allowCredentials.isEmpty()).ifPresent(allowed -> ExceptionUtil.assertTrue((boolean)allowed.stream().anyMatch(allow -> allow.getId().equals(FinishAssertionSteps.this.response.getId())), (String)"Unrequested credential ID: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId()}));
        }

        @Generated
        public Step5() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            return o instanceof Step5;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step5()";
        }
    }

    final class Finished
    implements Step<C, Finished> {
        private final C credential;
        private final Optional<String> username;
        private final long assertionSignatureCount;
        private final boolean signatureCounterValid;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
        }

        @Override
        public Finished nextStep() {
            return this;
        }

        @Override
        public Optional<AssertionResult> result() {
            return Optional.of(new AssertionResult(true, this.this$0.response, (RegisteredCredential)this.credential, this.username.get(), this.signatureCounterValid));
        }

        @Override
        public Optional<AssertionResultV2<C>> resultV2() {
            return Optional.of(new AssertionResultV2(true, this.this$0.response, this.credential, this.signatureCounterValid));
        }

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        @Generated
        public Finished(C assertionSignatureCount, Optional<String> optional, long signatureCounterValid, boolean bl) {
            void credential;
            this.this$0 = (FinishAssertionSteps)this$0;
            this.credential = credential;
            this.username = (Optional<String>)username;
            this.assertionSignatureCount = (long)assertionSignatureCount;
            this.signatureCounterValid = signatureCounterValid;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public long getAssertionSignatureCount() {
            return this.assertionSignatureCount;
        }

        @Generated
        public boolean isSignatureCounterValid() {
            return this.signatureCounterValid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Finished)) {
                return false;
            }
            Finished other = (Finished)o;
            if (this.getAssertionSignatureCount() != other.getAssertionSignatureCount()) {
                return false;
            }
            if (this.isSignatureCounterValid() != other.isSignatureCounterValid()) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
                return false;
            }
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            return !(this$username == null ? other$username != null : !((Object)this$username).equals(other$username));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $assertionSignatureCount = this.getAssertionSignatureCount();
            result = result * 59 + (int)($assertionSignatureCount >>> 32 ^ $assertionSignatureCount);
            result = result * 59 + (this.isSignatureCounterValid() ? 79 : 97);
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Finished(credential=" + this.getCredential() + ", username=" + this.getUsername() + ", assertionSignatureCount=" + this.getAssertionSignatureCount() + ", signatureCounterValid=" + this.isSignatureCounterValid() + ")";
        }
    }

    static final class Step21
    implements Step<C, Finished> {
        private final Optional<String> username;
        private final C credential;
        private final long assertionSignatureCount;
        private final long storedSignatureCountBefore;
        final /* synthetic */ FinishAssertionSteps this$0;

        public Step21(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
            this.assertionSignatureCount = ((AuthenticatorAssertionResponse)((FinishAssertionSteps)this$0).response.getResponse()).getParsedAuthenticatorData().getSignatureCounter();
            this.storedSignatureCountBefore = credential.getSignatureCount();
        }

        @Override
        public void validate() throws InvalidSignatureCountException {
            if (this.this$0.validateSignatureCounter && !this.signatureCounterValid()) {
                throw new InvalidSignatureCountException(this.this$0.response.getId(), this.storedSignatureCountBefore + 1L, this.assertionSignatureCount);
            }
        }

        private boolean signatureCounterValid() {
            return this.assertionSignatureCount == 0L && this.storedSignatureCountBefore == 0L || this.assertionSignatureCount > this.storedSignatureCountBefore;
        }

        @Override
        public Finished nextStep() {
            return new Finished(this.this$0, this.credential, this.username, this.assertionSignatureCount, this.signatureCounterValid());
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public long getAssertionSignatureCount() {
            return this.assertionSignatureCount;
        }

        @Generated
        public long getStoredSignatureCountBefore() {
            return this.storedSignatureCountBefore;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step21)) {
                return false;
            }
            Step21 other = (Step21)o;
            if (this.getAssertionSignatureCount() != other.getAssertionSignatureCount()) {
                return false;
            }
            if (this.getStoredSignatureCountBefore() != other.getStoredSignatureCountBefore()) {
                return false;
            }
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $assertionSignatureCount = this.getAssertionSignatureCount();
            result = result * 59 + (int)($assertionSignatureCount >>> 32 ^ $assertionSignatureCount);
            long $storedSignatureCountBefore = this.getStoredSignatureCountBefore();
            result = result * 59 + (int)($storedSignatureCountBefore >>> 32 ^ $storedSignatureCountBefore);
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step21(username=" + this.getUsername() + ", credential=" + this.getCredential() + ", assertionSignatureCount=" + this.getAssertionSignatureCount() + ", storedSignatureCountBefore=" + this.getStoredSignatureCountBefore() + ")";
        }
    }

    static final class Step20
    implements Step<C, Step21> {
        private final Optional<String> username;
        private final C credential;
        private final ByteArray clientDataJsonHash;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            PublicKey key;
            ByteArray cose = this.credential.getPublicKeyCose();
            try {
                key = WebAuthnCodecs.importCosePublicKey(cose);
            }
            catch (CoseException | IOException | InvalidKeySpecException e) {
                throw new IllegalArgumentException(String.format("Failed to decode public key: Credential ID: %s COSE: %s", this.credential.getCredentialId().getBase64Url(), cose.getBase64Url()), e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            COSEAlgorithmIdentifier alg = COSEAlgorithmIdentifier.fromPublicKey(cose).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to decode \"alg\" from COSE key: %s", cose)));
            if (!Crypto.verifySignature(key, this.signedBytes(), ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getSignature(), alg)) {
                throw new IllegalArgumentException("Invalid assertion signature.");
            }
        }

        @Override
        public Step21 nextStep() {
            return new Step21(this.this$0, this.username, this.credential);
        }

        public ByteArray signedBytes() {
            return ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getAuthenticatorData().concat(this.clientDataJsonHash);
        }

        @Generated
        public Step20(Optional<String> username, C credential, ByteArray clientDataJsonHash) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
            this.clientDataJsonHash = clientDataJsonHash;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public ByteArray getClientDataJsonHash() {
            return this.clientDataJsonHash;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step20)) {
                return false;
            }
            Step20 other = (Step20)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
                return false;
            }
            ByteArray this$clientDataJsonHash = this.getClientDataJsonHash();
            ByteArray other$clientDataJsonHash = other.getClientDataJsonHash();
            return !(this$clientDataJsonHash == null ? other$clientDataJsonHash != null : !((Object)this$clientDataJsonHash).equals(other$clientDataJsonHash));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            ByteArray $clientDataJsonHash = this.getClientDataJsonHash();
            result = result * 59 + ($clientDataJsonHash == null ? 43 : ((Object)$clientDataJsonHash).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step20(username=" + this.getUsername() + ", credential=" + this.getCredential() + ", clientDataJsonHash=" + this.getClientDataJsonHash() + ")";
        }
    }

    static final class Step19
    implements Step<C, Step20> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientDataJsonHash().size() == 32 ? 1 : 0) != 0, (String)"Failed to compute hash of client data", (Object[])new Object[0]);
        }

        @Override
        public Step20 nextStep() {
            return new Step20(this.this$0, this.username, this.credential, this.clientDataJsonHash());
        }

        public ByteArray clientDataJsonHash() {
            return Crypto.sha256(((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getClientDataJSON());
        }

        @Generated
        public Step19(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step19)) {
                return false;
            }
            Step19 other = (Step19)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step19(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step18
    implements Step<C, Step19> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
        }

        @Override
        public Step19 nextStep() {
            return new Step19(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step18(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step18)) {
                return false;
            }
            Step18 other = (Step18)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step18(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class PendingStep16
    implements Step<C, Step18> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((!this.credential.isBackupEligible().isPresent() || ((AuthenticatorAssertionResponse)((FinishAssertionSteps)this.this$0).response.getResponse()).getParsedAuthenticatorData().getFlags().BE == this.credential.isBackupEligible().get() ? 1 : 0) != 0, (String)"Backup eligibility must not change; Stored: BE=%s, received: BE=%s for credential: %s", (Object[])new Object[]{this.credential.isBackupEligible(), ((AuthenticatorAssertionResponse)((FinishAssertionSteps)this.this$0).response.getResponse()).getParsedAuthenticatorData().getFlags().BE, this.credential.getCredentialId()});
        }

        @Override
        public Step18 nextStep() {
            return new Step18(this.this$0, this.username, this.credential);
        }

        @Generated
        public PendingStep16(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PendingStep16)) {
                return false;
            }
            PendingStep16 other = (PendingStep16)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.PendingStep16(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step17
    implements Step<C, PendingStep16> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            if (this.this$0.request.getPublicKeyCredentialRequestOptions().getUserVerification().equals(Optional.of(UserVerificationRequirement.REQUIRED))) {
                ExceptionUtil.assertTrue((boolean)((AuthenticatorAssertionResponse)((FinishAssertionSteps)this.this$0).response.getResponse()).getParsedAuthenticatorData().getFlags().UV, (String)"User Verification is required.", (Object[])new Object[0]);
            }
        }

        @Override
        public PendingStep16 nextStep() {
            return new PendingStep16(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step17(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step17)) {
                return false;
            }
            Step17 other = (Step17)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step17(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step16
    implements Step<C, Step17> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)((AuthenticatorAssertionResponse)((FinishAssertionSteps)this.this$0).response.getResponse()).getParsedAuthenticatorData().getFlags().UP, (String)"User Presence is required.", (Object[])new Object[0]);
        }

        @Override
        public Step17 nextStep() {
            return new Step17(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step16(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step16)) {
                return false;
            }
            Step16 other = (Step16)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step16(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step15
    implements Step<C, Step16> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            try {
                ExceptionUtil.assertTrue((boolean)Crypto.sha256(this.this$0.rpId).equals(((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getParsedAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
            }
            catch (IllegalArgumentException e) {
                Optional<AppId> appid = this.this$0.request.getPublicKeyCredentialRequestOptions().getExtensions().getAppid();
                if (appid.isPresent()) {
                    ExceptionUtil.assertTrue((boolean)Crypto.sha256(appid.get().getId()).equals(((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getParsedAuthenticatorData().getRpIdHash()), (String)"Wrong RP ID hash.", (Object[])new Object[0]);
                }
                throw e;
            }
        }

        @Override
        public Step16 nextStep() {
            return new Step16(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step15(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step15)) {
                return false;
            }
            Step15 other = (Step15)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step15(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step14
    implements Step<C, Step15> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            TokenBindingValidator.validate(((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getClientData().getTokenBinding(), this.this$0.callerTokenBindingId);
        }

        @Override
        public Step15 nextStep() {
            return new Step15(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step14(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step14)) {
                return false;
            }
            Step14 other = (Step14)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step14(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step13
    implements Step<C, Step14> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            String responseOrigin = ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getClientData().getOrigin();
            ExceptionUtil.assertTrue((boolean)OriginMatcher.isAllowed(responseOrigin, this.this$0.origins, this.this$0.allowOriginPort, this.this$0.allowOriginSubdomain), (String)("Incorrect origin: " + responseOrigin), (Object[])new Object[0]);
        }

        @Override
        public Step14 nextStep() {
            return new Step14(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step13(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step13)) {
                return false;
            }
            Step13 other = (Step13)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step13(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step12
    implements Step<C, Step13> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)this.this$0.request.getPublicKeyCredentialRequestOptions().getChallenge().equals(((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getClientData().getChallenge()), (String)"Incorrect challenge.", (Object[])new Object[0]);
        }

        @Override
        public Step13 nextStep() {
            return new Step13(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step12(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step12)) {
                return false;
            }
            Step12 other = (Step12)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step12(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step11
    implements Step<C, Step12> {
        private final Optional<String> username;
        private final C credential;
        private final CollectedClientData clientData;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            String expectedType = this.this$0.isSecurePaymentConfirmation ? FinishAssertionSteps.SPC_CLIENT_DATA_TYPE : FinishAssertionSteps.CLIENT_DATA_TYPE;
            ExceptionUtil.assertTrue((boolean)expectedType.equals(this.clientData.getType()), (String)"The \"type\" in the client data must be exactly \"%s\", was: %s", (Object[])new Object[]{expectedType, this.clientData.getType()});
        }

        @Override
        public Step12 nextStep() {
            return new Step12(this.this$0, this.username, this.credential);
        }

        @Generated
        public Step11(Optional<String> username, C credential, CollectedClientData clientData) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
            this.clientData = clientData;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public CollectedClientData getClientData() {
            return this.clientData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step11)) {
                return false;
            }
            Step11 other = (Step11)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            if (this$credential == null ? other$credential != null : !this$credential.equals(other$credential)) {
                return false;
            }
            CollectedClientData this$clientData = this.getClientData();
            CollectedClientData other$clientData = other.getClientData();
            return !(this$clientData == null ? other$clientData != null : !((Object)this$clientData).equals(other$clientData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            CollectedClientData $clientData = this.getClientData();
            result = result * 59 + ($clientData == null ? 43 : ((Object)$clientData).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step11(username=" + this.getUsername() + ", credential=" + this.getCredential() + ", clientData=" + this.getClientData() + ")";
        }
    }

    static final class Step10
    implements Step<C, Step11> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientData() != null ? 1 : 0) != 0, (String)"Missing client data.", (Object[])new Object[0]);
        }

        @Override
        public Step11 nextStep() {
            return new Step11(this.this$0, this.username, this.credential, this.clientData());
        }

        public CollectedClientData clientData() {
            return ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getClientData();
        }

        @Generated
        public Step10(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step10)) {
                return false;
            }
            Step10 other = (Step10)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step10(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    static final class Step8
    implements Step<C, Step10> {
        private final Optional<String> username;
        private final C credential;
        final /* synthetic */ FinishAssertionSteps this$0;

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((this.clientData() != null ? 1 : 0) != 0, (String)"Missing client data.", (Object[])new Object[0]);
            ExceptionUtil.assertTrue((this.authenticatorData() != null ? 1 : 0) != 0, (String)"Missing authenticator data.", (Object[])new Object[0]);
            ExceptionUtil.assertTrue((this.signature() != null ? 1 : 0) != 0, (String)"Missing signature.", (Object[])new Object[0]);
        }

        @Override
        public Step10 nextStep() {
            return new Step10(this.this$0, this.username, this.credential);
        }

        public ByteArray authenticatorData() {
            return ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getAuthenticatorData();
        }

        public ByteArray clientData() {
            return ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getClientDataJSON();
        }

        public ByteArray signature() {
            return ((AuthenticatorAssertionResponse)this.this$0.response.getResponse()).getSignature();
        }

        @Generated
        public Step8(Optional<String> username, C credential) {
            this.this$0 = this$0;
            this.username = username;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public C getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step8)) {
                return false;
            }
            Step8 other = (Step8)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            Object this$credential = this.getCredential();
            Object other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !this$credential.equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            Object $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : $credential.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step8(username=" + this.getUsername() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step7
    implements Step<C, Step8> {
        private final Optional<String> username;
        private final ByteArray userHandle;
        private final Optional<C> credential;

        @Override
        public Step8 nextStep() {
            return new Step8(FinishAssertionSteps.this, this.username, (CredentialRecord)this.credential.get());
        }

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((boolean)this.credential.isPresent(), (String)"Unknown credential. Credential ID: %s, user handle: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId(), this.userHandle});
        }

        @Generated
        public Step7(Optional<String> username, ByteArray userHandle, Optional<C> credential) {
            this.username = username;
            this.userHandle = userHandle;
            this.credential = credential;
        }

        @Generated
        public Optional<String> getUsername() {
            return this.username;
        }

        @Generated
        public ByteArray getUserHandle() {
            return this.userHandle;
        }

        @Generated
        public Optional<C> getCredential() {
            return this.credential;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step7)) {
                return false;
            }
            Step7 other = (Step7)o;
            Optional<String> this$username = this.getUsername();
            Optional<String> other$username = other.getUsername();
            if (this$username == null ? other$username != null : !((Object)this$username).equals(other$username)) {
                return false;
            }
            ByteArray this$userHandle = this.getUserHandle();
            ByteArray other$userHandle = other.getUserHandle();
            if (this$userHandle == null ? other$userHandle != null : !((Object)this$userHandle).equals(other$userHandle)) {
                return false;
            }
            Optional this$credential = this.getCredential();
            Optional other$credential = other.getCredential();
            return !(this$credential == null ? other$credential != null : !((Object)this$credential).equals(other$credential));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : ((Object)$username).hashCode());
            ByteArray $userHandle = this.getUserHandle();
            result = result * 59 + ($userHandle == null ? 43 : ((Object)$userHandle).hashCode());
            Optional $credential = this.getCredential();
            result = result * 59 + ($credential == null ? 43 : ((Object)$credential).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step7(username=" + this.getUsername() + ", userHandle=" + this.getUserHandle() + ", credential=" + this.getCredential() + ")";
        }
    }

    final class Step6
    implements Step<C, Step7> {
        private final Optional<ByteArray> requestedUserHandle;
        private final Optional<String> requestedUsername;
        private final Optional<ByteArray> responseUserHandle;
        private final Optional<ByteArray> effectiveRequestUserHandle;
        private final Optional<String> effectiveRequestUsername;
        private final boolean userHandleDerivedFromUsername;
        private final Optional<ByteArray> finalUserHandle;
        private final Optional<String> finalUsername;
        private final Optional<C> registration;

        public Step6() {
            this.requestedUserHandle = FinishAssertionSteps.this.request.getUserHandle();
            this.requestedUsername = FinishAssertionSteps.this.request.getUsername();
            this.responseUserHandle = ((AuthenticatorAssertionResponse)FinishAssertionSteps.this.response.getResponse()).getUserHandle();
            this.effectiveRequestUserHandle = OptionalUtil.orElseOptional(this.requestedUserHandle, () -> FinishAssertionSteps.this.usernameRepository.flatMap(unr -> this.requestedUsername.flatMap(unr::getUserHandleForUsername)));
            this.effectiveRequestUsername = OptionalUtil.orElseOptional(this.requestedUsername, () -> this.requestedUserHandle.flatMap(x$0 -> FinishAssertionSteps.this.getUsernameForUserHandle(x$0)));
            this.userHandleDerivedFromUsername = !this.requestedUserHandle.isPresent() && this.effectiveRequestUserHandle.isPresent();
            this.finalUserHandle = OptionalUtil.orOptional(this.effectiveRequestUserHandle, this.responseUserHandle);
            this.finalUsername = OptionalUtil.orElseOptional(this.effectiveRequestUsername, () -> this.finalUserHandle.flatMap(x$0 -> FinishAssertionSteps.this.getUsernameForUserHandle(x$0)));
            this.registration = this.finalUserHandle.flatMap(uh -> FinishAssertionSteps.this.credentialRepositoryV2.lookup(FinishAssertionSteps.this.response.getId(), (ByteArray)uh));
        }

        @Override
        public Step7 nextStep() {
            return new Step7(this.finalUsername, this.finalUserHandle.get(), this.registration);
        }

        @Override
        public void validate() {
            ExceptionUtil.assertTrue((!FinishAssertionSteps.this.request.getUsername().isPresent() || FinishAssertionSteps.this.usernameRepository.isPresent() ? 1 : 0) != 0, (String)"Cannot set request username when usernameRepository is not configured.", (Object[])new Object[0]);
            ExceptionUtil.assertTrue((boolean)this.finalUserHandle.isPresent(), (String)"Could not identify user to authenticate: none of requested username, requested user handle or response user handle are set.", (Object[])new Object[0]);
            if (this.requestedUserHandle.isPresent() && this.responseUserHandle.isPresent()) {
                ExceptionUtil.assertTrue((boolean)this.requestedUserHandle.get().equals(this.responseUserHandle.get()), (String)"User handle set in request (%s) does not match user handle in response (%s).", (Object[])new Object[]{this.requestedUserHandle.get(), this.responseUserHandle.get()});
            }
            if (this.userHandleDerivedFromUsername && this.responseUserHandle.isPresent()) {
                ExceptionUtil.assertTrue((boolean)this.effectiveRequestUserHandle.get().equals(this.responseUserHandle.get()), (String)"User handle in request (%s) (derived from username: %s) does not match user handle in response (%s).", (Object[])new Object[]{this.effectiveRequestUserHandle.get(), this.requestedUsername.get(), this.responseUserHandle.get()});
            }
            ExceptionUtil.assertTrue((boolean)this.registration.isPresent(), (String)"Unknown credential: %s", (Object[])new Object[]{FinishAssertionSteps.this.response.getId()});
            ExceptionUtil.assertTrue((boolean)this.finalUserHandle.get().equals(((CredentialRecord)this.registration.get()).getUserHandle()), (String)"User handle %s does not own credential %s", (Object[])new Object[]{this.finalUserHandle.get(), FinishAssertionSteps.this.response.getId()});
            if (FinishAssertionSteps.this.usernameRepository.isPresent()) {
                ExceptionUtil.assertTrue((boolean)this.finalUsername.isPresent(), (String)"Unknown username for user handle: %s", (Object[])new Object[]{this.finalUserHandle.get()});
            }
        }

        @Generated
        public Optional<ByteArray> getRequestedUserHandle() {
            return this.requestedUserHandle;
        }

        @Generated
        public Optional<String> getRequestedUsername() {
            return this.requestedUsername;
        }

        @Generated
        public Optional<ByteArray> getResponseUserHandle() {
            return this.responseUserHandle;
        }

        @Generated
        public Optional<ByteArray> getEffectiveRequestUserHandle() {
            return this.effectiveRequestUserHandle;
        }

        @Generated
        public Optional<String> getEffectiveRequestUsername() {
            return this.effectiveRequestUsername;
        }

        @Generated
        public boolean isUserHandleDerivedFromUsername() {
            return this.userHandleDerivedFromUsername;
        }

        @Generated
        public Optional<ByteArray> getFinalUserHandle() {
            return this.finalUserHandle;
        }

        @Generated
        public Optional<String> getFinalUsername() {
            return this.finalUsername;
        }

        @Generated
        public Optional<C> getRegistration() {
            return this.registration;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step6)) {
                return false;
            }
            Step6 other = (Step6)o;
            if (this.isUserHandleDerivedFromUsername() != other.isUserHandleDerivedFromUsername()) {
                return false;
            }
            Optional<ByteArray> this$requestedUserHandle = this.getRequestedUserHandle();
            Optional<ByteArray> other$requestedUserHandle = other.getRequestedUserHandle();
            if (this$requestedUserHandle == null ? other$requestedUserHandle != null : !((Object)this$requestedUserHandle).equals(other$requestedUserHandle)) {
                return false;
            }
            Optional<String> this$requestedUsername = this.getRequestedUsername();
            Optional<String> other$requestedUsername = other.getRequestedUsername();
            if (this$requestedUsername == null ? other$requestedUsername != null : !((Object)this$requestedUsername).equals(other$requestedUsername)) {
                return false;
            }
            Optional<ByteArray> this$responseUserHandle = this.getResponseUserHandle();
            Optional<ByteArray> other$responseUserHandle = other.getResponseUserHandle();
            if (this$responseUserHandle == null ? other$responseUserHandle != null : !((Object)this$responseUserHandle).equals(other$responseUserHandle)) {
                return false;
            }
            Optional<ByteArray> this$effectiveRequestUserHandle = this.getEffectiveRequestUserHandle();
            Optional<ByteArray> other$effectiveRequestUserHandle = other.getEffectiveRequestUserHandle();
            if (this$effectiveRequestUserHandle == null ? other$effectiveRequestUserHandle != null : !((Object)this$effectiveRequestUserHandle).equals(other$effectiveRequestUserHandle)) {
                return false;
            }
            Optional<String> this$effectiveRequestUsername = this.getEffectiveRequestUsername();
            Optional<String> other$effectiveRequestUsername = other.getEffectiveRequestUsername();
            if (this$effectiveRequestUsername == null ? other$effectiveRequestUsername != null : !((Object)this$effectiveRequestUsername).equals(other$effectiveRequestUsername)) {
                return false;
            }
            Optional<ByteArray> this$finalUserHandle = this.getFinalUserHandle();
            Optional<ByteArray> other$finalUserHandle = other.getFinalUserHandle();
            if (this$finalUserHandle == null ? other$finalUserHandle != null : !((Object)this$finalUserHandle).equals(other$finalUserHandle)) {
                return false;
            }
            Optional<String> this$finalUsername = this.getFinalUsername();
            Optional<String> other$finalUsername = other.getFinalUsername();
            if (this$finalUsername == null ? other$finalUsername != null : !((Object)this$finalUsername).equals(other$finalUsername)) {
                return false;
            }
            Optional this$registration = this.getRegistration();
            Optional other$registration = other.getRegistration();
            return !(this$registration == null ? other$registration != null : !((Object)this$registration).equals(other$registration));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUserHandleDerivedFromUsername() ? 79 : 97);
            Optional<ByteArray> $requestedUserHandle = this.getRequestedUserHandle();
            result = result * 59 + ($requestedUserHandle == null ? 43 : ((Object)$requestedUserHandle).hashCode());
            Optional<String> $requestedUsername = this.getRequestedUsername();
            result = result * 59 + ($requestedUsername == null ? 43 : ((Object)$requestedUsername).hashCode());
            Optional<ByteArray> $responseUserHandle = this.getResponseUserHandle();
            result = result * 59 + ($responseUserHandle == null ? 43 : ((Object)$responseUserHandle).hashCode());
            Optional<ByteArray> $effectiveRequestUserHandle = this.getEffectiveRequestUserHandle();
            result = result * 59 + ($effectiveRequestUserHandle == null ? 43 : ((Object)$effectiveRequestUserHandle).hashCode());
            Optional<String> $effectiveRequestUsername = this.getEffectiveRequestUsername();
            result = result * 59 + ($effectiveRequestUsername == null ? 43 : ((Object)$effectiveRequestUsername).hashCode());
            Optional<ByteArray> $finalUserHandle = this.getFinalUserHandle();
            result = result * 59 + ($finalUserHandle == null ? 43 : ((Object)$finalUserHandle).hashCode());
            Optional<String> $finalUsername = this.getFinalUsername();
            result = result * 59 + ($finalUsername == null ? 43 : ((Object)$finalUsername).hashCode());
            Optional $registration = this.getRegistration();
            result = result * 59 + ($registration == null ? 43 : ((Object)$registration).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FinishAssertionSteps.Step6(requestedUserHandle=" + this.getRequestedUserHandle() + ", requestedUsername=" + this.getRequestedUsername() + ", responseUserHandle=" + this.getResponseUserHandle() + ", effectiveRequestUserHandle=" + this.getEffectiveRequestUserHandle() + ", effectiveRequestUsername=" + this.getEffectiveRequestUsername() + ", userHandleDerivedFromUsername=" + this.isUserHandleDerivedFromUsername() + ", finalUserHandle=" + this.getFinalUserHandle() + ", finalUsername=" + this.getFinalUsername() + ", registration=" + this.getRegistration() + ")";
        }
    }

    static interface Step<C extends CredentialRecord, Next extends Step<C, ?>> {
        public Next nextStep();

        public void validate() throws InvalidSignatureCountException;

        default public Optional<AssertionResult> result() {
            return Optional.empty();
        }

        default public Optional<AssertionResultV2<C>> resultV2() {
            return Optional.empty();
        }

        default public Next next() throws InvalidSignatureCountException {
            this.validate();
            return this.nextStep();
        }

        default public AssertionResult run() throws InvalidSignatureCountException {
            if (this.result().isPresent()) {
                return this.result().get();
            }
            return this.next().run();
        }

        default public AssertionResultV2<C> runV2() throws InvalidSignatureCountException {
            if (this.resultV2().isPresent()) {
                return this.resultV2().get();
            }
            return this.next().runV2();
        }
    }
}

