/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.internal.util;

import com.yubico.internal.util.ExceptionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public class BinaryUtil {
    public static byte[] copy(byte[] bytes) {
        return Arrays.copyOf(bytes, bytes.length);
    }

    public static String toHex(byte[] bytes) {
        char[] digits = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int i2 = i * 2;
            digits[i2] = Character.forDigit(bytes[i] >> 4 & 0xF, 16);
            digits[i2 + 1] = Character.forDigit(bytes[i] & 0xF, 16);
        }
        return new String(digits);
    }

    public static byte[] fromHex(String hex) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Length of hex string is not even: " + hex);
        }
        byte[] result = new byte[hex.length() / 2];
        for (int i = 0; i < hex.length(); ++i) {
            int d = Character.digit(hex.charAt(i), 16);
            if (d < 0) {
                throw new IllegalArgumentException("Invalid hex digit at index " + i + " in: " + hex);
            }
            int n = i / 2;
            result[n] = (byte)(result[n] | d << (i + 1) % 2 * 4);
        }
        return result;
    }

    public static byte singleFromHex(String hex) {
        ExceptionUtil.assertTrue(hex.length() == 2, "Argument must be exactly 2 hexadecimal characters, was: %s", hex);
        return BinaryUtil.fromHex(hex)[0];
    }

    public static short getUint8(byte b) {
        return ByteBuffer.wrap(new byte[]{0, b}).order(ByteOrder.BIG_ENDIAN).getShort();
    }

    public static int getUint16(byte[] bytes) {
        if (bytes.length == 2) {
            return ByteBuffer.wrap(new byte[]{0, 0, bytes[0], bytes[1]}).order(ByteOrder.BIG_ENDIAN).getInt();
        }
        throw new IllegalArgumentException("Argument must be 2 bytes, was: " + bytes.length);
    }

    public static long getUint32(byte[] bytes) {
        if (bytes.length == 4) {
            return ByteBuffer.wrap(new byte[]{0, 0, 0, 0, bytes[0], bytes[1], bytes[2], bytes[3]}).order(ByteOrder.BIG_ENDIAN).getLong();
        }
        throw new IllegalArgumentException("Argument must be 4 bytes, was: " + bytes.length);
    }

    public static byte[] encodeUint16(int value) {
        ExceptionUtil.assertTrue(value >= 0, "Argument must be non-negative, was: %d", value);
        ExceptionUtil.assertTrue(value < 65536, "Argument must be smaller than 2^16=65536, was: %d", value);
        ByteBuffer b = ByteBuffer.allocate(4);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putInt(value);
        b.rewind();
        return Arrays.copyOfRange(b.array(), 2, 4);
    }

    public static byte[] encodeUint32(long value) {
        ExceptionUtil.assertTrue(value >= 0L, "Argument must be non-negative, was: %d", value);
        ExceptionUtil.assertTrue(value < 0x100000000L, "Argument must be smaller than 2^32=4294967296, was: %d", value);
        ByteBuffer b = ByteBuffer.allocate(8);
        b.order(ByteOrder.BIG_ENDIAN);
        b.putLong(value);
        b.rewind();
        return Arrays.copyOfRange(b.array(), 4, 8);
    }

    public static byte[] readAll(InputStream is) throws IOException {
        byte[] buffer = new byte[1024];
        int bufferLen = 0;
        int moreLen;
        while ((moreLen = is.read(buffer, bufferLen, buffer.length - bufferLen)) > 0) {
            if ((bufferLen += moreLen) != buffer.length) continue;
            buffer = Arrays.copyOf(buffer, buffer.length * 2);
        }
        return Arrays.copyOf(buffer, bufferLen);
    }
}

