/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.nfc;

import android.nfc.tech.IsoDep;
import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.StringUtils;
import java.io.IOException;

public class NfcSmartCardConnection
implements SmartCardConnection {
    private final IsoDep card;

    NfcSmartCardConnection(IsoDep card) {
        this.card = card;
        Logger.d((String)"nfc connection opened");
    }

    public Transport getTransport() {
        return Transport.NFC;
    }

    public boolean isExtendedLengthApduSupported() {
        return this.card.isExtendedLengthApduSupported();
    }

    public byte[] sendAndReceive(byte[] apdu) throws IOException {
        Logger.d((String)("sent: " + StringUtils.bytesToHex((byte[])apdu)));
        byte[] received = this.card.transceive(apdu);
        Logger.d((String)("received: " + StringUtils.bytesToHex((byte[])received)));
        return received;
    }

    public void close() throws IOException {
        this.card.close();
        Logger.d((String)"nfc connection closed");
    }
}

