/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.nfc;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.Ndef;
import com.yubico.yubikit.android.transport.nfc.NfcSmartCardConnection;
import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.YubiKeyConnection;
import com.yubico.yubikit.core.YubiKeyDevice;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class NfcYubiKeyDevice
implements YubiKeyDevice {
    private final AtomicBoolean removed = new AtomicBoolean();
    private final ExecutorService executorService;
    private final Tag tag;
    private final int timeout;

    public NfcYubiKeyDevice(Tag tag, int timeout, ExecutorService executorService) {
        this.executorService = executorService;
        this.tag = tag;
        this.timeout = timeout;
    }

    public Tag getTag() {
        return this.tag;
    }

    private NfcSmartCardConnection openIso7816Connection() throws IOException {
        IsoDep card = IsoDep.get((Tag)this.tag);
        if (card == null) {
            throw new IOException("the tag does not support ISO-DEP");
        }
        card.setTimeout(this.timeout);
        card.connect();
        return new NfcSmartCardConnection(card);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    public byte[] readNdef() throws IOException {
        try (Ndef ndef = Ndef.get((Tag)this.tag);){
            if (ndef == null) throw new IOException("NDEF data missing or invalid");
            ndef.connect();
            NdefMessage message = ndef.getNdefMessage();
            if (message == null) throw new IOException("NDEF data missing or invalid");
            byte[] byArray = message.toByteArray();
            return byArray;
        }
        catch (FormatException e) {
            throw new IOException(e);
        }
    }

    public void remove(Runnable onRemoved) {
        this.removed.set(true);
        this.executorService.submit(() -> {
            try {
                IsoDep isoDep = IsoDep.get((Tag)this.tag);
                isoDep.connect();
                while (isoDep.isConnected()) {
                    Thread.sleep(250L);
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
            onRemoved.run();
        });
    }

    public Transport getTransport() {
        return Transport.NFC;
    }

    public boolean supportsConnection(Class<? extends YubiKeyConnection> connectionType) {
        return connectionType.isAssignableFrom(NfcSmartCardConnection.class);
    }

    private <T extends YubiKeyConnection> T openConnection(Class<T> connectionType) throws IOException {
        if (connectionType.isAssignableFrom(NfcSmartCardConnection.class)) {
            return (T)Objects.requireNonNull((YubiKeyConnection)connectionType.cast(this.openIso7816Connection()));
        }
        throw new IllegalStateException("The connection type is not supported by this session");
    }

    public <T extends YubiKeyConnection> void requestConnection(Class<T> connectionType, Callback<Result<T, IOException>> callback) {
        if (this.removed.get()) {
            callback.invoke((Object)Result.failure((Throwable)new IOException("Can't requestConnection after calling remove()")));
        } else {
            this.executorService.submit(() -> {
                try (Object connection = this.openConnection(connectionType);){
                    callback.invoke((Object)Result.success(connection));
                }
                catch (IOException e) {
                    callback.invoke((Object)Result.failure((Throwable)e));
                }
            });
        }
    }
}

