/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.yubico.yubikit.android.transport.usb.connection.ConnectionManager;
import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.UsbPid;
import com.yubico.yubikit.core.YubiKeyConnection;
import com.yubico.yubikit.core.YubiKeyDevice;
import com.yubico.yubikit.core.otp.OtpConnection;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;

public class UsbYubiKeyDevice
implements YubiKeyDevice,
Closeable {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ConnectionManager connectionManager;
    private final UsbManager usbManager;
    private final UsbDevice usbDevice;
    private final UsbPid usbPid;
    @Nullable
    private CachedOtpConnection otpConnection = null;
    @Nullable
    private Runnable onClosed = null;
    private static final Callback<Result<OtpConnection, IOException>> CLOSE_OTP = value -> {};

    public UsbYubiKeyDevice(UsbManager usbManager, UsbDevice usbDevice) throws IllegalArgumentException {
        if (usbDevice.getVendorId() != 4176) {
            throw new IllegalArgumentException("Invalid vendor id");
        }
        this.usbPid = UsbPid.fromValue((int)usbDevice.getProductId());
        this.connectionManager = new ConnectionManager(usbManager, usbDevice);
        this.usbDevice = usbDevice;
        this.usbManager = usbManager;
    }

    public boolean hasPermission() {
        return this.usbManager.hasPermission(this.usbDevice);
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public UsbPid getPid() {
        return this.usbPid;
    }

    public Transport getTransport() {
        return Transport.USB;
    }

    public boolean supportsConnection(Class<? extends YubiKeyConnection> connectionType) {
        return this.connectionManager.supportsConnection(connectionType);
    }

    public <T extends YubiKeyConnection> void requestConnection(Class<T> connectionType, Callback<Result<T, IOException>> callback) {
        if (!this.hasPermission()) {
            throw new IllegalStateException("Device access not permitted");
        }
        if (!this.supportsConnection(connectionType)) {
            throw new IllegalStateException("Unsupported connection type");
        }
        if (OtpConnection.class.isAssignableFrom(connectionType)) {
            Callback otpCallback = value -> callback.invoke(value);
            if (this.otpConnection == null) {
                this.otpConnection = new CachedOtpConnection(otpCallback);
            } else {
                this.otpConnection.queue.offer(otpCallback);
            }
        } else {
            if (this.otpConnection != null) {
                this.otpConnection.close();
                this.otpConnection = null;
            }
            this.executorService.submit(() -> {
                try (Object connection = this.connectionManager.openConnection(connectionType);){
                    callback.invoke((Object)Result.success(connection));
                }
                catch (IOException e) {
                    callback.invoke((Object)Result.failure((Throwable)e));
                }
            });
        }
    }

    public void setOnClosed(Runnable onClosed) {
        if (this.executorService.isTerminated()) {
            onClosed.run();
        } else {
            this.onClosed = onClosed;
        }
    }

    @Override
    public void close() {
        Logger.d((String)"Closing YubiKey device");
        if (this.otpConnection != null) {
            this.otpConnection.close();
            this.otpConnection = null;
        }
        if (this.onClosed != null) {
            this.executorService.submit(this.onClosed);
        }
        this.executorService.shutdown();
    }

    private class CachedOtpConnection
    implements Closeable {
        private final LinkedBlockingQueue<Callback<Result<OtpConnection, IOException>>> queue = new LinkedBlockingQueue();

        private CachedOtpConnection(Callback<Result<OtpConnection, IOException>> callback) {
            Logger.d((String)"Creating new CachedOtpConnection");
            this.queue.offer(callback);
            UsbYubiKeyDevice.this.executorService.submit(() -> {
                block16: {
                    try {
                        OtpConnection connection = UsbYubiKeyDevice.this.connectionManager.openConnection(OtpConnection.class);
                        block11: while (true) {
                            while (true) {
                                try {
                                    while (true) {
                                        Callback<Result<OtpConnection, IOException>> action;
                                        if ((action = this.queue.take()) == CLOSE_OTP) {
                                            Logger.d((String)"Closing CachedOtpConnection");
                                            break block16;
                                        }
                                        try {
                                            action.invoke((Object)Result.success((Object)connection));
                                            continue block11;
                                        }
                                        catch (Exception e) {
                                            Logger.e((String)"OtpConnection callback threw an exception", (Throwable)e);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        callback.invoke((Object)Result.failure((Throwable)e));
                    }
                }
            });
        }

        @Override
        public void close() {
            this.queue.offer((Callback<Result<OtpConnection, IOException>>)CLOSE_OTP);
        }
    }
}

