/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android;

import android.app.Activity;
import android.content.Context;
import com.yubico.yubikit.android.transport.nfc.NfcConfiguration;
import com.yubico.yubikit.android.transport.nfc.NfcNotAvailable;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyDevice;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyManager;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyManager;
import com.yubico.yubikit.core.util.Callback;
import javax.annotation.Nullable;

public final class YubiKitManager {
    private final UsbYubiKeyManager usbYubiKeyManager;
    @Nullable
    private final NfcYubiKeyManager nfcYubiKeyManager;

    @Nullable
    private static NfcYubiKeyManager buildNfcDeviceManager(Context context) {
        try {
            return new NfcYubiKeyManager(context, null);
        }
        catch (NfcNotAvailable e) {
            return null;
        }
    }

    public YubiKitManager(Context context) {
        this(new UsbYubiKeyManager(context.getApplicationContext()), YubiKitManager.buildNfcDeviceManager(context.getApplicationContext()));
    }

    public YubiKitManager(UsbYubiKeyManager usbYubiKeyManager, @Nullable NfcYubiKeyManager nfcYubiKeyManager) {
        this.usbYubiKeyManager = usbYubiKeyManager;
        this.nfcYubiKeyManager = nfcYubiKeyManager;
    }

    public void startUsbDiscovery(UsbConfiguration usbConfiguration, Callback<? super UsbYubiKeyDevice> listener) {
        this.usbYubiKeyManager.enable(usbConfiguration, listener);
    }

    public void startNfcDiscovery(NfcConfiguration nfcConfiguration, Activity activity, Callback<? super NfcYubiKeyDevice> listener) throws NfcNotAvailable {
        if (this.nfcYubiKeyManager == null) {
            throw new NfcNotAvailable("NFC is not available on this device", false);
        }
        this.nfcYubiKeyManager.enable(activity, nfcConfiguration, listener);
    }

    public void stopUsbDiscovery() {
        this.usbYubiKeyManager.disable();
    }

    public void stopNfcDiscovery(Activity activity) {
        if (this.nfcYubiKeyManager != null) {
            this.nfcYubiKeyManager.disable(activity);
        }
    }
}

