/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.nfc;

import android.nfc.tech.IsoDep;
import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.util.StringUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NfcSmartCardConnection
implements SmartCardConnection {
    private final IsoDep card;
    private static final Logger logger = LoggerFactory.getLogger(NfcSmartCardConnection.class);

    NfcSmartCardConnection(IsoDep card) {
        this.card = card;
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"nfc connection opened");
    }

    public Transport getTransport() {
        return Transport.NFC;
    }

    public boolean isExtendedLengthApduSupported() {
        return this.card.isExtendedLengthApduSupported();
    }

    public byte[] sendAndReceive(byte[] apdu) throws IOException {
        com.yubico.yubikit.core.internal.Logger.trace((Logger)logger, (String)"sent: {}", (Object)StringUtils.bytesToHex((byte[])apdu));
        byte[] received = this.card.transceive(apdu);
        com.yubico.yubikit.core.internal.Logger.trace((Logger)logger, (String)"received: {}", (Object)StringUtils.bytesToHex((byte[])received));
        return received;
    }

    public void close() throws IOException {
        this.card.close();
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"nfc connection closed");
    }

    public byte[] getAtr() {
        byte[] historicalBytes = this.card.getHistoricalBytes();
        return historicalBytes != null ? (byte[])historicalBytes.clone() : new byte[]{};
    }
}

