/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb.connection;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import com.yubico.yubikit.android.transport.usb.connection.UsbYubiKeyConnection;
import com.yubico.yubikit.core.otp.OtpConnection;
import java.io.IOException;

public class UsbOtpConnection
extends UsbYubiKeyConnection
implements OtpConnection {
    private static final int TIMEOUT = 1000;
    private static final int TYPE_CLASS = 32;
    private static final int RECIPIENT_INTERFACE = 1;
    private static final int HID_GET_REPORT = 1;
    private static final int HID_SET_REPORT = 9;
    private static final int REPORT_TYPE_FEATURE = 3;
    private final UsbDeviceConnection connection;
    private final UsbInterface hidInterface;
    private boolean closed = false;

    UsbOtpConnection(UsbDeviceConnection connection, UsbInterface hidInterface) {
        super(connection, hidInterface);
        this.connection = connection;
        this.hidInterface = hidInterface;
    }

    public void receive(byte[] report) throws IOException {
        int received = this.connection.controlTransfer(161, 1, 768, this.hidInterface.getId(), report, report.length, 1000);
        if (received != 8) {
            throw new IOException("Unexpected amount of data read: " + received);
        }
    }

    public void send(byte[] report) throws IOException {
        int sent = this.connection.controlTransfer(33, 9, 768, this.hidInterface.getId(), report, report.length, 1000);
        if (sent != 8) {
            throw new IOException("Unexpected amount of data sent: " + sent);
        }
    }

    @Override
    public void close() {
        this.closed = true;
        super.close();
    }

    public boolean isClosed() {
        return this.closed;
    }
}

