/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import com.yubico.yubikit.android.transport.usb.connection.ConnectionManager;
import com.yubico.yubikit.core.Transport;
import com.yubico.yubikit.core.UsbPid;
import com.yubico.yubikit.core.YubiKeyConnection;
import com.yubico.yubikit.core.YubiKeyDevice;
import com.yubico.yubikit.core.otp.OtpConnection;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsbYubiKeyDevice
implements YubiKeyDevice,
Closeable {
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final ConnectionManager connectionManager;
    private final UsbManager usbManager;
    private final UsbDevice usbDevice;
    private final UsbPid usbPid;
    @Nullable
    private CachedOtpConnection otpConnection = null;
    @Nullable
    private Runnable onClosed = null;
    private static final Logger logger = LoggerFactory.getLogger(UsbYubiKeyDevice.class);
    private static final Callback<Result<OtpConnection, IOException>> CLOSE_OTP = value -> {};

    public UsbYubiKeyDevice(UsbManager usbManager, UsbDevice usbDevice) throws IllegalArgumentException {
        if (usbDevice.getVendorId() != 4176) {
            throw new IllegalArgumentException("Invalid vendor id");
        }
        this.usbPid = UsbPid.fromValue((int)usbDevice.getProductId());
        this.connectionManager = new ConnectionManager(usbManager, usbDevice);
        this.usbDevice = usbDevice;
        this.usbManager = usbManager;
    }

    public boolean hasPermission() {
        return this.usbManager.hasPermission(this.usbDevice);
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public UsbPid getPid() {
        return this.usbPid;
    }

    public Transport getTransport() {
        return Transport.USB;
    }

    public boolean supportsConnection(Class<? extends YubiKeyConnection> connectionType) {
        return this.connectionManager.supportsConnection(connectionType);
    }

    public <T extends YubiKeyConnection> void requestConnection(Class<T> connectionType, Callback<Result<T, IOException>> callback) {
        this.verifyAccess(connectionType);
        if (OtpConnection.class.isAssignableFrom(connectionType)) {
            Callback otpCallback = value -> callback.invoke(value);
            if (this.otpConnection == null) {
                this.otpConnection = new CachedOtpConnection(otpCallback);
            } else {
                this.otpConnection.queue.offer(otpCallback);
            }
        } else {
            if (this.otpConnection != null) {
                this.otpConnection.close();
                this.otpConnection = null;
            }
            this.executorService.submit(() -> {
                try (Object connection = this.connectionManager.openConnection(connectionType);){
                    callback.invoke((Object)Result.success(connection));
                }
                catch (IOException e) {
                    callback.invoke((Object)Result.failure((Throwable)e));
                }
            });
        }
    }

    public <T extends YubiKeyConnection> T openConnection(Class<T> connectionType) throws IOException {
        this.verifyAccess(connectionType);
        return this.connectionManager.openConnection(connectionType);
    }

    public void setOnClosed(Runnable onClosed) {
        if (this.executorService.isTerminated()) {
            onClosed.run();
        } else {
            this.onClosed = onClosed;
        }
    }

    @Override
    public void close() {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Closing YubiKey device");
        if (this.otpConnection != null) {
            this.otpConnection.close();
            this.otpConnection = null;
        }
        if (this.onClosed != null) {
            this.executorService.submit(this.onClosed);
        }
        this.executorService.shutdown();
    }

    private <T extends YubiKeyConnection> void verifyAccess(Class<T> connectionType) {
        if (!this.hasPermission()) {
            throw new IllegalStateException("Device access not permitted");
        }
        if (!this.supportsConnection(connectionType)) {
            throw new IllegalStateException("Unsupported connection type");
        }
    }

    @Nonnull
    public String toString() {
        return "UsbYubiKeyDevice{usbDevice=" + this.usbDevice + ", usbPid=" + this.usbPid + '}';
    }

    private class CachedOtpConnection
    implements Closeable {
        private final LinkedBlockingQueue<Callback<Result<OtpConnection, IOException>>> queue = new LinkedBlockingQueue();

        private CachedOtpConnection(Callback<Result<OtpConnection, IOException>> callback) {
            com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Creating new CachedOtpConnection");
            this.queue.offer(callback);
            UsbYubiKeyDevice.this.executorService.submit(() -> {
                block16: {
                    try {
                        OtpConnection connection = UsbYubiKeyDevice.this.connectionManager.openConnection(OtpConnection.class);
                        block11: while (true) {
                            while (true) {
                                try {
                                    while (true) {
                                        Callback<Result<OtpConnection, IOException>> action;
                                        if ((action = this.queue.take()) == CLOSE_OTP) {
                                            com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Closing CachedOtpConnection");
                                            break block16;
                                        }
                                        try {
                                            action.invoke((Object)Result.success((Object)connection));
                                            continue block11;
                                        }
                                        catch (Exception e) {
                                            com.yubico.yubikit.core.internal.Logger.error((Logger)logger, (String)"OtpConnection callback threw an exception", (Object)e);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (InterruptedException e) {
                                    com.yubico.yubikit.core.internal.Logger.error((Logger)logger, (String)"InterruptedException when processing OtpConnection: ", (Object)e);
                                    continue;
                                }
                                break;
                            }
                        }
                        finally {
                            if (connection != null) {
                                connection.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        callback.invoke((Object)Result.failure((Throwable)e));
                    }
                }
            });
        }

        @Override
        public void close() {
            this.queue.offer((Callback<Result<OtpConnection, IOException>>)CLOSE_OTP);
        }
    }
}

