/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb.connection;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Pair;
import com.yubico.yubikit.android.transport.usb.connection.InterfaceConnectionHandler;
import com.yubico.yubikit.android.transport.usb.connection.UsbFidoConnection;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class FidoConnectionHandler
extends InterfaceConnectionHandler<UsbFidoConnection> {
    public FidoConnectionHandler() {
        super(3, 0);
    }

    @Override
    public UsbFidoConnection createConnection(UsbDevice usbDevice, UsbDeviceConnection usbDeviceConnection) throws IOException {
        UsbInterface usbInterface = this.getClaimedInterface(usbDevice, usbDeviceConnection);
        Pair<UsbEndpoint, UsbEndpoint> endpoints = FidoConnectionHandler.findEndpoints(usbInterface);
        return new UsbFidoConnection(usbDeviceConnection, usbInterface, (UsbEndpoint)endpoints.first, (UsbEndpoint)endpoints.second);
    }

    @Override
    protected UsbInterface getClaimedInterface(UsbDevice usbDevice, UsbDeviceConnection usbDeviceConnection) throws IOException {
        UsbInterface usbInterface = this.getInterface(usbDevice);
        if (usbInterface != null) {
            if (!usbDeviceConnection.claimInterface(usbInterface, true)) {
                throw new IOException("Unable to claim interface");
            }
            return usbInterface;
        }
        throw new IllegalStateException("The connection type is not available via this transport");
    }

    @Nullable
    private UsbInterface getInterface(UsbDevice usbDevice) {
        for (int i = 0; i < usbDevice.getInterfaceCount(); ++i) {
            UsbInterface usbInterface = usbDevice.getInterface(i);
            if (usbInterface.getInterfaceClass() != 3 || usbInterface.getInterfaceSubclass() != 0) continue;
            return usbInterface;
        }
        return null;
    }

    private static Pair<UsbEndpoint, UsbEndpoint> findEndpoints(UsbInterface usbInterface) {
        UsbEndpoint endpointIn = null;
        UsbEndpoint endpointOut = null;
        for (int i = 0; i < usbInterface.getEndpointCount(); ++i) {
            UsbEndpoint endpoint = usbInterface.getEndpoint(i);
            if (endpoint.getType() != 3) continue;
            if (endpoint.getDirection() == 128) {
                endpointIn = endpoint;
                continue;
            }
            endpointOut = endpoint;
        }
        return new Pair((Object)Objects.requireNonNull(endpointIn), (Object)Objects.requireNonNull(endpointOut));
    }
}

