/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb.connection;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.util.Pair;
import com.yubico.yubikit.android.transport.usb.connection.InterfaceConnectionHandler;
import com.yubico.yubikit.android.transport.usb.connection.UsbSmartCardConnection;
import java.io.IOException;

public class SmartCardConnectionHandler
extends InterfaceConnectionHandler<UsbSmartCardConnection> {
    public SmartCardConnectionHandler() {
        super(11, 0);
    }

    @Override
    public UsbSmartCardConnection createConnection(UsbDevice usbDevice, UsbDeviceConnection usbDeviceConnection) throws IOException {
        UsbInterface usbInterface = this.getClaimedInterface(usbDevice, usbDeviceConnection);
        Pair<UsbEndpoint, UsbEndpoint> endpoints = this.findEndpoints(usbInterface);
        return new UsbSmartCardConnection(usbDeviceConnection, usbInterface, (UsbEndpoint)endpoints.first, (UsbEndpoint)endpoints.second);
    }

    private Pair<UsbEndpoint, UsbEndpoint> findEndpoints(UsbInterface usbInterface) {
        UsbEndpoint endpointIn = null;
        UsbEndpoint endpointOut = null;
        for (int i = 0; i < usbInterface.getEndpointCount(); ++i) {
            UsbEndpoint endpoint = usbInterface.getEndpoint(i);
            if (endpoint.getType() != 2) continue;
            if (endpoint.getDirection() == 128) {
                endpointIn = endpoint;
                continue;
            }
            endpointOut = endpoint;
        }
        if (endpointIn != null && endpointOut != null) {
            return new Pair(endpointIn, endpointOut);
        }
        throw new IllegalStateException("Missing CCID bulk endpoints");
    }
}

