/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.transport.usb.connection;

import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import com.yubico.yubikit.android.transport.usb.connection.UsbYubiKeyConnection;
import com.yubico.yubikit.core.fido.FidoConnection;
import java.io.IOException;

public class UsbFidoConnection
extends UsbYubiKeyConnection
implements FidoConnection {
    private static final int TIMEOUT = 1000;
    private final UsbDeviceConnection connection;
    private final UsbEndpoint bulkIn;
    private final UsbEndpoint bulkOut;

    UsbFidoConnection(UsbDeviceConnection connection, UsbInterface intf, UsbEndpoint endpointIn, UsbEndpoint endpointOut) {
        super(connection, intf);
        this.connection = connection;
        this.bulkIn = endpointIn;
        this.bulkOut = endpointOut;
    }

    public void send(byte[] packet) throws IOException {
        int sent = this.connection.bulkTransfer(this.bulkOut, packet, packet.length, 1000);
        if (sent != 64) {
            throw new IOException("Failed to send full packed");
        }
    }

    public void receive(byte[] packet) throws IOException {
        int read = this.connection.bulkTransfer(this.bulkIn, packet, packet.length, 1000);
        if (read != 64) {
            throw new IOException("Failed to read full packed");
        }
    }
}

