/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.android.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;
import androidx.annotation.StringRes;
import com.yubico.yubikit.android.R;
import com.yubico.yubikit.android.YubiKitManager;
import com.yubico.yubikit.android.transport.nfc.NfcConfiguration;
import com.yubico.yubikit.android.transport.nfc.NfcNotAvailable;
import com.yubico.yubikit.android.transport.nfc.NfcYubiKeyDevice;
import com.yubico.yubikit.android.transport.usb.UsbConfiguration;
import com.yubico.yubikit.android.transport.usb.UsbYubiKeyDevice;
import com.yubico.yubikit.android.ui.YubiKeyPromptAction;
import com.yubico.yubikit.core.YubiKeyDevice;
import com.yubico.yubikit.core.application.CommandState;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YubiKeyPromptActivity
extends Activity {
    public static final String ARG_ACTION_CLASS = "ACTION_CLASS";
    public static final String ARG_ALLOW_USB = "ALLOW_USB";
    public static final String ARG_ALLOW_NFC = "ALLOW_NFC";
    public static final String ARG_TITLE_ID = "TITLE_ID";
    public static final String ARG_CONTENT_VIEW_ID = "CONTENT_VIEW_ID";
    public static final String ARG_CANCEL_BUTTON_ID = "CANCEL_BUTTON_ID";
    public static final String ARG_ENABLE_NFC_BUTTON_ID = "ENABLE_NFC_BUTTON_ID";
    public static final String ARG_HELP_TEXT_VIEW_ID = "HELP_TEXT_VIEW_ID";
    private final MyCommandState commandState = new MyCommandState();
    private YubiKitManager yubiKit;
    private YubiKeyPromptAction action;
    private boolean hasNfc = true;
    private int usbSessionCounter = 0;
    private boolean isDone = false;
    protected Button cancelButton;
    protected Button enableNfcButton;
    protected TextView helpTextView;
    private boolean allowUsb;
    private boolean allowNfc;
    private static final Logger logger = LoggerFactory.getLogger(YubiKeyPromptActivity.class);

    public static Intent createIntent(Context context, Class<? extends YubiKeyPromptAction> action, @StringRes int titleRes) {
        Intent intent = YubiKeyPromptActivity.createIntent(context, action);
        intent.putExtra(ARG_TITLE_ID, titleRes);
        return intent;
    }

    public static Intent createIntent(Context context, Class<? extends YubiKeyPromptAction> action) {
        Intent intent = new Intent(context, YubiKeyPromptActivity.class);
        intent.putExtra(ARG_ACTION_CLASS, action);
        return intent;
    }

    protected YubiKitManager getYubiKitManager() {
        return this.yubiKit;
    }

    protected CommandState getCommandState() {
        return this.commandState;
    }

    protected boolean isNfcEnabled() {
        return this.hasNfc;
    }

    protected void onYubiKeyDevice(YubiKeyDevice device, Runnable onDone) {
        this.action.onYubiKey(device, this.getIntent().getExtras(), this.commandState, (Callback<Pair<Integer, Intent>>)((Callback)value -> {
            if ((Integer)value.first == 101) {
                if (this.commandState.awaitingTouch) {
                    this.runOnUiThread(() -> this.helpTextView.setText(this.hasNfc ? R.string.yubikit_prompt_plug_in_or_tap : R.string.yubikit_prompt_plug_in));
                    this.commandState.awaitingTouch = false;
                }
            } else {
                this.provideResult((Integer)value.first, (Intent)value.second);
            }
            onDone.run();
        }));
    }

    protected void provideResult(int resultCode, Intent data) {
        this.setResult(resultCode, data);
        this.isDone = true;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        TextView titleText;
        super.onCreate(savedInstanceState);
        Bundle args = Objects.requireNonNull(this.getIntent().getExtras());
        this.allowUsb = args.getBoolean(ARG_ALLOW_USB, true);
        this.allowNfc = args.getBoolean(ARG_ALLOW_NFC, true);
        Class actionType = Build.VERSION.SDK_INT >= 33 ? (Class)args.getSerializable(ARG_ACTION_CLASS, Class.class) : (Class)args.getSerializable(ARG_ACTION_CLASS);
        try {
            if (actionType == null || !YubiKeyPromptAction.class.isAssignableFrom(actionType)) {
                throw new IllegalStateException("Missing or invalid ConnectionAction class");
            }
            this.action = (YubiKeyPromptAction)actionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalStateException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            com.yubico.yubikit.core.internal.Logger.error((Logger)logger, (String)"Unable to instantiate ConnectionAction", (Object)e);
            this.finish();
        }
        this.setContentView(args.getInt(ARG_CONTENT_VIEW_ID, R.layout.yubikit_yubikey_prompt_content));
        if (args.containsKey(ARG_TITLE_ID)) {
            this.setTitle(args.getInt(ARG_TITLE_ID));
        }
        if ((titleText = (TextView)this.findViewById(R.id.yubikit_prompt_title)) != null) {
            titleText.setText(this.getTitle());
        }
        this.helpTextView = (TextView)this.findViewById(args.getInt(ARG_HELP_TEXT_VIEW_ID, R.id.yubikit_prompt_help_text_view));
        this.cancelButton = (Button)this.findViewById(args.getInt(ARG_CANCEL_BUTTON_ID, R.id.yubikit_prompt_cancel_btn));
        this.cancelButton.setFocusable(false);
        this.cancelButton.setOnClickListener(v -> {
            this.commandState.cancel();
            this.setResult(0);
            this.finish();
        });
        this.yubiKit = new YubiKitManager((Context)this);
        if (this.allowUsb) {
            this.yubiKit.startUsbDiscovery(new UsbConfiguration(), (Callback<? super UsbYubiKeyDevice>)((Callback)device -> {
                ++this.usbSessionCounter;
                device.setOnClosed(() -> {
                    --this.usbSessionCounter;
                    if (this.usbSessionCounter == 0) {
                        this.runOnUiThread(() -> this.helpTextView.setText(this.hasNfc ? R.string.yubikit_prompt_plug_in_or_tap : R.string.yubikit_prompt_plug_in));
                    }
                });
                this.runOnUiThread(() -> this.helpTextView.setText(R.string.yubikit_prompt_wait));
                this.onYubiKeyDevice((YubiKeyDevice)device, this::finishIfDone);
            }));
        }
        if (this.allowNfc) {
            this.enableNfcButton = (Button)this.findViewById(args.getInt(ARG_ENABLE_NFC_BUTTON_ID, R.id.yubikit_prompt_enable_nfc_btn));
            this.enableNfcButton.setFocusable(false);
            this.enableNfcButton.setOnClickListener(v -> this.startActivity(new Intent("android.settings.NFC_SETTINGS")));
        }
    }

    protected void onResume() {
        block3: {
            super.onResume();
            if (this.allowNfc) {
                this.enableNfcButton.setVisibility(8);
                try {
                    this.yubiKit.startNfcDiscovery(new NfcConfiguration(), this, (Callback<? super NfcYubiKeyDevice>)((Callback)device -> this.onYubiKeyDevice((YubiKeyDevice)device, () -> {
                        this.runOnUiThread(() -> this.helpTextView.setText(R.string.yubikit_prompt_remove));
                        device.remove(this::finishIfDone);
                    })));
                }
                catch (NfcNotAvailable e) {
                    this.hasNfc = false;
                    this.helpTextView.setText(R.string.yubikit_prompt_plug_in);
                    if (!e.isDisabled()) break block3;
                    this.enableNfcButton.setVisibility(0);
                }
            }
        }
    }

    protected void onPause() {
        if (this.allowNfc) {
            this.yubiKit.stopNfcDiscovery(this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        if (this.allowUsb) {
            this.yubiKit.stopUsbDiscovery();
        }
        super.onDestroy();
    }

    private void finishIfDone() {
        if (this.isDone) {
            this.finish();
        }
    }

    private class MyCommandState
    extends CommandState {
        boolean awaitingTouch = false;

        private MyCommandState() {
        }

        public void onKeepAliveStatus(byte status) {
            if (!this.awaitingTouch && status == 2) {
                this.awaitingTouch = true;
                YubiKeyPromptActivity.this.runOnUiThread(() -> YubiKeyPromptActivity.this.helpTextView.setText(R.string.yubikit_prompt_uv));
            }
        }
    }
}

