/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv.jca;

import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import javax.annotation.Nullable;

public abstract class PivEcSignatureSpi
extends SignatureSpi {
    private final Callback<Callback<Result<PivSession, Exception>>> provider;
    @Nullable
    private PivPrivateKey.EcKey privateKey;

    protected PivEcSignatureSpi(Callback<Callback<Result<PivSession, Exception>>> provider) {
        this.provider = provider;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidKeyException("Can only be used for signing.");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof PivPrivateKey.EcKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        this.privateKey = (PivPrivateKey.EcKey)privateKey;
    }

    protected abstract void update(byte var1);

    protected abstract void update(byte[] var1, int var2, int var3);

    protected abstract byte[] digest();

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("Not initialized");
        }
        this.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("Not initialized");
        }
        this.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.privateKey == null) {
            throw new SignatureException("Not initialized");
        }
        try {
            return this.privateKey.rawSignOrDecrypt(this.provider, this.digest());
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new SignatureException("Not initialized");
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("ECDSA doesn't take parameters");
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("ECDSA doesn't take parameters");
    }

    public static class Hashed
    extends PivEcSignatureSpi {
        private final MessageDigest digest;

        Hashed(Callback<Callback<Result<PivSession, Exception>>> provider, String algorithm) throws NoSuchAlgorithmException {
            super(provider);
            this.digest = MessageDigest.getInstance(algorithm);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            super.engineInitSign(privateKey);
            this.digest.reset();
        }

        @Override
        protected void update(byte b) {
            this.digest.update(b);
        }

        @Override
        protected void update(byte[] b, int off, int len) {
            this.digest.update(b, off, len);
        }

        @Override
        protected byte[] digest() {
            return this.digest.digest();
        }
    }

    public static class Prehashed
    extends PivEcSignatureSpi {
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

        Prehashed(Callback<Callback<Result<PivSession, Exception>>> provider) {
            super(provider);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            super.engineInitSign(privateKey);
            this.buffer.reset();
        }

        @Override
        protected void update(byte b) {
            this.buffer.write(b);
        }

        @Override
        protected void update(byte[] b, int off, int len) {
            this.buffer.write(b, off, len);
        }

        @Override
        protected byte[] digest() {
            return this.buffer.toByteArray();
        }
    }
}

