/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv;

import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.security.spec.EllipticCurve;
import javax.annotation.Nonnull;

public enum KeyType {
    RSA1024(6, new RsaKeyParams(1024)),
    RSA2048(7, new RsaKeyParams(2048)),
    ECCP256(17, new EcKeyParams(256, "115792089210356248762697446949407573530086143415290314195533631308867097853948", "41058363725152142129326129780047268409114441015993725554835256314039467401291")),
    ECCP384(20, new EcKeyParams(384, "39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112316", "27580193559959705877849011840389048093056905856361568521428707301988689241309860865136260764883745107765439761230575"));

    public final byte value;
    public final KeyParams params;

    private KeyType(byte value, KeyParams params) {
        this.value = value;
        this.params = params;
    }

    public static KeyType fromValue(int value) {
        for (KeyType type : KeyType.values()) {
            if (type.value != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Not a valid KeyType:" + value);
    }

    public static KeyType fromKey(Key key) {
        for (KeyType keyType : KeyType.values()) {
            if (!keyType.params.matches(key)) continue;
            return keyType;
        }
        throw new IllegalArgumentException("Unsupported key type");
    }

    public static final class EcKeyParams
    extends KeyParams {
        private final BigInteger a;
        private final BigInteger b;

        private EcKeyParams(int bitLength, String a, String b) {
            super(Algorithm.EC, bitLength);
            this.a = new BigInteger(a);
            this.b = new BigInteger(b);
        }

        @Override
        protected boolean matches(Key key) {
            if (key instanceof ECKey) {
                EllipticCurve curve = ((ECKey)((Object)key)).getParams().getCurve();
                return curve.getField().getFieldSize() == this.bitLength && curve.getA().equals(this.a) && curve.getB().equals(this.b);
            }
            return false;
        }
    }

    public static final class RsaKeyParams
    extends KeyParams {
        private RsaKeyParams(int bitLength) {
            super(Algorithm.RSA, bitLength);
        }

        @Override
        protected boolean matches(Key key) {
            if (key instanceof RSAKey) {
                return ((RSAKey)((Object)key)).getModulus().bitLength() == this.bitLength;
            }
            return false;
        }
    }

    public static abstract class KeyParams {
        @Nonnull
        public final Algorithm algorithm;
        public final int bitLength;

        private KeyParams(Algorithm algorithm, int bitLength) {
            this.algorithm = algorithm;
            this.bitLength = bitLength;
        }

        protected abstract boolean matches(Key var1);
    }

    public static enum Algorithm {
        RSA,
        EC;

    }
}

