/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv.jca;

import com.yubico.yubikit.core.Logger;
import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.KeyType;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivCipherSpi;
import com.yubico.yubikit.piv.jca.PivEcSignatureSpi;
import com.yubico.yubikit.piv.jca.PivKeyAgreementSpi;
import com.yubico.yubikit.piv.jca.PivKeyPairGeneratorSpi;
import com.yubico.yubikit.piv.jca.PivKeyStoreSpi;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import com.yubico.yubikit.piv.jca.PivRsaSignatureSpi;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.crypto.NoSuchPaddingException;

public class PivProvider
extends Provider {
    private static final Map<String, String> ecAttributes = Collections.singletonMap("SupportedKeyClasses", PivPrivateKey.EcKey.class.getName());
    private static final Map<String, String> rsaAttributes = Collections.singletonMap("SupportedKeyClasses", PivPrivateKey.RsaKey.class.getName());
    private final Callback<Callback<Result<PivSession, Exception>>> sessionRequester;
    private final Map<KeyType, KeyPair> rsaDummyKeys = new HashMap<KeyType, KeyPair>();

    public PivProvider(PivSession session) {
        this((Callback<Callback<Result<PivSession, Exception>>>)((Callback)callback -> callback.invoke((Object)Result.success((Object)((Object)session)))));
    }

    public PivProvider(final Callback<Callback<Result<PivSession, Exception>>> sessionRequester) {
        super("YKPiv", 1.0, "JCA Provider for YubiKey PIV");
        this.sessionRequester = sessionRequester;
        Logger.d((String)("EC " + ecAttributes));
        Logger.d((String)("RSA " + rsaAttributes));
        this.putService(new Provider.Service(this, "Signature", "NONEwithECDSA", PivEcSignatureSpi.Prehashed.class.getName(), null, ecAttributes){

            @Override
            public Object newInstance(Object constructorParameter) {
                return new PivEcSignatureSpi.Prehashed((Callback<Callback<Result<PivSession, Exception>>>)sessionRequester);
            }
        });
        try {
            KeyPairGenerator rsaGen = KeyPairGenerator.getInstance("RSA");
            long start = System.currentTimeMillis();
            for (KeyType keyType : new KeyType[]{KeyType.RSA1024, KeyType.RSA2048}) {
                rsaGen.initialize(keyType.params.bitLength);
                this.rsaDummyKeys.put(keyType, rsaGen.generateKeyPair());
            }
            long end = System.currentTimeMillis();
            Logger.d((String)("TIME TAKEN: " + (end - start)));
            this.putService(new PivRsaCipherService());
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e((String)"Unable to support RSA, no underlying Provider with RSA capability", (Throwable)e);
        }
        Set<String> digests = Security.getAlgorithms("MessageDigest");
        for (String signatureOrig : Security.getAlgorithms("Signature")) {
            String signature = signatureOrig.toUpperCase();
            if (signature.endsWith("WITHECDSA")) {
                String digest = signature.substring(0, signature.length() - 9);
                if (!digests.contains(digest)) {
                    digest = digest.replace("SHA", "SHA-");
                }
                if (!digests.contains(digest)) continue;
                this.putService(new PivEcSignatureService(signature, digest, null));
                continue;
            }
            if (!this.rsaDummyKeys.isEmpty() && signature.endsWith("WITHRSA")) {
                this.putService(new PivRsaSignatureService(signature));
                continue;
            }
            if (!this.rsaDummyKeys.isEmpty() && signature.endsWith("PSS")) {
                this.putService(new PivRsaSignatureService(signature));
                continue;
            }
            if (!signature.equals("ECDSA")) continue;
            this.putService(new PivEcSignatureService("ECDSA", "SHA-1", Collections.singletonList("SHA1withECDSA")));
        }
        this.putService(new Provider.Service(this, "KeyPairGenerator", "YKPivRSA", PivKeyPairGeneratorSpi.Rsa.class.getName(), null, null){

            @Override
            public Object newInstance(Object constructorParameter) {
                return new PivKeyPairGeneratorSpi.Rsa((Callback<Callback<Result<PivSession, Exception>>>)sessionRequester);
            }
        });
        this.putService(new Provider.Service(this, "KeyPairGenerator", "YKPivEC", PivKeyPairGeneratorSpi.Ec.class.getName(), null, null){

            @Override
            public Object newInstance(Object constructorParameter) {
                return new PivKeyPairGeneratorSpi.Ec((Callback<Callback<Result<PivSession, Exception>>>)sessionRequester);
            }
        });
        this.putService(new Provider.Service(this, "KeyStore", "YKPiv", PivKeyStoreSpi.class.getName(), null, null){

            @Override
            public Object newInstance(Object constructorParameter) {
                return new PivKeyStoreSpi((Callback<Callback<Result<PivSession, Exception>>>)sessionRequester);
            }
        });
        this.putService(new Provider.Service(this, "KeyAgreement", "ECDH", PivKeyAgreementSpi.class.getName(), null, ecAttributes){

            @Override
            public Object newInstance(Object constructorParameter) {
                return new PivKeyAgreementSpi((Callback<Callback<Result<PivSession, Exception>>>)sessionRequester);
            }
        });
    }

    @Override
    public synchronized boolean equals(Object o) {
        return o instanceof PivProvider && super.equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    private class PivRsaCipherService
    extends Provider.Service {
        public PivRsaCipherService() {
            super(PivProvider.this, "Cipher", "RSA", PivCipherSpi.class.getName(), null, rsaAttributes);
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                return new PivCipherSpi((Callback<Callback<Result<PivSession, Exception>>>)PivProvider.this.sessionRequester, PivProvider.this.rsaDummyKeys);
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException(e);
            }
        }
    }

    private class PivRsaSignatureService
    extends Provider.Service {
        public PivRsaSignatureService(String algorithm) {
            super(PivProvider.this, "Signature", algorithm, PivRsaSignatureSpi.class.getName(), null, rsaAttributes);
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            try {
                return new PivRsaSignatureSpi((Callback<Callback<Result<PivSession, Exception>>>)PivProvider.this.sessionRequester, PivProvider.this.rsaDummyKeys, this.getAlgorithm());
            }
            catch (NoSuchPaddingException e) {
                throw new NoSuchAlgorithmException("No underlying Provider supporting " + this.getAlgorithm() + " available.");
            }
        }
    }

    private class PivEcSignatureService
    extends Provider.Service {
        private final String digest;

        public PivEcSignatureService(String algorithm, @Nullable String digest, List<String> aliases) {
            super(PivProvider.this, "Signature", algorithm, PivEcSignatureSpi.Hashed.class.getName(), aliases, ecAttributes);
            this.digest = digest;
        }

        @Override
        public Object newInstance(Object constructorParameter) throws NoSuchAlgorithmException {
            return new PivEcSignatureSpi.Hashed((Callback<Callback<Result<PivSession, Exception>>>)PivProvider.this.sessionRequester, this.digest);
        }
    }
}

