/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv;

import com.yubico.yubikit.core.keys.EllipticCurveValues;
import com.yubico.yubikit.core.keys.PrivateKeyValues;
import com.yubico.yubikit.core.keys.PublicKeyValues;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import javax.annotation.Nonnull;

public enum KeyType {
    RSA1024(6, new RsaKeyParams(1024)),
    RSA2048(7, new RsaKeyParams(2048)),
    ECCP256(17, new EcKeyParams(EllipticCurveValues.SECP256R1)),
    ECCP384(20, new EcKeyParams(EllipticCurveValues.SECP384R1));

    public final byte value;
    public final KeyParams params;

    private KeyType(byte value, KeyParams params) {
        this.value = value;
        this.params = params;
    }

    public static KeyType fromValue(int value) {
        for (KeyType type : KeyType.values()) {
            if (type.value != value) continue;
            return type;
        }
        throw new IllegalArgumentException("Not a valid KeyType:" + value);
    }

    public static KeyType fromKeyParams(PrivateKeyValues keyValues) {
        block3: {
            block2: {
                if (!(keyValues instanceof PrivateKeyValues.Rsa)) break block2;
                for (KeyType keyType : KeyType.values()) {
                    if (!(keyType.params instanceof RsaKeyParams) || keyValues.getBitLength() != keyType.params.bitLength) continue;
                    return keyType;
                }
                break block3;
            }
            if (!(keyValues instanceof PrivateKeyValues.Ec)) break block3;
            for (KeyType keyType : KeyType.values()) {
                if (!(keyType.params instanceof EcKeyParams) || ((PrivateKeyValues.Ec)keyValues).getCurveParams() != ((EcKeyParams)keyType.params).ellipticCurveValues) continue;
                return keyType;
            }
        }
        throw new IllegalArgumentException("Unsupported key type");
    }

    public static KeyType fromKey(Key key) {
        if (key instanceof RSAKey) {
            for (KeyType keyType : KeyType.values()) {
                if (keyType.params.algorithm != Algorithm.RSA || keyType.params.bitLength != ((RSAKey)((Object)key)).getModulus().bitLength()) continue;
                return keyType;
            }
        } else {
            EllipticCurveValues ellipticCurveValues;
            if (key instanceof ECPublicKey) {
                ellipticCurveValues = ((PublicKeyValues.Ec)PublicKeyValues.fromPublicKey((PublicKey)((ECPublicKey)key))).getCurveParams();
            } else if (key instanceof ECPrivateKey) {
                ellipticCurveValues = ((PrivateKeyValues.Ec)PrivateKeyValues.fromPrivateKey((PrivateKey)((ECPrivateKey)key))).getCurveParams();
            } else {
                throw new IllegalArgumentException("Unsupported key type");
            }
            for (KeyType keyType : KeyType.values()) {
                if (!(keyType.params instanceof EcKeyParams) || ((EcKeyParams)keyType.params).ellipticCurveValues != ellipticCurveValues) continue;
                return keyType;
            }
        }
        throw new IllegalArgumentException("Unsupported key type");
    }

    public static abstract class KeyParams {
        @Nonnull
        public final Algorithm algorithm;
        public final int bitLength;

        private KeyParams(Algorithm algorithm, int bitLength) {
            this.algorithm = algorithm;
            this.bitLength = bitLength;
        }
    }

    public static final class RsaKeyParams
    extends KeyParams {
        private RsaKeyParams(int bitLength) {
            super(Algorithm.RSA, bitLength);
        }
    }

    public static final class EcKeyParams
    extends KeyParams {
        private final EllipticCurveValues ellipticCurveValues;

        private EcKeyParams(EllipticCurveValues ellipticCurveValues) {
            super(Algorithm.EC, ellipticCurveValues.getBitLength());
            this.ellipticCurveValues = ellipticCurveValues;
        }

        EllipticCurveValues getCurveParams() {
            return this.ellipticCurveValues;
        }
    }

    public static enum Algorithm {
        RSA,
        EC;

    }
}

