/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv;

import com.yubico.yubikit.piv.KeyType;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

@Deprecated
class Padding {
    private static final String RAW_RSA = "RSA/ECB/NoPadding";
    private static final Pattern ECDSA_HASH_PATTERN = Pattern.compile("^(.+)withECDSA$", 2);
    private static final Pattern SHA_PATTERN = Pattern.compile("^SHA[0-9]+$", 2);

    Padding() {
    }

    static byte[] pad(KeyType keyType, byte[] message, Signature algorithm) throws NoSuchAlgorithmException {
        byte[] payload;
        KeyType.KeyParams params = keyType.params;
        switch (params.algorithm) {
            case RSA: {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance(params.algorithm.name());
                kpg.initialize(params.bitLength);
                KeyPair kp = kpg.generateKeyPair();
                try {
                    algorithm.initSign(kp.getPrivate());
                    algorithm.update(message);
                    Cipher rsa = Cipher.getInstance(RAW_RSA);
                    rsa.init(1, kp.getPublic());
                    payload = rsa.doFinal(algorithm.sign());
                    break;
                }
                catch (InvalidKeyException | SignatureException | BadPaddingException | IllegalBlockSizeException e) {
                    throw new IllegalStateException(e);
                }
                catch (NoSuchPaddingException e) {
                    throw new UnsupportedOperationException("SecurityProvider doesn't support RSA without padding", e);
                }
            }
            case EC: {
                byte[] hash;
                Matcher matcher = ECDSA_HASH_PATTERN.matcher(algorithm.getAlgorithm());
                if (!matcher.find()) {
                    throw new IllegalArgumentException("Invalid algorithm for given key");
                }
                String hashAlgorithm = matcher.group(1);
                if ("NONE".equals(hashAlgorithm)) {
                    hash = message;
                } else {
                    if (SHA_PATTERN.matcher(hashAlgorithm).matches()) {
                        hashAlgorithm = hashAlgorithm.replace("SHA", "SHA-");
                    }
                    hash = MessageDigest.getInstance(hashAlgorithm).digest(message);
                }
                int byteLength = params.bitLength / 8;
                if (hash.length > byteLength) {
                    payload = Arrays.copyOf(hash, byteLength);
                    break;
                }
                if (hash.length < byteLength) {
                    payload = new byte[byteLength];
                    System.arraycopy(hash, 0, payload, payload.length - hash.length, hash.length);
                    break;
                }
                payload = hash;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return payload;
    }

    static byte[] unpad(byte[] decrypted, Cipher algorithm) throws NoSuchPaddingException, NoSuchAlgorithmException, BadPaddingException {
        Cipher rsa = Cipher.getInstance(RAW_RSA);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(KeyType.Algorithm.RSA.name());
        kpg.initialize(decrypted.length * 8);
        KeyPair kp = kpg.generateKeyPair();
        try {
            rsa.init(1, kp.getPublic());
            algorithm.init(2, kp.getPrivate());
            return algorithm.doFinal(rsa.doFinal(decrypted));
        }
        catch (InvalidKeyException | IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        }
    }
}

