/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv;

import com.yubico.yubikit.core.Version;
import com.yubico.yubikit.core.application.ApplicationNotAvailableException;
import com.yubico.yubikit.core.application.ApplicationSession;
import com.yubico.yubikit.core.application.BadResponseException;
import com.yubico.yubikit.core.application.Feature;
import com.yubico.yubikit.core.keys.EllipticCurveValues;
import com.yubico.yubikit.core.keys.PrivateKeyValues;
import com.yubico.yubikit.core.keys.PublicKeyValues;
import com.yubico.yubikit.core.smartcard.Apdu;
import com.yubico.yubikit.core.smartcard.ApduException;
import com.yubico.yubikit.core.smartcard.ApduFormat;
import com.yubico.yubikit.core.smartcard.AppId;
import com.yubico.yubikit.core.smartcard.SmartCardConnection;
import com.yubico.yubikit.core.smartcard.SmartCardProtocol;
import com.yubico.yubikit.core.util.ByteUtils;
import com.yubico.yubikit.core.util.RandomUtils;
import com.yubico.yubikit.core.util.StringUtils;
import com.yubico.yubikit.core.util.Tlv;
import com.yubico.yubikit.core.util.Tlvs;
import com.yubico.yubikit.piv.GzipUtils;
import com.yubico.yubikit.piv.InvalidPinException;
import com.yubico.yubikit.piv.KeyType;
import com.yubico.yubikit.piv.ManagementKeyMetadata;
import com.yubico.yubikit.piv.ManagementKeyType;
import com.yubico.yubikit.piv.ObjectId;
import com.yubico.yubikit.piv.Padding;
import com.yubico.yubikit.piv.PinMetadata;
import com.yubico.yubikit.piv.PinPolicy;
import com.yubico.yubikit.piv.Slot;
import com.yubico.yubikit.piv.SlotMetadata;
import com.yubico.yubikit.piv.TouchPolicy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PivSession
extends ApplicationSession<PivSession> {
    public static final Feature<PivSession> FEATURE_P384 = new Feature.Versioned("Curve P384", 4, 0, 0);
    public static final Feature<PivSession> FEATURE_USAGE_POLICY = new Feature.Versioned("PIN/Touch Policy", 4, 0, 0);
    public static final Feature<PivSession> FEATURE_TOUCH_CACHED = new Feature.Versioned("Cached Touch Policy", 4, 3, 0);
    public static final Feature<PivSession> FEATURE_ATTESTATION = new Feature.Versioned("Attestation", 4, 3, 0);
    public static final Feature<PivSession> FEATURE_SERIAL = new Feature.Versioned("Serial Number", 5, 0, 0);
    public static final Feature<PivSession> FEATURE_METADATA = new Feature.Versioned("Metadata", 5, 3, 0);
    public static final Feature<PivSession> FEATURE_AES_KEY = new Feature.Versioned("AES Management Key", 5, 4, 0);
    public static final Feature<PivSession> FEATURE_RSA_GENERATION = new Feature<PivSession>("RSA key generation"){

        public boolean isSupportedBy(Version version) {
            return version.isLessThan(4, 2, 6) || version.isAtLeast(4, 3, 5);
        }
    };
    private static final int PIN_LEN = 8;
    private static final int SLOT_CARD_MANAGEMENT = 155;
    private static final byte INS_VERIFY = 32;
    private static final byte INS_CHANGE_REFERENCE = 36;
    private static final byte INS_RESET_RETRY = 44;
    private static final byte INS_GENERATE_ASYMMETRIC = 71;
    private static final byte INS_AUTHENTICATE = -121;
    private static final byte INS_GET_DATA = -53;
    private static final byte INS_PUT_DATA = -37;
    private static final byte INS_GET_METADATA = -9;
    private static final byte INS_GET_SERIAL = -8;
    private static final byte INS_ATTEST = -7;
    private static final byte INS_SET_PIN_RETRIES = -6;
    private static final byte INS_RESET = -5;
    private static final byte INS_GET_VERSION = -3;
    private static final byte INS_IMPORT_KEY = -2;
    private static final byte INS_SET_MGMKEY = -1;
    private static final int TAG_AUTH_WITNESS = 128;
    private static final int TAG_AUTH_CHALLENGE = 129;
    private static final int TAG_AUTH_RESPONSE = 130;
    private static final int TAG_AUTH_EXPONENTIATION = 133;
    private static final int TAG_GEN_ALGORITHM = 128;
    private static final int TAG_OBJ_DATA = 83;
    private static final int TAG_OBJ_ID = 92;
    private static final int TAG_CERTIFICATE = 112;
    private static final int TAG_CERT_INFO = 113;
    private static final int TAG_DYN_AUTH = 124;
    private static final int TAG_LRC = 254;
    private static final int TAG_PIN_POLICY = 170;
    private static final int TAG_TOUCH_POLICY = 171;
    private static final int TAG_METADATA_ALGO = 1;
    private static final int TAG_METADATA_POLICY = 2;
    private static final int TAG_METADATA_ORIGIN = 3;
    private static final int TAG_METADATA_PUBLIC_KEY = 4;
    private static final int TAG_METADATA_IS_DEFAULT = 5;
    private static final int TAG_METADATA_RETRIES = 6;
    private static final byte ORIGIN_GENERATED = 1;
    private static final byte ORIGIN_IMPORTED = 2;
    private static final int INDEX_PIN_POLICY = 0;
    private static final int INDEX_TOUCH_POLICY = 1;
    private static final int INDEX_RETRIES_TOTAL = 0;
    private static final int INDEX_RETRIES_REMAINING = 1;
    private static final byte PIN_P2 = -128;
    private static final byte PUK_P2 = -127;
    private final SmartCardProtocol protocol;
    private final Version version;
    private int currentPinAttempts = 3;
    private int maxPinAttempts = 3;
    private static final Logger logger = LoggerFactory.getLogger(PivSession.class);

    public PivSession(SmartCardConnection connection) throws IOException, ApduException, ApplicationNotAvailableException {
        this.protocol = new SmartCardProtocol(connection);
        this.protocol.select(AppId.PIV);
        this.version = Version.fromBytes((byte[])this.protocol.sendAndReceive(new Apdu(0, -3, 0, 0, null)));
        this.protocol.enableWorkarounds(this.version);
        if (connection.isExtendedLengthApduSupported() && this.version.isAtLeast(4, 0, 0)) {
            this.protocol.setApduFormat(ApduFormat.EXTENDED);
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"PIV session initialized (version={})", (Object)this.version);
    }

    public void close() throws IOException {
        this.protocol.close();
    }

    public Version getVersion() {
        return this.version;
    }

    public int getSerialNumber() throws IOException, ApduException {
        this.require(FEATURE_SERIAL);
        return ByteBuffer.wrap(this.protocol.sendAndReceive(new Apdu(0, -8, 0, 0, null))).getInt();
    }

    public void reset() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Preparing PIV reset");
        this.blockPin();
        this.blockPuk();
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Sending reset");
        this.protocol.sendAndReceive(new Apdu(0, -5, 0, 0, null));
        this.currentPinAttempts = 3;
        this.maxPinAttempts = 3;
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"PIV application data reset performed");
    }

    public void authenticate(ManagementKeyType keyType, byte[] managementKey) throws IOException, ApduException, BadResponseException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Authenticating with key type: {}", (Object)((Object)keyType));
        if (managementKey.length != keyType.keyLength) {
            throw new IllegalArgumentException(String.format("Management Key must be %d bytes", keyType.keyLength));
        }
        byte[] request = new Tlv(124, new Tlv(128, null).getBytes()).getBytes();
        byte[] response = this.protocol.sendAndReceive(new Apdu(0, -121, (int)keyType.value, 155, request));
        byte[] witness = Tlvs.unpackValue((int)128, (byte[])Tlvs.unpackValue((int)124, (byte[])response));
        SecretKeySpec key = new SecretKeySpec(managementKey, keyType.cipherName);
        try {
            LinkedHashMap<Integer, byte[]> dataTlvs = new LinkedHashMap<Integer, byte[]>();
            Cipher cipher = Cipher.getInstance(keyType.cipherName + "/ECB/NoPadding");
            cipher.init(2, key);
            dataTlvs.put(128, cipher.doFinal(witness));
            byte[] challenge = RandomUtils.getRandomBytes((int)keyType.challengeLength);
            dataTlvs.put(129, challenge);
            request = new Tlv(124, Tlvs.encodeMap(dataTlvs)).getBytes();
            response = this.protocol.sendAndReceive(new Apdu(0, -121, (int)keyType.value, 155, request));
            byte[] encryptedData = Tlvs.unpackValue((int)130, (byte[])Tlvs.unpackValue((int)124, (byte[])response));
            cipher.init(1, key);
            byte[] expectedData = cipher.doFinal(challenge);
            if (!MessageDigest.isEqual(encryptedData, expectedData)) {
                com.yubico.yubikit.core.internal.Logger.trace((Logger)logger, (String)"Expected response: {} and actual response {}", (Object)StringUtils.bytesToHex((byte[])expectedData), (Object)StringUtils.bytesToHex((byte[])encryptedData));
                throw new BadResponseException("Calculated response for challenge is incorrect");
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public byte[] sign(Slot slot, KeyType keyType, byte[] message, Signature algorithm) throws IOException, ApduException, BadResponseException, NoSuchAlgorithmException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Signing data with key in slot {} of type {} using algorithm {}", (Object[])new Object[]{slot, keyType, algorithm});
        byte[] payload = Padding.pad(keyType, message, algorithm);
        return this.usePrivateKey(slot, keyType, payload, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] rawSignOrDecrypt(Slot slot, KeyType keyType, byte[] payload) throws IOException, ApduException, BadResponseException {
        byte[] padded;
        int byteLength = keyType.params.bitLength / 8;
        if (payload.length > byteLength) {
            if (keyType.params.algorithm != KeyType.Algorithm.EC) throw new IllegalArgumentException("Payload too large for key");
            padded = Arrays.copyOf(payload, byteLength);
        } else if (payload.length < byteLength) {
            padded = new byte[byteLength];
            System.arraycopy(payload, 0, padded, padded.length - payload.length, payload.length);
        } else {
            padded = payload;
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Decrypting data with key in slot {} of type {}", (Object)((Object)slot), (Object)((Object)keyType));
        return this.usePrivateKey(slot, keyType, padded, false);
    }

    @Deprecated
    public byte[] decrypt(Slot slot, byte[] cipherText, Cipher algorithm) throws IOException, ApduException, BadResponseException, NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException {
        KeyType keyType;
        switch (cipherText.length) {
            case 128: {
                keyType = KeyType.RSA1024;
                break;
            }
            case 256: {
                keyType = KeyType.RSA2048;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid length of ciphertext");
            }
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Decrypting data with key in slot {} of type {}", (Object)((Object)slot), (Object)((Object)keyType));
        return Padding.unpad(this.usePrivateKey(slot, keyType, cipherText, false), algorithm);
    }

    @Deprecated
    public byte[] calculateSecret(Slot slot, ECPublicKey peerPublicKey) throws IOException, ApduException, BadResponseException {
        return this.calculateSecret(slot, peerPublicKey.getW());
    }

    public byte[] calculateSecret(Slot slot, ECPoint peerPublicKey) throws IOException, ApduException, BadResponseException {
        KeyType keyType = peerPublicKey.getAffineX().bitLength() > 256 ? KeyType.ECCP384 : KeyType.ECCP256;
        byte[] encodedPoint = new PublicKeyValues.Ec(((KeyType.EcKeyParams)keyType.params).getCurveParams(), peerPublicKey.getAffineX(), peerPublicKey.getAffineY()).getEncodedPoint();
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Performing key agreement with key in slot {} of type {}", (Object)((Object)slot), (Object)((Object)keyType));
        return this.usePrivateKey(slot, keyType, encodedPoint, true);
    }

    private byte[] usePrivateKey(Slot slot, KeyType keyType, byte[] message, boolean exponentiation) throws IOException, ApduException, BadResponseException {
        LinkedHashMap<Integer, byte[]> dataTlvs = new LinkedHashMap<Integer, byte[]>();
        dataTlvs.put(130, null);
        dataTlvs.put(exponentiation ? 133 : 129, message);
        byte[] request = new Tlv(124, Tlvs.encodeMap(dataTlvs)).getBytes();
        try {
            byte[] response = this.protocol.sendAndReceive(new Apdu(0, -121, (int)keyType.value, slot.value, request));
            return Tlvs.unpackValue((int)130, (byte[])Tlvs.unpackValue((int)124, (byte[])response));
        }
        catch (ApduException e) {
            if (27264 == e.getSw()) {
                throw new ApduException(e.getSw(), String.format(Locale.ROOT, "Make sure that %s key is generated on slot %02X", keyType.name(), slot.value));
            }
            throw e;
        }
    }

    public void setManagementKey(ManagementKeyType keyType, byte[] managementKey, boolean requireTouch) throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Setting management key of type: {}", (Object)((Object)keyType));
        if (keyType != ManagementKeyType.TDES) {
            this.require(FEATURE_AES_KEY);
        }
        if (requireTouch) {
            this.require(FEATURE_USAGE_POLICY);
        }
        if (managementKey.length != keyType.keyLength) {
            throw new IllegalArgumentException(String.format("Management key must be %d bytes", keyType.keyLength));
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(keyType.value);
        stream.write(new Tlv(155, managementKey).getBytes());
        this.protocol.sendAndReceive(new Apdu(0, -1, 255, requireTouch ? 254 : 255, stream.toByteArray()));
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"Management key set");
    }

    public void verifyPin(char[] pin) throws IOException, ApduException, InvalidPinException {
        try {
            com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Verifying PIN");
            this.protocol.sendAndReceive(new Apdu(0, 32, 0, -128, PivSession.pinBytes(pin)));
            this.currentPinAttempts = this.maxPinAttempts;
        }
        catch (ApduException e) {
            int retries = this.getRetriesFromCode(e.getSw());
            if (retries >= 0) {
                this.currentPinAttempts = retries;
                throw new InvalidPinException(retries);
            }
            throw e;
        }
    }

    public int getPinAttempts() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Getting PIN attempts");
        if (this.supports(FEATURE_METADATA)) {
            return this.getPinMetadata().getAttemptsRemaining();
        }
        try {
            this.protocol.sendAndReceive(new Apdu(0, 32, 0, -128, null));
            com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Using cached value, may be incorrect");
            return this.currentPinAttempts;
        }
        catch (ApduException e) {
            int retries = this.getRetriesFromCode(e.getSw());
            if (retries >= 0) {
                this.currentPinAttempts = retries;
                com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Using value from empty verify");
                return retries;
            }
            throw e;
        }
    }

    public void changePin(char[] oldPin, char[] newPin) throws IOException, ApduException, InvalidPinException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Changing PIN");
        this.changeReference((byte)36, (byte)-128, oldPin, newPin);
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"New PIN set");
    }

    public void changePuk(char[] oldPuk, char[] newPuk) throws IOException, ApduException, InvalidPinException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Changing PUK");
        this.changeReference((byte)36, (byte)-127, oldPuk, newPuk);
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"New PUK set");
    }

    public void unblockPin(char[] puk, char[] newPin) throws IOException, ApduException, InvalidPinException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Using PUK to set new PIN");
        this.changeReference((byte)44, (byte)-128, puk, newPin);
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"New PIN set");
    }

    public void setPinAttempts(int pinAttempts, int pukAttempts) throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Setting PIN/PUK attempts ({}, {})", (Object)pinAttempts, (Object)pukAttempts);
        this.protocol.sendAndReceive(new Apdu(0, -6, pinAttempts, pukAttempts, null));
        this.maxPinAttempts = pinAttempts;
        this.currentPinAttempts = pinAttempts;
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"PIN/PUK attempts set");
    }

    public PinMetadata getPinMetadata() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Getting PIN metadata");
        return this.getPinPukMetadata((byte)-128);
    }

    public PinMetadata getPukMetadata() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Getting PUK metadata");
        return this.getPinPukMetadata((byte)-127);
    }

    private PinMetadata getPinPukMetadata(byte p2) throws IOException, ApduException {
        this.require(FEATURE_METADATA);
        Map data = Tlvs.decodeMap((byte[])this.protocol.sendAndReceive(new Apdu(0, -9, 0, (int)p2, null)));
        byte[] retries = (byte[])data.get(6);
        return new PinMetadata(((byte[])data.get(5))[0] != 0, retries[0], retries[1]);
    }

    public ManagementKeyMetadata getManagementKeyMetadata() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Getting management key metadata");
        this.require(FEATURE_METADATA);
        Map data = Tlvs.decodeMap((byte[])this.protocol.sendAndReceive(new Apdu(0, -9, 0, 155, null)));
        return new ManagementKeyMetadata(data.containsKey(1) ? ManagementKeyType.fromValue(((byte[])data.get(1))[0]) : ManagementKeyType.TDES, ((byte[])data.get(5))[0] != 0, TouchPolicy.fromValue(((byte[])data.get(2))[1]));
    }

    public SlotMetadata getSlotMetadata(Slot slot) throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Getting metadata for slot {}", (Object)((Object)slot));
        this.require(FEATURE_METADATA);
        Map data = Tlvs.decodeMap((byte[])this.protocol.sendAndReceive(new Apdu(0, -9, 0, slot.value, null)));
        byte[] policy = (byte[])data.get(2);
        return new SlotMetadata(KeyType.fromValue(((byte[])data.get(1))[0]), PinPolicy.fromValue(policy[0]), TouchPolicy.fromValue(policy[1]), ((byte[])data.get(3))[0] == 1, (byte[])data.get(4));
    }

    public X509Certificate getCertificate(Slot slot) throws IOException, ApduException, BadResponseException {
        boolean isCompressed;
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Reading certificate in slot {}", (Object)((Object)slot));
        byte[] objectData = this.getObject(slot.objectId);
        Map certData = Tlvs.decodeMap((byte[])objectData);
        byte[] certInfo = (byte[])certData.get(113);
        byte[] cert = (byte[])certData.get(112);
        boolean bl = isCompressed = certInfo != null && certInfo.length > 0 && certInfo[0] != 0;
        if (isCompressed) {
            try {
                cert = GzipUtils.decompress(cert);
            }
            catch (IOException e) {
                throw new BadResponseException("Failed to decompress certificate", (Throwable)e);
            }
        }
        try {
            return this.parseCertificate(cert);
        }
        catch (CertificateException e) {
            throw new BadResponseException("Failed to parse certificate: ", (Throwable)e);
        }
    }

    public void putCertificate(Slot slot, X509Certificate certificate, boolean compress) throws IOException, ApduException {
        byte[] certBytes;
        byte[] certInfo = new byte[]{compress ? (byte)1 : 0};
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Storing {}certificate in slot {}", (Object)(compress ? "compressed " : ""), (Object)((Object)slot));
        try {
            certBytes = certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("Failed to get encoded version of certificate", e);
        }
        if (compress) {
            certBytes = GzipUtils.compress(certBytes);
        }
        LinkedHashMap<Integer, byte[]> requestTlv = new LinkedHashMap<Integer, byte[]>();
        requestTlv.put(112, certBytes);
        requestTlv.put(113, certInfo);
        requestTlv.put(254, null);
        this.putObject(slot.objectId, Tlvs.encodeMap(requestTlv));
    }

    public void putCertificate(Slot slot, X509Certificate certificate) throws IOException, ApduException {
        this.putCertificate(slot, certificate, false);
    }

    public X509Certificate attestKey(Slot slot) throws IOException, ApduException, BadResponseException {
        this.require(FEATURE_ATTESTATION);
        try {
            byte[] responseData = this.protocol.sendAndReceive(new Apdu(0, -7, slot.value, 0, null));
            com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Attested key in slot {}", (Object)((Object)slot));
            return this.parseCertificate(responseData);
        }
        catch (ApduException e) {
            if (27264 == e.getSw()) {
                throw new ApduException(e.getSw(), String.format(Locale.ROOT, "Make sure that key is generated on slot %02X", slot.value));
            }
            throw e;
        }
        catch (CertificateException e) {
            throw new BadResponseException("Failed to parse certificate", (Throwable)e);
        }
    }

    public void deleteCertificate(Slot slot) throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Deleting certificate in slot {}", (Object)((Object)slot));
        this.putObject(slot.objectId, null);
    }

    static PublicKeyValues parsePublicKeyFromDevice(KeyType keyType, byte[] encoded) {
        Map dataObjects = Tlvs.decodeMap((byte[])encoded);
        if (keyType.params.algorithm == KeyType.Algorithm.RSA) {
            BigInteger modulus = new BigInteger(1, (byte[])dataObjects.get(129));
            BigInteger exponent = new BigInteger(1, (byte[])dataObjects.get(130));
            return new PublicKeyValues.Rsa(modulus, exponent);
        }
        if (!(keyType.params instanceof KeyType.EcKeyParams)) {
            throw new IllegalArgumentException("Unsupported key type");
        }
        return PublicKeyValues.Ec.fromEncodedPoint((EllipticCurveValues)((KeyType.EcKeyParams)keyType.params).getCurveParams(), (byte[])((byte[])dataObjects.get(134)));
    }

    public void checkKeySupport(KeyType keyType, PinPolicy pinPolicy, TouchPolicy touchPolicy, boolean generate) {
        if (this.version.major == 0) {
            return;
        }
        if (keyType == KeyType.ECCP384) {
            this.require(FEATURE_P384);
        }
        if (pinPolicy != PinPolicy.DEFAULT || touchPolicy != TouchPolicy.DEFAULT) {
            this.require(FEATURE_USAGE_POLICY);
            if (touchPolicy == TouchPolicy.CACHED) {
                this.require(FEATURE_TOUCH_CACHED);
            }
        }
        if (generate && keyType.params.algorithm == KeyType.Algorithm.RSA) {
            this.require(FEATURE_RSA_GENERATION);
        }
        if (this.version.isAtLeast(4, 4, 0) && this.version.isLessThan(4, 5, 0)) {
            if (keyType == KeyType.RSA1024) {
                throw new UnsupportedOperationException("RSA 1024 is not supported on YubiKey FIPS");
            }
            if (pinPolicy == PinPolicy.NEVER) {
                throw new UnsupportedOperationException("PinPolicy.NEVER is not allowed on YubiKey FIPS");
            }
        }
    }

    public PublicKeyValues generateKeyValues(Slot slot, KeyType keyType, PinPolicy pinPolicy, TouchPolicy touchPolicy) throws IOException, ApduException, BadResponseException {
        this.checkKeySupport(keyType, pinPolicy, touchPolicy, true);
        LinkedHashMap<Integer, byte[]> tlvs = new LinkedHashMap<Integer, byte[]>();
        tlvs.put(128, new byte[]{keyType.value});
        if (pinPolicy != PinPolicy.DEFAULT) {
            tlvs.put(170, new byte[]{(byte)pinPolicy.value});
        }
        if (touchPolicy != TouchPolicy.DEFAULT) {
            tlvs.put(171, new byte[]{(byte)touchPolicy.value});
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Generating key with pin_policy={}, touch_policy={}", (Object)((Object)pinPolicy), (Object)((Object)touchPolicy));
        byte[] response = this.protocol.sendAndReceive(new Apdu(0, 71, 0, slot.value, new Tlv(-84, Tlvs.encodeMap(tlvs)).getBytes()));
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"Private key generated in slot {} of type {}", (Object)((Object)slot), (Object)((Object)keyType));
        return PivSession.parsePublicKeyFromDevice(keyType, Tlvs.unpackValue((int)32585, (byte[])response));
    }

    @Deprecated
    public PublicKey generateKey(Slot slot, KeyType keyType, PinPolicy pinPolicy, TouchPolicy touchPolicy) throws IOException, ApduException, BadResponseException {
        try {
            return this.generateKeyValues(slot, keyType, pinPolicy, touchPolicy).toPublicKey();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public KeyType putKey(Slot slot, PrivateKeyValues key, PinPolicy pinPolicy, TouchPolicy touchPolicy) throws IOException, ApduException {
        KeyType keyType = KeyType.fromKeyParams(key);
        this.checkKeySupport(keyType, pinPolicy, touchPolicy, false);
        KeyType.KeyParams params = keyType.params;
        LinkedHashMap<Integer, byte[]> tlvs = new LinkedHashMap<Integer, byte[]>();
        switch (params.algorithm) {
            case RSA: {
                int byteLength = params.bitLength / 8 / 2;
                PrivateKeyValues.Rsa values = (PrivateKeyValues.Rsa)key;
                tlvs.put(1, ByteUtils.intToLength((BigInteger)values.getPrimeP(), (int)byteLength));
                tlvs.put(2, ByteUtils.intToLength((BigInteger)values.getPrimeQ(), (int)byteLength));
                tlvs.put(3, ByteUtils.intToLength((BigInteger)Objects.requireNonNull(values.getPrimeExponentP()), (int)byteLength));
                tlvs.put(4, ByteUtils.intToLength((BigInteger)Objects.requireNonNull(values.getPrimeExponentQ()), (int)byteLength));
                tlvs.put(5, ByteUtils.intToLength((BigInteger)Objects.requireNonNull(values.getCrtCoefficient()), (int)byteLength));
                break;
            }
            case EC: {
                PrivateKeyValues.Ec ecPrivateKey = (PrivateKeyValues.Ec)key;
                tlvs.put(6, ecPrivateKey.getSecret());
            }
        }
        if (pinPolicy != PinPolicy.DEFAULT) {
            tlvs.put(170, new byte[]{(byte)pinPolicy.value});
        }
        if (touchPolicy != TouchPolicy.DEFAULT) {
            tlvs.put(171, new byte[]{(byte)touchPolicy.value});
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Importing key with pin_policy={}, touch_policy={}", (Object)((Object)pinPolicy), (Object)((Object)touchPolicy));
        this.protocol.sendAndReceive(new Apdu(0, -2, (int)keyType.value, slot.value, Tlvs.encodeMap(tlvs)));
        com.yubico.yubikit.core.internal.Logger.info((Logger)logger, (String)"Private key imported in slot {} of type {}", (Object)((Object)slot), (Object)((Object)keyType));
        return keyType;
    }

    @Deprecated
    public KeyType putKey(Slot slot, PrivateKey key, PinPolicy pinPolicy, TouchPolicy touchPolicy) throws IOException, ApduException {
        return this.putKey(slot, PrivateKeyValues.fromPrivateKey((PrivateKey)key), pinPolicy, touchPolicy);
    }

    public byte[] getObject(int objectId) throws IOException, ApduException, BadResponseException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Reading data from object slot {}", (Object)Integer.toString(objectId, 16));
        byte[] requestData = new Tlv(92, ObjectId.getBytes(objectId)).getBytes();
        byte[] responseData = this.protocol.sendAndReceive(new Apdu(0, -53, 63, 255, requestData));
        return Tlvs.unpackValue((int)83, (byte[])responseData);
    }

    public void putObject(int objectId, @Nullable byte[] objectData) throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Writing data to object slot {}", (Object)Integer.toString(objectId, 16));
        LinkedHashMap<Integer, byte[]> tlvs = new LinkedHashMap<Integer, byte[]>();
        tlvs.put(92, ObjectId.getBytes(objectId));
        tlvs.put(83, objectData);
        this.protocol.sendAndReceive(new Apdu(0, -37, 63, 255, Tlvs.encodeMap(tlvs)));
    }

    private X509Certificate parseCertificate(byte[] data) throws CertificateException {
        ByteArrayInputStream stream = new ByteArrayInputStream(data);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509Certificate)cf.generateCertificate(stream);
    }

    private void changeReference(byte instruction, byte p2, char[] value1, char[] value2) throws IOException, ApduException, InvalidPinException {
        byte[] pinBytes = PivSession.pinBytes(value1, value2);
        try {
            this.protocol.sendAndReceive(new Apdu(0, (int)instruction, 0, (int)p2, pinBytes));
        }
        catch (ApduException e) {
            int retries = this.getRetriesFromCode(e.getSw());
            if (retries >= 0) {
                if (p2 == -128) {
                    this.currentPinAttempts = retries;
                }
                throw new InvalidPinException(retries);
            }
            throw e;
        }
        finally {
            Arrays.fill(pinBytes, (byte)0);
        }
    }

    private void blockPin() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Verify PIN with invalid attempts until blocked");
        int counter = this.getPinAttempts();
        while (counter > 0) {
            try {
                this.verifyPin(new char[0]);
            }
            catch (InvalidPinException e) {
                counter = e.getAttemptsRemaining();
            }
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"PIN is blocked");
    }

    private void blockPuk() throws IOException, ApduException {
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"Verify PUK with invalid attempts until blocked");
        int counter = 1;
        while (counter > 0) {
            try {
                this.changeReference((byte)44, (byte)-128, new char[0], new char[0]);
            }
            catch (InvalidPinException e) {
                counter = e.getAttemptsRemaining();
            }
        }
        com.yubico.yubikit.core.internal.Logger.debug((Logger)logger, (String)"PUK is blocked");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] pinBytes(char[] pin) {
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(pin));
        try {
            int byteLen = byteBuffer.limit() - byteBuffer.position();
            if (byteLen > 8) {
                throw new IllegalArgumentException("PIN/PUK must be no longer than 8 bytes");
            }
            byte[] alignedPinByte = Arrays.copyOf(byteBuffer.array(), 8);
            Arrays.fill(alignedPinByte, byteLen, 8, (byte)-1);
            byte[] byArray = alignedPinByte;
            return byArray;
        }
        finally {
            Arrays.fill(byteBuffer.array(), (byte)0);
        }
    }

    private static byte[] pinBytes(char[] pin1, char[] pin2) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        byte[] pinBytes1 = PivSession.pinBytes(pin1);
        byte[] pinBytes2 = PivSession.pinBytes(pin2);
        try {
            stream.write(pinBytes1);
            stream.write(pinBytes2);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            Arrays.fill(pinBytes1, (byte)0);
            Arrays.fill(pinBytes2, (byte)0);
        }
    }

    private int getRetriesFromCode(int statusCode) {
        if (statusCode == 27011) {
            return 0;
        }
        if (this.version.isLessThan(1, 0, 4)) {
            if (statusCode >= 25344 && statusCode <= 25599) {
                return statusCode & 0xFF;
            }
        } else if (statusCode >= 25536 && statusCode <= 25551) {
            return statusCode & 0xF;
        }
        return -1;
    }
}

