/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv;

import com.yubico.yubikit.core.keys.PublicKeyValues;
import com.yubico.yubikit.piv.KeyType;
import com.yubico.yubikit.piv.PinPolicy;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.TouchPolicy;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;

public class SlotMetadata {
    private final KeyType keyType;
    private final PinPolicy pinPolicy;
    private final TouchPolicy touchPolicy;
    private final boolean generated;
    private final byte[] publicKeyEncoded;

    public SlotMetadata(KeyType keyType, PinPolicy pinPolicy, TouchPolicy touchPolicy, boolean generated, byte[] publicKeyEncoded) {
        this.keyType = keyType;
        this.pinPolicy = pinPolicy;
        this.touchPolicy = touchPolicy;
        this.generated = generated;
        this.publicKeyEncoded = Arrays.copyOf(publicKeyEncoded, publicKeyEncoded.length);
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public PinPolicy getPinPolicy() {
        return this.pinPolicy;
    }

    public TouchPolicy getTouchPolicy() {
        return this.touchPolicy;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public PublicKeyValues getPublicKeyValues() {
        return PivSession.parsePublicKeyFromDevice(this.keyType, this.publicKeyEncoded);
    }

    @Deprecated
    public PublicKey getPublicKey() {
        try {
            return this.getPublicKeyValues().toPublicKey();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

