/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv.jca;

import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECPoint;
import javax.annotation.Nullable;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class PivKeyAgreementSpi
extends KeyAgreementSpi {
    private final Callback<Callback<Result<PivSession, Exception>>> provider;
    @Nullable
    private PivPrivateKey.EcKey privateKey;
    @Nullable
    private ECPoint publicPoint;

    PivKeyAgreementSpi(Callback<Callback<Result<PivSession, Exception>>> provider) {
        this.provider = provider;
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof PivPrivateKey.EcKey)) {
            throw new InvalidKeyException("Key must be instance of PivPrivateKey");
        }
        this.privateKey = (PivPrivateKey.EcKey)key;
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(key, random);
    }

    @Override
    @Nullable
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privateKey == null) {
            throw new IllegalStateException("KeyAgreement not initialized");
        }
        if (!lastPhase) {
            throw new IllegalStateException("Multiple phases not supported");
        }
        if (key instanceof ECPublicKey && this.privateKey.getParams().getCurve().equals(((ECPublicKey)key).getParams().getCurve())) {
            this.publicPoint = ((ECPublicKey)key).getW();
            return null;
        }
        throw new InvalidKeyException("Wrong key type");
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.privateKey != null && this.publicPoint != null) {
            try {
                byte[] byArray = this.privateKey.keyAgreement(this.provider, this.publicPoint);
                return byArray;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                this.publicPoint = null;
            }
        }
        throw new IllegalStateException("Not initialized with both private and public keys");
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] result = this.engineGenerateSecret();
        try {
            System.arraycopy(result, 0, sharedSecret, offset, result.length);
            return result.length;
        }
        catch (IndexOutOfBoundsException e) {
            throw new ShortBufferException();
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new IllegalStateException("Not supported");
    }
}

