/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv.jca;

import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.KeyType;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivAlgorithmParameterSpec;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Nullable;

abstract class PivKeyPairGeneratorSpi
extends KeyPairGeneratorSpi {
    private final Callback<Callback<Result<PivSession, Exception>>> provider;
    private final KeyType.Algorithm algorithm;
    @Nullable
    PivAlgorithmParameterSpec spec;

    PivKeyPairGeneratorSpi(Callback<Callback<Result<PivSession, Exception>>> provider, KeyType.Algorithm algorithm) {
        this.provider = provider;
        this.algorithm = algorithm;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params instanceof PivAlgorithmParameterSpec) {
            this.spec = (PivAlgorithmParameterSpec)params;
            if (this.spec.keyType.params.algorithm != this.algorithm) {
                throw new InvalidAlgorithmParameterException("Invalid key algorithm for this KeyPairGenerator");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Must be instance of PivAlgorithmParameterSpec");
        }
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        throw new IllegalArgumentException("Initialize with PivAlgorithmParameterSpec!");
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.spec == null) {
            throw new IllegalStateException("KeyPairGenerator not initialized!");
        }
        try {
            ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
            this.provider.invoke(result -> queue.add(Result.of(() -> {
                PivSession session = (PivSession)((Object)((Object)((Object)result.getValue())));
                PublicKey publicKey = session.generateKey(this.spec.slot, this.spec.keyType, this.spec.pinPolicy, this.spec.touchPolicy);
                PivPrivateKey privateKey = PivPrivateKey.from(publicKey, this.spec.slot, this.spec.pinPolicy, this.spec.touchPolicy, this.spec.pin);
                return new KeyPair(publicKey, privateKey);
            })));
            return (KeyPair)((Result)queue.take()).getValue();
        }
        catch (Exception e) {
            throw new IllegalStateException("An error occurred when generating the key pair", e);
        }
    }

    public static class Ec
    extends PivKeyPairGeneratorSpi {
        Ec(Callback<Callback<Result<PivSession, Exception>>> provider) {
            super(provider, KeyType.Algorithm.EC);
        }
    }

    public static class Rsa
    extends PivKeyPairGeneratorSpi {
        Rsa(Callback<Callback<Result<PivSession, Exception>>> provider) {
            super(provider, KeyType.Algorithm.RSA);
        }
    }
}

