/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv.jca;

import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.KeyType;
import com.yubico.yubikit.piv.PinPolicy;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.Slot;
import com.yubico.yubikit.piv.TouchPolicy;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import javax.annotation.Nullable;
import javax.security.auth.Destroyable;

public abstract class PivPrivateKey
implements PrivateKey,
Destroyable {
    final Slot slot;
    final KeyType keyType;
    @Nullable
    private final PinPolicy pinPolicy;
    @Nullable
    private final TouchPolicy touchPolicy;
    @Nullable
    protected char[] pin;
    private boolean destroyed = false;

    static PivPrivateKey from(PublicKey publicKey, Slot slot, @Nullable PinPolicy pinPolicy, @Nullable TouchPolicy touchPolicy, @Nullable char[] pin) {
        KeyType keyType = KeyType.fromKey(publicKey);
        if (keyType.params.algorithm == KeyType.Algorithm.RSA) {
            return new RsaKey(slot, keyType, pinPolicy, touchPolicy, ((RSAPublicKey)publicKey).getModulus(), pin);
        }
        return new EcKey(slot, keyType, pinPolicy, touchPolicy, ((ECPublicKey)publicKey).getParams(), pin);
    }

    protected PivPrivateKey(Slot slot, KeyType keyType, @Nullable PinPolicy pinPolicy, @Nullable TouchPolicy touchPolicy, @Nullable char[] pin) {
        this.slot = slot;
        this.keyType = keyType;
        this.pinPolicy = pinPolicy;
        this.touchPolicy = touchPolicy;
        this.pin = pin != null ? Arrays.copyOf(pin, pin.length) : null;
    }

    byte[] rawSignOrDecrypt(Callback<Callback<Result<PivSession, Exception>>> provider, byte[] payload) throws Exception {
        if (this.destroyed) {
            throw new IllegalStateException("PivPrivateKey has been destroyed");
        }
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        provider.invoke(result -> queue.add(Result.of(() -> {
            PivSession session = (PivSession)((Object)((Object)((Object)result.getValue())));
            if (this.pin != null) {
                session.verifyPin(this.pin);
            }
            return session.rawSignOrDecrypt(this.slot, this.keyType, payload);
        })));
        return (byte[])((Result)queue.take()).getValue();
    }

    public Slot getSlot() {
        return this.slot;
    }

    @Nullable
    public PinPolicy getPinPolicy() {
        return this.pinPolicy;
    }

    @Nullable
    public TouchPolicy getTouchPolicy() {
        return this.touchPolicy;
    }

    public void setPin(@Nullable char[] pin) {
        if (this.destroyed) {
            throw new IllegalStateException("PivPrivateKey has been destroyed");
        }
        if (this.pin != null) {
            Arrays.fill(this.pin, '\u0000');
        }
        this.pin = pin != null ? Arrays.copyOf(pin, pin.length) : null;
    }

    @Override
    public void destroy() {
        if (this.pin != null) {
            Arrays.fill(this.pin, '\u0000');
        }
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public String getAlgorithm() {
        return this.keyType.params.algorithm.name();
    }

    @Override
    @Nullable
    public String getFormat() {
        return null;
    }

    @Override
    @Nullable
    public byte[] getEncoded() {
        return null;
    }

    static class RsaKey
    extends PivPrivateKey
    implements RSAKey {
        private final BigInteger modulus;

        private RsaKey(Slot slot, KeyType keyType, @Nullable PinPolicy pinPolicy, @Nullable TouchPolicy touchPolicy, BigInteger modulus, @Nullable char[] pin) {
            super(slot, keyType, pinPolicy, touchPolicy, pin);
            this.modulus = modulus;
        }

        @Override
        public BigInteger getModulus() {
            return this.modulus;
        }
    }

    static class EcKey
    extends PivPrivateKey
    implements ECKey {
        private final ECParameterSpec ecSpec;

        private EcKey(Slot slot, KeyType keyType, @Nullable PinPolicy pinPolicy, @Nullable TouchPolicy touchPolicy, ECParameterSpec ecSpec, @Nullable char[] pin) {
            super(slot, keyType, pinPolicy, touchPolicy, pin);
            this.ecSpec = ecSpec;
        }

        byte[] keyAgreement(Callback<Callback<Result<PivSession, Exception>>> provider, ECPoint peerPublicKey) throws Exception {
            ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
            provider.invoke(result -> queue.add(Result.of(() -> {
                PivSession session = (PivSession)((Object)((Object)((Object)result.getValue())));
                if (this.pin != null) {
                    session.verifyPin(this.pin);
                }
                return session.calculateSecret(this.slot, peerPublicKey);
            })));
            return (byte[])((Result)queue.take()).getValue();
        }

        @Override
        public ECParameterSpec getParams() {
            return this.ecSpec;
        }
    }
}

