/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.yubikit.piv.jca;

import com.yubico.yubikit.core.util.Callback;
import com.yubico.yubikit.core.util.Result;
import com.yubico.yubikit.piv.KeyType;
import com.yubico.yubikit.piv.PivSession;
import com.yubico.yubikit.piv.jca.PivPrivateKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class PivRsaSignatureSpi
extends SignatureSpi {
    private final Callback<Callback<Result<PivSession, Exception>>> provider;
    private final Map<KeyType, KeyPair> dummyKeys;
    private final String signature;
    @Nullable
    private PivPrivateKey.RsaKey privateKey;
    @Nullable
    private Signature delegate;

    PivRsaSignatureSpi(Callback<Callback<Result<PivSession, Exception>>> provider, Map<KeyType, KeyPair> dummyKeys, String signature) throws NoSuchPaddingException {
        this.provider = provider;
        this.dummyKeys = dummyKeys;
        this.signature = signature;
    }

    private Signature getDelegate(boolean init) throws NoSuchAlgorithmException {
        if (this.delegate == null) {
            this.delegate = Signature.getInstance(this.signature);
            if (init) {
                try {
                    this.delegate.initSign(this.dummyKeys.get((Object)KeyType.RSA2048).getPrivate());
                }
                catch (InvalidKeyException e) {
                    throw new NoSuchAlgorithmException();
                }
            }
        }
        return this.delegate;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        throw new InvalidKeyException("Can only be used for signing.");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof PivPrivateKey.RsaKey) {
            this.privateKey = (PivPrivateKey.RsaKey)privateKey;
            KeyPair dummyPair = this.dummyKeys.get((Object)this.privateKey.keyType);
            try {
                this.getDelegate(false).initSign(dummyPair.getPrivate());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException(e);
            }
        } else {
            throw new InvalidKeyException("Unsupported key type");
        }
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        if (this.delegate == null) {
            throw new SignatureException("Not initialized");
        }
        this.delegate.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        if (this.delegate == null) {
            throw new SignatureException("Not initialized");
        }
        this.delegate.update(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (this.privateKey == null || this.delegate == null) {
            throw new SignatureException("Not initialized");
        }
        try {
            Cipher rawRsa = Cipher.getInstance("RSA/ECB/NoPadding");
            rawRsa.init(1, this.dummyKeys.get((Object)this.privateKey.keyType).getPublic());
            byte[] padded = rawRsa.doFinal(this.delegate.sign());
            return this.privateKey.rawSignOrDecrypt(this.provider, padded);
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        throw new SignatureException("Not initialized");
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        try {
            this.getDelegate(true).setParameter(param, value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidParameterException("Not initialized");
        }
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        if (this.delegate != null) {
            return this.delegate.getParameter(param);
        }
        throw new InvalidParameterException("Not initialized");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        try {
            this.getDelegate(true).setParameter(params);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidParameterException("Not initialized");
        }
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.delegate != null) {
            return this.delegate.getParameters();
        }
        throw new InvalidParameterException("Not initialized");
    }
}

