/*
 * Decompiled with CFR 0.152.
 */
package com.yupi.yucongming.dev.client;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.net.URLEncodeUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONUtil;
import com.yupi.yucongming.dev.common.BaseResponse;
import com.yupi.yucongming.dev.model.DevChatRequest;
import com.yupi.yucongming.dev.model.DevChatResponse;
import com.yupi.yucongming.dev.utils.SignUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class YuCongMingClient {
    private static final String HOST = "https://www.yucongming.com/api/dev";
    private final String accessKey;
    private final String secretKey;

    public YuCongMingClient(String accessKey, String secretKey) {
        this.accessKey = accessKey;
        this.secretKey = secretKey;
    }

    public BaseResponse<DevChatResponse> doChat(DevChatRequest devChatRequest) {
        String url = "https://www.yucongming.com/api/dev/chat";
        String json = JSONUtil.toJsonStr((Object)devChatRequest);
        String result = ((HttpRequest)HttpRequest.post((String)url).addHeaders(this.getHeaderMap(json))).body(json).execute().body();
        TypeReference<BaseResponse<DevChatResponse>> typeRef = new TypeReference<BaseResponse<DevChatResponse>>(){};
        return (BaseResponse)JSONUtil.toBean((String)result, (TypeReference)typeRef, (boolean)false);
    }

    private Map<String, String> getHeaderMap(String body) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("accessKey", this.accessKey);
        hashMap.put("nonce", RandomUtil.randomNumbers((int)4));
        String encodedBody = URLEncodeUtil.encode((String)body, (Charset)StandardCharsets.UTF_8);
        hashMap.put("body", encodedBody);
        hashMap.put("timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        hashMap.put("sign", SignUtils.genSign(encodedBody, this.secretKey));
        return hashMap;
    }

    public static void main(String[] args) {
        String accessKey = "\u4f60\u7684 accessKey";
        String secretKey = "\u4f60\u7684 secretKey";
        YuCongMingClient yuCongMingClient = new YuCongMingClient(accessKey, secretKey);
        DevChatRequest devChatRequest = new DevChatRequest();
        devChatRequest.setModelId(1651468516836098050L);
        devChatRequest.setMessage("\u9c7c\u76ae");
        BaseResponse<DevChatResponse> devChatResponseBaseResponse = yuCongMingClient.doChat(devChatRequest);
        System.out.println(devChatResponseBaseResponse);
        DevChatResponse data = devChatResponseBaseResponse.getData();
        if (data != null) {
            String content = data.getContent();
            System.out.println(content);
        }
    }
}

