/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class OptionsMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<String, Map<DriverOption, Object>> map;
    private final List<Consumer<OptionsMap>> changeListeners = new CopyOnWriteArrayList<Consumer<OptionsMap>>();

    @NonNull
    public static OptionsMap driverDefaults() {
        OptionsMap source = new OptionsMap();
        OptionsMap.fillWithDriverDefaults(source);
        return source;
    }

    public OptionsMap() {
        this(new ConcurrentHashMap<String, Map<DriverOption, Object>>());
    }

    private OptionsMap(ConcurrentHashMap<String, Map<DriverOption, Object>> map) {
        this.map = map;
    }

    @Nullable
    public <ValueT> ValueT put(@NonNull String profile, @NonNull TypedDriverOption<ValueT> option, @NonNull ValueT value) {
        Objects.requireNonNull(option, "option");
        Objects.requireNonNull(value, "value");
        Object previous = this.getProfileMap(profile).put(option.getRawOption(), value);
        if (!value.equals(previous)) {
            for (Consumer<OptionsMap> listener : this.changeListeners) {
                listener.accept(this);
            }
        }
        return this.cast(previous);
    }

    @Nullable
    public <ValueT> ValueT put(@NonNull TypedDriverOption<ValueT> option, @NonNull ValueT value) {
        return this.put("default", option, value);
    }

    @Nullable
    public <ValueT> ValueT get(@NonNull String profile, @NonNull TypedDriverOption<ValueT> option) {
        Objects.requireNonNull(option, "option");
        Object result = this.getProfileMap(profile).get(option.getRawOption());
        return this.cast(result);
    }

    @Nullable
    public <ValueT> ValueT get(@NonNull TypedDriverOption<ValueT> option) {
        return this.get("default", option);
    }

    @Nullable
    public <ValueT> ValueT remove(@NonNull String profile, @NonNull TypedDriverOption<ValueT> option) {
        Objects.requireNonNull(option, "option");
        Object previous = this.getProfileMap(profile).remove(option.getRawOption());
        if (previous != null) {
            for (Consumer<OptionsMap> listener : this.changeListeners) {
                listener.accept(this);
            }
        }
        return this.cast(previous);
    }

    @Nullable
    public <ValueT> ValueT remove(@NonNull TypedDriverOption<ValueT> option) {
        return this.remove("default", option);
    }

    public void addChangeListener(@NonNull Consumer<OptionsMap> listener) {
        this.changeListeners.add(Objects.requireNonNull(listener));
    }

    public boolean removeChangeListener(@NonNull Consumer<OptionsMap> listener) {
        return this.changeListeners.remove(Objects.requireNonNull(listener));
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof OptionsMap) {
            OptionsMap that = (OptionsMap)other;
            return this.map.equals(that.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    @NonNull
    protected Map<String, Map<DriverOption, Object>> asRawMap() {
        return this.map;
    }

    @NonNull
    private Map<DriverOption, Object> getProfileMap(@NonNull String profile) {
        Objects.requireNonNull(profile, "profile");
        return this.map.computeIfAbsent(profile, p -> new ConcurrentHashMap());
    }

    @Nullable
    private <ValueT> ValueT cast(@Nullable Object value) {
        return (ValueT)value;
    }

    private Object writeReplace() {
        return new SerializationProxy(this.map);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    protected static void fillWithDriverDefaults(OptionsMap map) {
        map.put(TypedDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(2L));
        map.put(TypedDriverOption.REQUEST_CONSISTENCY, "LOCAL_ONE");
        map.put(TypedDriverOption.REQUEST_PAGE_SIZE, 5000);
        map.put(TypedDriverOption.REQUEST_SERIAL_CONSISTENCY, "SERIAL");
        map.put(TypedDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, false);
        map.put(TypedDriverOption.GRAPH_TRAVERSAL_SOURCE, "g");
        map.put(TypedDriverOption.LOAD_BALANCING_POLICY_CLASS, "DefaultLoadBalancingPolicy");
        map.put(TypedDriverOption.LOAD_BALANCING_POLICY_SLOW_AVOIDANCE, true);
        map.put(TypedDriverOption.SESSION_LEAK_THRESHOLD, 4);
        map.put(TypedDriverOption.CONNECTION_CONNECT_TIMEOUT, Duration.ofSeconds(5L));
        map.put(TypedDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, Duration.ofMillis(500L));
        map.put(TypedDriverOption.CONNECTION_SET_KEYSPACE_TIMEOUT, Duration.ofMillis(500L));
        map.put(TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, 1);
        map.put(TypedDriverOption.CONNECTION_POOL_REMOTE_SIZE, 1);
        map.put(TypedDriverOption.CONNECTION_MAX_REQUESTS, 1024);
        map.put(TypedDriverOption.CONNECTION_MAX_ORPHAN_REQUESTS, 24576);
        map.put(TypedDriverOption.CONNECTION_WARN_INIT_ERROR, true);
        map.put(TypedDriverOption.RECONNECT_ON_INIT, false);
        map.put(TypedDriverOption.RECONNECTION_POLICY_CLASS, "ExponentialReconnectionPolicy");
        map.put(TypedDriverOption.RECONNECTION_BASE_DELAY, Duration.ofSeconds(1L));
        map.put(TypedDriverOption.RECONNECTION_MAX_DELAY, Duration.ofSeconds(60L));
        map.put(TypedDriverOption.RETRY_POLICY_CLASS, "DefaultRetryPolicy");
        map.put(TypedDriverOption.SPECULATIVE_EXECUTION_POLICY_CLASS, "NoSpeculativeExecutionPolicy");
        map.put(TypedDriverOption.TIMESTAMP_GENERATOR_CLASS, "AtomicTimestampGenerator");
        map.put(TypedDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_THRESHOLD, Duration.ofSeconds(1L));
        map.put(TypedDriverOption.TIMESTAMP_GENERATOR_DRIFT_WARNING_INTERVAL, Duration.ofSeconds(10L));
        map.put(TypedDriverOption.TIMESTAMP_GENERATOR_FORCE_JAVA_CLOCK, false);
        map.put(TypedDriverOption.REQUEST_TRACKER_CLASS, "NoopRequestTracker");
        map.put(TypedDriverOption.REQUEST_THROTTLER_CLASS, "PassThroughRequestThrottler");
        map.put(TypedDriverOption.METADATA_NODE_STATE_LISTENER_CLASS, "NoopNodeStateListener");
        map.put(TypedDriverOption.METADATA_SCHEMA_CHANGE_LISTENER_CLASS, "NoopSchemaChangeListener");
        map.put(TypedDriverOption.ADDRESS_TRANSLATOR_CLASS, "PassThroughAddressTranslator");
        map.put(TypedDriverOption.RESOLVE_CONTACT_POINTS, true);
        map.put(TypedDriverOption.PROTOCOL_MAX_FRAME_LENGTH, 0x10000000L);
        map.put(TypedDriverOption.REQUEST_WARN_IF_SET_KEYSPACE, true);
        map.put(TypedDriverOption.REQUEST_TRACE_ATTEMPTS, 5);
        map.put(TypedDriverOption.REQUEST_TRACE_INTERVAL, Duration.ofMillis(3L));
        map.put(TypedDriverOption.REQUEST_TRACE_CONSISTENCY, "ONE");
        map.put(TypedDriverOption.REQUEST_LOG_WARNINGS, true);
        map.put(TypedDriverOption.GRAPH_PAGING_ENABLED, "AUTO");
        map.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_PAGE_SIZE, 5000);
        map.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES, 0);
        map.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, 0);
        map.put(TypedDriverOption.GRAPH_CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES, 4);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_PAGE_SIZE, 5000);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_PAGE_SIZE_BYTES, false);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_PAGES, 0);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_PAGES_PER_SECOND, 0);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_ENQUEUED_PAGES, 4);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE, Duration.ofSeconds(2L));
        map.put(TypedDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES, Duration.ofSeconds(1L));
        map.put(TypedDriverOption.MONITOR_REPORTING_ENABLED, true);
        map.put(TypedDriverOption.METRICS_SESSION_ENABLED, Collections.emptyList());
        map.put(TypedDriverOption.METRICS_SESSION_CQL_REQUESTS_HIGHEST, Duration.ofSeconds(3L));
        map.put(TypedDriverOption.METRICS_SESSION_CQL_REQUESTS_DIGITS, 3);
        map.put(TypedDriverOption.METRICS_SESSION_CQL_REQUESTS_INTERVAL, Duration.ofMinutes(5L));
        map.put(TypedDriverOption.METRICS_SESSION_THROTTLING_HIGHEST, Duration.ofSeconds(3L));
        map.put(TypedDriverOption.METRICS_SESSION_THROTTLING_DIGITS, 3);
        map.put(TypedDriverOption.METRICS_SESSION_THROTTLING_INTERVAL, Duration.ofMinutes(5L));
        map.put(TypedDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_HIGHEST, Duration.ofSeconds(3L));
        map.put(TypedDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_DIGITS, 3);
        map.put(TypedDriverOption.CONTINUOUS_PAGING_METRICS_SESSION_CQL_REQUESTS_INTERVAL, Duration.ofMinutes(5L));
        map.put(TypedDriverOption.METRICS_SESSION_GRAPH_REQUESTS_HIGHEST, Duration.ofSeconds(3L));
        map.put(TypedDriverOption.METRICS_SESSION_GRAPH_REQUESTS_DIGITS, 3);
        map.put(TypedDriverOption.METRICS_SESSION_GRAPH_REQUESTS_INTERVAL, Duration.ofMinutes(5L));
        map.put(TypedDriverOption.METRICS_NODE_ENABLED, Collections.emptyList());
        map.put(TypedDriverOption.METRICS_NODE_CQL_MESSAGES_HIGHEST, Duration.ofSeconds(3L));
        map.put(TypedDriverOption.METRICS_NODE_CQL_MESSAGES_DIGITS, 3);
        map.put(TypedDriverOption.METRICS_NODE_CQL_MESSAGES_INTERVAL, Duration.ofMinutes(5L));
        map.put(TypedDriverOption.METRICS_NODE_GRAPH_MESSAGES_HIGHEST, Duration.ofSeconds(3L));
        map.put(TypedDriverOption.METRICS_NODE_GRAPH_MESSAGES_DIGITS, 3);
        map.put(TypedDriverOption.METRICS_NODE_GRAPH_MESSAGES_INTERVAL, Duration.ofMinutes(5L));
        map.put(TypedDriverOption.METRICS_NODE_EXPIRE_AFTER, Duration.ofHours(1L));
        map.put(TypedDriverOption.SOCKET_TCP_NODELAY, true);
        map.put(TypedDriverOption.HEARTBEAT_INTERVAL, Duration.ofSeconds(30L));
        map.put(TypedDriverOption.HEARTBEAT_TIMEOUT, Duration.ofMillis(500L));
        map.put(TypedDriverOption.METADATA_TOPOLOGY_WINDOW, Duration.ofSeconds(1L));
        map.put(TypedDriverOption.METADATA_TOPOLOGY_MAX_EVENTS, 20);
        map.put(TypedDriverOption.METADATA_SCHEMA_ENABLED, true);
        map.put(TypedDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT, Duration.ofSeconds(2L));
        map.put(TypedDriverOption.METADATA_SCHEMA_REQUEST_PAGE_SIZE, 5000);
        map.put(TypedDriverOption.METADATA_SCHEMA_WINDOW, Duration.ofSeconds(1L));
        map.put(TypedDriverOption.METADATA_SCHEMA_MAX_EVENTS, 20);
        map.put(TypedDriverOption.METADATA_TOKEN_MAP_ENABLED, true);
        map.put(TypedDriverOption.METADATA_PARTITION_METADATA_ENABLED, true);
        map.put(TypedDriverOption.CONTROL_CONNECTION_TIMEOUT, Duration.ofMillis(500L));
        map.put(TypedDriverOption.CONTROL_CONNECTION_AGREEMENT_INTERVAL, Duration.ofMillis(200L));
        map.put(TypedDriverOption.CONTROL_CONNECTION_AGREEMENT_TIMEOUT, Duration.ofSeconds(10L));
        map.put(TypedDriverOption.CONTROL_CONNECTION_AGREEMENT_WARN, true);
        map.put(TypedDriverOption.PREPARE_ON_ALL_NODES, true);
        map.put(TypedDriverOption.REPREPARE_ENABLED, true);
        map.put(TypedDriverOption.REPREPARE_CHECK_SYSTEM_TABLE, false);
        map.put(TypedDriverOption.REPREPARE_MAX_STATEMENTS, 0);
        map.put(TypedDriverOption.REPREPARE_MAX_PARALLELISM, 100);
        map.put(TypedDriverOption.REPREPARE_TIMEOUT, Duration.ofMillis(500L));
        map.put(TypedDriverOption.NETTY_DAEMON, false);
        map.put(TypedDriverOption.NETTY_IO_SIZE, 0);
        map.put(TypedDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD, 2);
        map.put(TypedDriverOption.NETTY_IO_SHUTDOWN_TIMEOUT, 15);
        map.put(TypedDriverOption.NETTY_IO_SHUTDOWN_UNIT, "SECONDS");
        map.put(TypedDriverOption.NETTY_ADMIN_SIZE, 2);
        map.put(TypedDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD, 2);
        map.put(TypedDriverOption.NETTY_ADMIN_SHUTDOWN_TIMEOUT, 15);
        map.put(TypedDriverOption.NETTY_ADMIN_SHUTDOWN_UNIT, "SECONDS");
        map.put(TypedDriverOption.NETTY_TIMER_TICK_DURATION, Duration.ofMillis(100L));
        map.put(TypedDriverOption.NETTY_TIMER_TICKS_PER_WHEEL, 2048);
        map.put(TypedDriverOption.COALESCER_INTERVAL, Duration.of(10L, ChronoUnit.MICROS));
    }

    @Immutable
    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ConcurrentHashMap<String, Map<DriverOption, Object>> map;

        private SerializationProxy(ConcurrentHashMap<String, Map<DriverOption, Object>> map) {
            this.map = map;
        }

        private Object readResolve() {
            return new OptionsMap(this.map);
        }
    }
}

