/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.session;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeStateListener;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.ProgrammaticArguments;
import com.datastax.oss.driver.api.core.ssl.ProgrammaticSslEngineFactory;
import com.datastax.oss.driver.api.core.ssl.SslEngineFactory;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.internal.core.ContactPoints;
import com.datastax.oss.driver.internal.core.auth.ProgrammaticPlainTextAuthProvider;
import com.datastax.oss.driver.internal.core.config.cloud.CloudConfig;
import com.datastax.oss.driver.internal.core.config.cloud.CloudConfigFactory;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public abstract class SessionBuilder<SelfT extends SessionBuilder, SessionT> {
    protected final SelfT self = this;
    protected DriverConfigLoader configLoader;
    protected Set<EndPoint> programmaticContactPoints = new HashSet<EndPoint>();
    protected CqlIdentifier keyspace;
    protected Callable<InputStream> cloudConfigInputStream;
    protected ProgrammaticArguments.Builder programmaticArgumentsBuilder = ProgrammaticArguments.builder();
    private boolean sslConfigured = false;

    @NonNull
    public SelfT withConfigLoader(@Nullable DriverConfigLoader configLoader) {
        this.configLoader = configLoader;
        return this.self;
    }

    @NonNull
    protected DriverConfigLoader defaultConfigLoader() {
        return new DefaultDriverConfigLoader();
    }

    @NonNull
    public SelfT addContactPoints(@NonNull Collection<InetSocketAddress> contactPoints) {
        for (InetSocketAddress contactPoint : contactPoints) {
            this.addContactPoint(contactPoint);
        }
        return this.self;
    }

    @NonNull
    public SelfT addContactPoint(@NonNull InetSocketAddress contactPoint) {
        this.programmaticContactPoints.add(new DefaultEndPoint(contactPoint));
        return this.self;
    }

    @NonNull
    public SelfT addContactEndPoints(@NonNull Collection<EndPoint> contactPoints) {
        for (EndPoint contactPoint : contactPoints) {
            this.addContactEndPoint(contactPoint);
        }
        return this.self;
    }

    @NonNull
    public SelfT addContactEndPoint(@NonNull EndPoint contactPoint) {
        this.programmaticContactPoints.add(contactPoint);
        return this.self;
    }

    @NonNull
    public SelfT addTypeCodecs(TypeCodec<?> ... typeCodecs) {
        this.programmaticArgumentsBuilder.addTypeCodecs(typeCodecs);
        return this.self;
    }

    @NonNull
    public SelfT withNodeStateListener(@Nullable NodeStateListener nodeStateListener) {
        this.programmaticArgumentsBuilder.withNodeStateListener(nodeStateListener);
        return this.self;
    }

    @NonNull
    public SelfT withSchemaChangeListener(@Nullable SchemaChangeListener schemaChangeListener) {
        this.programmaticArgumentsBuilder.withSchemaChangeListener(schemaChangeListener);
        return this.self;
    }

    @NonNull
    public SelfT withRequestTracker(@Nullable RequestTracker requestTracker) {
        this.programmaticArgumentsBuilder.withRequestTracker(requestTracker);
        return this.self;
    }

    @NonNull
    public SelfT withAuthProvider(@Nullable AuthProvider authProvider) {
        this.programmaticArgumentsBuilder.withAuthProvider(authProvider);
        return this.self;
    }

    @NonNull
    public SelfT withAuthCredentials(@NonNull String username, @NonNull String password) {
        return this.withAuthProvider(new ProgrammaticPlainTextAuthProvider(username, password));
    }

    @NonNull
    public SelfT withAuthCredentials(@NonNull String username, @NonNull String password, @NonNull String authorizationId) {
        return this.withAuthProvider(new ProgrammaticPlainTextAuthProvider(username, password, authorizationId));
    }

    @NonNull
    public SelfT withSslEngineFactory(@Nullable SslEngineFactory sslEngineFactory) {
        this.sslConfigured = true;
        this.programmaticArgumentsBuilder.withSslEngineFactory(sslEngineFactory);
        return this.self;
    }

    @NonNull
    public SelfT withSslContext(@Nullable SSLContext sslContext) {
        return this.withSslEngineFactory(sslContext == null ? null : new ProgrammaticSslEngineFactory(sslContext));
    }

    public SelfT withLocalDatacenter(@NonNull String profileName, @NonNull String localDatacenter) {
        this.programmaticArgumentsBuilder.withLocalDatacenter(profileName, localDatacenter);
        return this.self;
    }

    public SelfT withLocalDatacenter(@NonNull String localDatacenter) {
        return this.withLocalDatacenter("default", localDatacenter);
    }

    @NonNull
    public SelfT withNodeFilter(@NonNull String profileName, @NonNull Predicate<Node> nodeFilter) {
        this.programmaticArgumentsBuilder.withNodeFilter(profileName, nodeFilter);
        return this.self;
    }

    @NonNull
    public SelfT withNodeFilter(@NonNull Predicate<Node> nodeFilter) {
        return this.withNodeFilter("default", nodeFilter);
    }

    @NonNull
    public SelfT withKeyspace(@Nullable CqlIdentifier keyspace) {
        this.keyspace = keyspace;
        return this.self;
    }

    @NonNull
    public SelfT withKeyspace(@Nullable String keyspaceName) {
        return this.withKeyspace(keyspaceName == null ? null : CqlIdentifier.fromCql(keyspaceName));
    }

    @NonNull
    public SelfT withClassLoader(@Nullable ClassLoader classLoader) {
        this.programmaticArgumentsBuilder.withClassLoader(classLoader);
        return this.self;
    }

    @NonNull
    public SelfT withCloudSecureConnectBundle(@NonNull Path cloudConfigPath) {
        try {
            URL cloudConfigUrl = cloudConfigPath.toAbsolutePath().normalize().toUri().toURL();
            this.cloudConfigInputStream = cloudConfigUrl::openStream;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Incorrect format of cloudConfigPath", e);
        }
        return this.self;
    }

    @NonNull
    public SelfT withCloudSecureConnectBundle(@NonNull URL cloudConfigUrl) {
        this.cloudConfigInputStream = cloudConfigUrl::openStream;
        return this.self;
    }

    @NonNull
    public SelfT withCloudSecureConnectBundle(@NonNull InputStream cloudConfigInputStream) {
        this.cloudConfigInputStream = () -> cloudConfigInputStream;
        return this.self;
    }

    @NonNull
    public SelfT withCloudProxyAddress(@Nullable InetSocketAddress cloudProxyAddress) {
        this.programmaticArgumentsBuilder.withCloudProxyAddress(cloudProxyAddress);
        return this.self;
    }

    @NonNull
    public SelfT withClientId(@Nullable UUID clientId) {
        this.programmaticArgumentsBuilder.withStartupClientId(clientId);
        return this.self;
    }

    @NonNull
    public SelfT withApplicationName(@Nullable String applicationName) {
        this.programmaticArgumentsBuilder.withStartupApplicationName(applicationName);
        return this.self;
    }

    @NonNull
    public SelfT withApplicationVersion(@Nullable String applicationVersion) {
        this.programmaticArgumentsBuilder.withStartupApplicationVersion(applicationVersion);
        return this.self;
    }

    @NonNull
    public CompletionStage<SessionT> buildAsync() {
        CompletionStage<CqlSession> buildStage = this.buildDefaultSessionAsync();
        CompletionStage<Object> wrapStage = buildStage.thenApply(this::wrap);
        CompletableFutures.propagateCancellation(wrapStage, buildStage);
        return wrapStage;
    }

    @NonNull
    public SessionT build() {
        BlockingOperation.checkNotDriverThread();
        return CompletableFutures.getUninterruptibly(this.buildAsync());
    }

    protected abstract SessionT wrap(@NonNull CqlSession var1);

    @NonNull
    protected final CompletionStage<CqlSession> buildDefaultSessionAsync() {
        try {
            String configUrlString;
            DriverConfigLoader configLoader = SessionBuilder.buildIfNull(this.configLoader, this::defaultConfigLoader);
            DriverExecutionProfile defaultConfig = configLoader.getInitialConfig().getDefaultProfile();
            if (this.cloudConfigInputStream == null && (configUrlString = defaultConfig.getString(DefaultDriverOption.CLOUD_SECURE_CONNECT_BUNDLE, null)) != null) {
                this.cloudConfigInputStream = () -> this.getURL(configUrlString).openStream();
            }
            List<String> configContactPoints = defaultConfig.getStringList(DefaultDriverOption.CONTACT_POINTS, Collections.emptyList());
            if (this.cloudConfigInputStream != null) {
                if (!this.programmaticContactPoints.isEmpty() || !configContactPoints.isEmpty()) {
                    throw new IllegalStateException("Can't use withCloudSecureConnectBundle and addContactPoint(s). They are mutually exclusive.");
                }
                String configuredSSLFactory = defaultConfig.getString(DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, null);
                if (this.sslConfigured || configuredSSLFactory != null) {
                    throw new IllegalStateException("Can't use withCloudSecureConnectBundle and explicitly specify ssl configuration. They are mutually exclusive.");
                }
                CloudConfig cloudConfig = new CloudConfigFactory().createCloudConfig(this.cloudConfigInputStream.call());
                this.addContactEndPoints(cloudConfig.getEndPoints());
                this.withLocalDatacenter(cloudConfig.getLocalDatacenter());
                this.withSslEngineFactory(cloudConfig.getSslEngineFactory());
                this.withCloudProxyAddress(cloudConfig.getProxyAddress());
                if (cloudConfig.getAuthProvider().isPresent()) {
                    this.withAuthProvider(cloudConfig.getAuthProvider().get());
                }
            }
            boolean resolveAddresses = defaultConfig.getBoolean(DefaultDriverOption.RESOLVE_CONTACT_POINTS, true);
            Set<EndPoint> contactPoints = ContactPoints.merge(this.programmaticContactPoints, configContactPoints, resolveAddresses);
            if (this.keyspace == null && defaultConfig.isDefined(DefaultDriverOption.SESSION_KEYSPACE)) {
                this.keyspace = CqlIdentifier.fromCql(defaultConfig.getString(DefaultDriverOption.SESSION_KEYSPACE));
            }
            return DefaultSession.init((InternalDriverContext)this.buildContext(configLoader, this.programmaticArgumentsBuilder.build()), contactPoints, this.keyspace);
        }
        catch (Throwable t) {
            return CompletableFutures.failedFuture(t);
        }
    }

    private URL getURL(String configUrl) throws MalformedURLException {
        try {
            return new URL(configUrl);
        }
        catch (MalformedURLException e1) {
            try {
                return Paths.get(configUrl, new String[0]).toAbsolutePath().normalize().toUri().toURL();
            }
            catch (MalformedURLException e2) {
                e2.addSuppressed(e1);
                throw e2;
            }
        }
    }

    protected DriverContext buildContext(DriverConfigLoader configLoader, ProgrammaticArguments programmaticArguments) {
        DriverContext legacyApiContext = this.buildContext(configLoader, programmaticArguments.getTypeCodecs(), programmaticArguments.getNodeStateListener(), programmaticArguments.getSchemaChangeListener(), programmaticArguments.getRequestTracker(), programmaticArguments.getLocalDatacenters(), programmaticArguments.getNodeFilters(), programmaticArguments.getClassLoader());
        if (legacyApiContext != null) {
            return legacyApiContext;
        }
        return new DefaultDriverContext(configLoader, programmaticArguments);
    }

    @Deprecated
    protected DriverContext buildContext(DriverConfigLoader configLoader, List<TypeCodec<?>> typeCodecs, NodeStateListener nodeStateListener, SchemaChangeListener schemaChangeListener, RequestTracker requestTracker, Map<String, String> localDatacenters, Map<String, Predicate<Node>> nodeFilters, ClassLoader classLoader) {
        return null;
    }

    private static <T> T buildIfNull(T value, Supplier<T> builder) {
        return value == null ? builder.get() : value;
    }
}

