/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultBatchStatement
implements BatchStatement {
    private final BatchType batchType;
    private final List<BatchableStatement<?>> statements;
    private final String executionProfileName;
    private final DriverExecutionProfile executionProfile;
    private final CqlIdentifier keyspace;
    private final CqlIdentifier routingKeyspace;
    private final ByteBuffer routingKey;
    private final Token routingToken;
    private final Map<String, ByteBuffer> customPayload;
    private final Boolean idempotent;
    private final boolean tracing;
    private final long timestamp;
    private final ByteBuffer pagingState;
    private final int pageSize;
    private final ConsistencyLevel consistencyLevel;
    private final ConsistencyLevel serialConsistencyLevel;
    private final Duration timeout;
    private final Node node;
    private final int nowInSeconds;

    public DefaultBatchStatement(BatchType batchType, List<BatchableStatement<?>> statements, String executionProfileName, DriverExecutionProfile executionProfile, CqlIdentifier keyspace, CqlIdentifier routingKeyspace, ByteBuffer routingKey, Token routingToken, Map<String, ByteBuffer> customPayload, Boolean idempotent, boolean tracing, long timestamp, ByteBuffer pagingState, int pageSize, ConsistencyLevel consistencyLevel, ConsistencyLevel serialConsistencyLevel, Duration timeout, Node node, int nowInSeconds) {
        this.batchType = batchType;
        this.statements = ImmutableList.copyOf(statements);
        this.executionProfileName = executionProfileName;
        this.executionProfile = executionProfile;
        this.keyspace = keyspace;
        this.routingKeyspace = routingKeyspace;
        this.routingKey = routingKey;
        this.routingToken = routingToken;
        this.customPayload = customPayload;
        this.idempotent = idempotent;
        this.tracing = tracing;
        this.timestamp = timestamp;
        this.pagingState = pagingState;
        this.pageSize = pageSize;
        this.consistencyLevel = consistencyLevel;
        this.serialConsistencyLevel = serialConsistencyLevel;
        this.timeout = timeout;
        this.node = node;
        this.nowInSeconds = nowInSeconds;
    }

    @Override
    @NonNull
    public BatchType getBatchType() {
        return this.batchType;
    }

    @Override
    @NonNull
    public BatchStatement setBatchType(@NonNull BatchType newBatchType) {
        return new DefaultBatchStatement(newBatchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public BatchStatement setKeyspace(@Nullable CqlIdentifier newKeyspace) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, newKeyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public BatchStatement add(@NonNull BatchableStatement<?> statement) {
        if (this.statements.size() >= 65535) {
            throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
        }
        return new DefaultBatchStatement(this.batchType, (List<BatchableStatement<?>>)ImmutableList.builder().addAll(this.statements).add(statement).build(), this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public BatchStatement addAll(@NonNull Iterable<? extends BatchableStatement<?>> newStatements) {
        if (this.statements.size() + Iterables.size(newStatements) > 65535) {
            throw new IllegalStateException("Batch statement cannot contain more than 65535 statements.");
        }
        return new DefaultBatchStatement(this.batchType, (List<BatchableStatement<?>>)ImmutableList.builder().addAll(this.statements).addAll(newStatements).build(), this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    @NonNull
    public BatchStatement clear() {
        return new DefaultBatchStatement(this.batchType, (List<BatchableStatement<?>>)ImmutableList.of(), this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public Iterator<BatchableStatement<?>> iterator() {
        return this.statements.iterator();
    }

    @Override
    public ByteBuffer getPagingState() {
        return this.pagingState;
    }

    @Override
    @NonNull
    public BatchStatement setPagingState(ByteBuffer newPagingState) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, newPagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    @NonNull
    public BatchStatement setPageSize(int newPageSize) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, newPageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Override
    @NonNull
    public BatchStatement setConsistencyLevel(@Nullable ConsistencyLevel newConsistencyLevel) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, newConsistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @Nullable
    public ConsistencyLevel getSerialConsistencyLevel() {
        return this.serialConsistencyLevel;
    }

    @Override
    @NonNull
    public BatchStatement setSerialConsistencyLevel(@Nullable ConsistencyLevel newSerialConsistencyLevel) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, newSerialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    @Override
    @NonNull
    public BatchStatement setExecutionProfileName(@Nullable String newConfigProfileName) {
        return new DefaultBatchStatement(this.batchType, this.statements, newConfigProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public DriverExecutionProfile getExecutionProfile() {
        return this.executionProfile;
    }

    @Override
    @NonNull
    public DefaultBatchStatement setExecutionProfile(@Nullable DriverExecutionProfile newProfile) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, newProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public CqlIdentifier getKeyspace() {
        if (this.keyspace != null) {
            return this.keyspace;
        }
        for (BatchableStatement<?> statement : this.statements) {
            if (!(statement instanceof SimpleStatement) || statement.getKeyspace() == null) continue;
            return statement.getKeyspace();
        }
        return null;
    }

    @Override
    public CqlIdentifier getRoutingKeyspace() {
        if (this.routingKeyspace != null) {
            return this.routingKeyspace;
        }
        for (BatchableStatement<?> statement : this.statements) {
            CqlIdentifier ks = statement.getRoutingKeyspace();
            if (ks == null) continue;
            return ks;
        }
        return null;
    }

    @Override
    @NonNull
    public BatchStatement setRoutingKeyspace(CqlIdentifier newRoutingKeyspace) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, newRoutingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public BatchStatement setNode(@Nullable Node newNode) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, newNode, this.nowInSeconds);
    }

    @Override
    @Nullable
    public Node getNode() {
        return this.node;
    }

    @Override
    public ByteBuffer getRoutingKey() {
        if (this.routingKey != null) {
            return this.routingKey;
        }
        for (BatchableStatement<?> statement : this.statements) {
            ByteBuffer key = statement.getRoutingKey();
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Override
    @NonNull
    public BatchStatement setRoutingKey(ByteBuffer newRoutingKey) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, newRoutingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public Token getRoutingToken() {
        if (this.routingToken != null) {
            return this.routingToken;
        }
        for (BatchableStatement<?> statement : this.statements) {
            Token token = statement.getRoutingToken();
            if (token == null) continue;
            return token;
        }
        return null;
    }

    @Override
    @NonNull
    public BatchStatement setRoutingToken(Token newRoutingToken) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, newRoutingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public Map<String, ByteBuffer> getCustomPayload() {
        return this.customPayload;
    }

    @Override
    @NonNull
    public DefaultBatchStatement setCustomPayload(@NonNull Map<String, ByteBuffer> newCustomPayload) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, newCustomPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public Boolean isIdempotent() {
        return this.idempotent;
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return null;
    }

    @Override
    @NonNull
    public DefaultBatchStatement setIdempotent(Boolean newIdempotence) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, newIdempotence, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public boolean isTracing() {
        return this.tracing;
    }

    @Override
    @NonNull
    public BatchStatement setTracing(boolean newTracing) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, newTracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    public long getQueryTimestamp() {
        return this.timestamp;
    }

    @Override
    @NonNull
    public BatchStatement setQueryTimestamp(long newTimestamp) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, newTimestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, this.nowInSeconds);
    }

    @Override
    @NonNull
    public BatchStatement setTimeout(@Nullable Duration newTimeout) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, newTimeout, this.node, this.nowInSeconds);
    }

    @Override
    public int getNowInSeconds() {
        return this.nowInSeconds;
    }

    @Override
    @NonNull
    public BatchStatement setNowInSeconds(int newNowInSeconds) {
        return new DefaultBatchStatement(this.batchType, this.statements, this.executionProfileName, this.executionProfile, this.keyspace, this.routingKeyspace, this.routingKey, this.routingToken, this.customPayload, this.idempotent, this.tracing, this.timestamp, this.pagingState, this.pageSize, this.consistencyLevel, this.serialConsistencyLevel, this.timeout, this.node, newNowInSeconds);
    }
}

