/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class DefaultRow
implements Row,
Serializable {
    private final ColumnDefinitions definitions;
    private final List<ByteBuffer> data;
    private volatile transient AttachmentPoint attachmentPoint;

    public DefaultRow(ColumnDefinitions definitions, List<ByteBuffer> data, AttachmentPoint attachmentPoint) {
        this.definitions = definitions;
        this.data = data;
        this.attachmentPoint = attachmentPoint;
    }

    public DefaultRow(ColumnDefinitions definitions, List<ByteBuffer> data) {
        this(definitions, data, AttachmentPoint.NONE);
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.definitions;
    }

    @Override
    public int size() {
        return this.definitions.size();
    }

    @Override
    @NonNull
    public DataType getType(int i) {
        return this.definitions.get(i).getType();
    }

    @Override
    public int firstIndexOf(@NonNull CqlIdentifier id) {
        int indexOf = this.definitions.firstIndexOf(id);
        if (indexOf == -1) {
            throw new IllegalArgumentException(id + " is not a column in this row");
        }
        return indexOf;
    }

    @Override
    @NonNull
    public DataType getType(@NonNull CqlIdentifier id) {
        return this.definitions.get(this.firstIndexOf(id)).getType();
    }

    @Override
    public int firstIndexOf(@NonNull String name) {
        int indexOf = this.definitions.firstIndexOf(name);
        if (indexOf == -1) {
            throw new IllegalArgumentException(name + " is not a column in this row");
        }
        return indexOf;
    }

    @Override
    @NonNull
    public DataType getType(@NonNull String name) {
        return this.definitions.get(this.firstIndexOf(name)).getType();
    }

    @Override
    @NonNull
    public CodecRegistry codecRegistry() {
        return this.attachmentPoint.getCodecRegistry();
    }

    @Override
    @NonNull
    public ProtocolVersion protocolVersion() {
        return this.attachmentPoint.getProtocolVersion();
    }

    @Override
    public boolean isDetached() {
        return this.attachmentPoint == AttachmentPoint.NONE;
    }

    @Override
    public void attach(@NonNull AttachmentPoint attachmentPoint) {
        this.attachmentPoint = attachmentPoint;
        this.definitions.attach(attachmentPoint);
    }

    @Override
    @Nullable
    public ByteBuffer getBytesUnsafe(int i) {
        return this.data.get(i);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ColumnDefinitions definitions;
        private final byte[][] values;

        SerializationProxy(DefaultRow row) {
            this.definitions = row.definitions;
            this.values = new byte[row.data.size()][];
            int i = 0;
            for (ByteBuffer buffer : row.data) {
                this.values[i] = buffer == null ? null : Bytes.getArray((ByteBuffer)buffer);
                ++i;
            }
        }

        private Object readResolve() {
            ArrayList<ByteBuffer> data = new ArrayList<ByteBuffer>(this.values.length);
            for (byte[] value : this.values) {
                data.add(value == null ? null : ByteBuffer.wrap(value));
            }
            return new DefaultRow(this.definitions, data);
        }
    }
}

