/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metrics;

import com.codahale.metrics.MetricRegistry;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.Metrics;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metrics.DefaultMetrics;
import com.datastax.oss.driver.internal.core.metrics.DropwizardNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.DropwizardSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopNodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.NoopSessionMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.base.Ticker;
import com.datastax.oss.driver.shaded.guava.common.cache.Cache;
import com.datastax.oss.driver.shaded.guava.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DropwizardMetricsFactory
implements MetricsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DropwizardMetricsFactory.class);
    static final Duration LOWEST_ACCEPTABLE_EXPIRE_AFTER = Duration.ofMinutes(5L);
    static final Duration DEFAULT_EXPIRE_AFTER = Duration.ofHours(1L);
    private final String logPrefix;
    private final InternalDriverContext context;
    private final Set<NodeMetric> enabledNodeMetrics;
    private final MetricRegistry registry;
    @Nullable
    private final Metrics metrics;
    private final SessionMetricUpdater sessionUpdater;
    private final Cache<Node, DropwizardNodeMetricUpdater> metricsCache;

    public DropwizardMetricsFactory(InternalDriverContext context, Ticker ticker) {
        this.logPrefix = context.getSessionName();
        this.context = context;
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Set<SessionMetric> enabledSessionMetrics = this.parseSessionMetricPaths(config.getStringList(DefaultDriverOption.METRICS_SESSION_ENABLED));
        Duration evictionTime = DropwizardMetricsFactory.getAndValidateEvictionTime(config, this.logPrefix);
        this.enabledNodeMetrics = this.parseNodeMetricPaths(config.getStringList(DefaultDriverOption.METRICS_NODE_ENABLED));
        this.metricsCache = CacheBuilder.newBuilder().ticker(ticker).expireAfterAccess(evictionTime).removalListener(notification -> {
            LOG.debug("[{}] Removing metrics for node: {} from cache after {}", new Object[]{this.logPrefix, notification.getKey(), evictionTime});
            ((DropwizardNodeMetricUpdater)notification.getValue()).cleanupNodeMetrics();
        }).build();
        if (enabledSessionMetrics.isEmpty() && this.enabledNodeMetrics.isEmpty()) {
            LOG.debug("[{}] All metrics are disabled, Session.getMetrics will be empty", (Object)this.logPrefix);
            this.registry = null;
            this.sessionUpdater = NoopSessionMetricUpdater.INSTANCE;
            this.metrics = null;
        } else {
            this.registry = new MetricRegistry();
            DropwizardSessionMetricUpdater dropwizardSessionUpdater = new DropwizardSessionMetricUpdater(enabledSessionMetrics, this.registry, context);
            this.sessionUpdater = dropwizardSessionUpdater;
            this.metrics = new DefaultMetrics(this.registry, dropwizardSessionUpdater);
        }
    }

    @VisibleForTesting
    static Duration getAndValidateEvictionTime(DriverExecutionProfile config, String logPrefix) {
        Duration evictionTime = config.getDuration(DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER);
        if (evictionTime.compareTo(LOWEST_ACCEPTABLE_EXPIRE_AFTER) < 0) {
            LOG.warn("[{}] Value too low for {}: {} (It should be higher than {}). Forcing to {} instead.", new Object[]{logPrefix, DefaultDriverOption.METRICS_NODE_EXPIRE_AFTER.getPath(), evictionTime, LOWEST_ACCEPTABLE_EXPIRE_AFTER, DEFAULT_EXPIRE_AFTER});
        }
        return evictionTime;
    }

    @Override
    public Optional<Metrics> getMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    @Override
    public SessionMetricUpdater getSessionUpdater() {
        return this.sessionUpdater;
    }

    @Override
    public NodeMetricUpdater newNodeUpdater(Node node) {
        if (this.registry == null) {
            return NoopNodeMetricUpdater.INSTANCE;
        }
        DropwizardNodeMetricUpdater dropwizardNodeMetricUpdater = new DropwizardNodeMetricUpdater(node, this.enabledNodeMetrics, this.registry, this.context, () -> {
            DropwizardNodeMetricUpdater cfr_ignored_0 = (DropwizardNodeMetricUpdater)this.metricsCache.getIfPresent((Object)node);
        });
        this.metricsCache.put((Object)node, (Object)dropwizardNodeMetricUpdater);
        return dropwizardNodeMetricUpdater;
    }

    protected Set<SessionMetric> parseSessionMetricPaths(List<String> paths) {
        HashSet<Enum> result = new HashSet<Enum>();
        for (String path : paths) {
            try {
                result.add(DefaultSessionMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add(DseSessionMetric.fromPath(path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown session metric {}, skipping", (Object)this.logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }

    protected Set<NodeMetric> parseNodeMetricPaths(List<String> paths) {
        HashSet<Enum> result = new HashSet<Enum>();
        for (String path : paths) {
            try {
                result.add(DefaultNodeMetric.fromPath(path));
            }
            catch (IllegalArgumentException e) {
                try {
                    result.add(DseNodeMetric.fromPath(path));
                }
                catch (IllegalArgumentException e1) {
                    LOG.warn("[{}] Unknown node metric {}, skipping", (Object)this.logPrefix, (Object)path);
                }
            }
        }
        return Collections.unmodifiableSet(result);
    }
}

