/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.oss.driver.api.core;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.yugabyte.oss.driver.api.core.PartitionMetadata;
import com.yugabyte.oss.driver.api.core.QualifiedTableName;
import com.yugabyte.oss.driver.api.core.TableSplitMetadata;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class DefaultPartitionMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPartitionMetadata.class);
    private static final String SELECT_PARTITIONS = "SELECT keyspace_name, table_name, start_key, end_key, replica_addresses FROM system.partitions";
    private static final int INFINITE_PAGE_SIZE = -1;
    private static final Set<String> SYSTEM_KEYSPACES = ImmutableSet.of((Object)"system", (Object)"system_auth", (Object)"system_distributed", (Object)"system_schema", (Object)"system_traces");
    private final String logPrefix;
    private final ControlConnection controlConnection;
    private final Duration timeout;
    private final CompletableFuture<Void> closeFuture;
    private final boolean partitionMetadataEnabled;
    private final Map<QualifiedTableName, TableSplitMetadata> tableSplits;

    public DefaultPartitionMetadata(String logPrefix, ControlConnection controlConnection, Duration timeout, boolean partitionMetadataEnabled, Map<UUID, Node> nodes) {
        this.logPrefix = logPrefix;
        this.controlConnection = controlConnection;
        this.timeout = timeout;
        this.closeFuture = new CompletableFuture();
        this.partitionMetadataEnabled = partitionMetadataEnabled;
        this.tableSplits = this.refreshPartitionMap(this.partitionMetadataEnabled, nodes);
    }

    public Map<QualifiedTableName, TableSplitMetadata> getPartitionMap() {
        return this.tableSplits;
    }

    public TableSplitMetadata getTableSplitMetadata(String keyspaceName, String tableName) {
        if (this.tableSplits == null) {
            return null;
        }
        return this.tableSplits.get(new QualifiedTableName(keyspaceName, tableName));
    }

    private Map<QualifiedTableName, TableSplitMetadata> refreshPartitionMap(boolean partitionMetadataEnabled, Map<UUID, Node> nodes) {
        HashMap<QualifiedTableName, TableSplitMetadata> tableSplits = new HashMap<QualifiedTableName, TableSplitMetadata>();
        if (this.closeFuture.isDone()) {
            CompletableFutures.failedFuture(new IllegalStateException("closed")).whenComplete((result, error) -> {
                if (error != null) {
                    Loggers.warnWithException(LOG, "[{}] Unexpected error while refreshing Partition Metadata, keeping previous version", this.logPrefix, error);
                }
            });
            return null;
        }
        if (partitionMetadataEnabled) {
            HashMap hostMap = new HashMap();
            nodes.forEach((id, node) -> hostMap.put(node.getBroadcastRpcAddress().get().getAddress(), node));
            DriverChannel channel = this.controlConnection.channel();
            this.query(channel, SELECT_PARTITIONS).thenApply(result -> this.createPartitionMap((AdminResult)result, hostMap)).whenComplete((result, error) -> {
                if (error != null) {
                    Loggers.warnWithException(LOG, "[{}] Unexpected error while refreshing Partition Metadata, keeping previous version", this.logPrefix, error);
                } else {
                    tableSplits.putAll((Map)result.get());
                }
            });
        }
        return tableSplits;
    }

    private Optional<Map<QualifiedTableName, TableSplitMetadata>> createPartitionMap(AdminResult result, Map<InetAddress, Node> hostMap) {
        HashMap<QualifiedTableName, TableSplitMetadata> tableSplits = new HashMap<QualifiedTableName, TableSplitMetadata>();
        for (AdminRow row : result) {
            QualifiedTableName tableId = new QualifiedTableName(row.getString("keyspace_name"), row.getString("table_name"));
            TableSplitMetadata tableSplitMetadata = (TableSplitMetadata)tableSplits.get(tableId);
            if (tableSplitMetadata == null) {
                tableSplitMetadata = new TableSplitMetadata();
                tableSplits.put(tableId, tableSplitMetadata);
            }
            Map<InetAddress, String> replicaAddresses = row.getMapOfInetAddressToString("replica_addresses");
            ArrayList<Node> hosts = new ArrayList<Node>();
            for (Map.Entry<InetAddress, String> entry : replicaAddresses.entrySet()) {
                Node host = hostMap.get(entry.getKey());
                if (host == null) {
                    if (this.isSystem(tableId.getKeyspaceName())) continue;
                    LOG.debug("Host " + entry.getKey() + " not found in cluster metadata for table " + tableId.toString());
                    continue;
                }
                String role = entry.getValue();
                if (role.equals("LEADER")) {
                    hosts.add(0, host);
                    continue;
                }
                if (!role.equals("FOLLOWER") && !role.equals("READ_REPLICA")) continue;
                hosts.add(host);
            }
            int startKey = DefaultPartitionMetadata.getKey(row.getByteBuffer("start_key"));
            int endKey = DefaultPartitionMetadata.getKey(row.getByteBuffer("end_key"));
            tableSplitMetadata.getPartitionMap().put(startKey, new PartitionMetadata(startKey, endKey, hosts));
        }
        return Optional.ofNullable(tableSplits);
    }

    private CompletionStage<AdminResult> query(DriverChannel channel, String queryString, Map<String, Object> parameters) {
        AdminRequestHandler<AdminResult> handler;
        try {
            handler = AdminRequestHandler.query(channel, queryString, parameters, this.timeout, -1, this.logPrefix);
        }
        catch (Exception e) {
            return CompletableFutures.failedFuture(e);
        }
        return handler.start();
    }

    private CompletionStage<AdminResult> query(DriverChannel channel, String queryString) {
        return this.query(channel, queryString, Collections.emptyMap());
    }

    private boolean isSystem(String keyspaceName) {
        return SYSTEM_KEYSPACES.contains(keyspaceName);
    }

    private static int getKey(ByteBuffer bb) {
        int key = bb.remaining() == 0 ? 0 : bb.getShort();
        return key >= 0 ? key : key + 65536;
    }
}

