/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YugabyteDefaultLoadBalancingPolicy
extends BasicLoadBalancingPolicy
implements RequestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(YugabyteDefaultLoadBalancingPolicy.class);
    private volatile LoadBalancingPolicy.DistanceReporter distanceReporter;
    private volatile Predicate<Node> filter;
    private volatile String localDc;
    protected final CopyOnWriteArraySet<Node> liveNodesInLocalDc = new CopyOnWriteArraySet();
    protected final CopyOnWriteArraySet<Node> liveNodesInAllDC = new CopyOnWriteArraySet();
    protected final Map<Node, AtomicLongArray> responseTimes = new ConcurrentHashMap<Node, AtomicLongArray>();

    public YugabyteDefaultLoadBalancingPolicy(DriverContext context, String profileName) {
        super(context, profileName);
    }

    @Override
    public void init(@NonNull Map<UUID, Node> nodes, @NonNull LoadBalancingPolicy.DistanceReporter distanceReporter) {
        this.distanceReporter = distanceReporter;
        this.localDc = this.discoverLocalDc(nodes).orElse(null);
        this.filter = this.createNodeFilter(this.localDc, nodes);
        for (Node node : nodes.values()) {
            this.addToLiveNodeLists(node);
        }
    }

    @Override
    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        Object[] currentNodes = null;
        ConsistencyLevel requestConsistencyLevel = this.findConsistencyLevelForRequest(request);
        if (!StringUtils.isBlank((String)this.localDc) && requestConsistencyLevel == ConsistencyLevel.YB_CONSISTENT_PREFIX) {
            currentNodes = this.liveNodesInLocalDc.toArray();
            if (currentNodes.length == 0) {
                LOG.trace("[{}] No nodes available in Local DC {}, falling back on to liveNodes", (Object)this.logPrefix, (Object)this.localDc);
                currentNodes = this.liveNodes.toArray();
            }
        } else {
            currentNodes = this.liveNodesInAllDC.toArray();
        }
        LOG.trace("[{}] Round-robing the {} avaiable nodes", (Object)this.logPrefix, (Object)currentNodes.length);
        ArrayUtils.rotate(currentNodes, 0, currentNodes.length, this.roundRobinAmount.getAndUpdate(INCREMENT));
        return new QueryPlan(currentNodes);
    }

    @Override
    public void onUp(@NonNull Node node) {
        this.addToLiveNodeLists(node);
    }

    @Override
    public void onAdd(@NonNull Node node) {
        this.addToLiveNodeLists(node);
    }

    @Override
    public void onDown(@NonNull Node node) {
        if (this.handleNodeDownEvent(node)) {
            LOG.debug("[{}] {} went DOWN, removed from live sets", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onRemove(@NonNull Node node) {
        if (this.handleNodeDownEvent(node)) {
            LOG.debug("[{}] {} was removed, removed from live sets", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onNodeSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        this.updateResponseTimes(node);
    }

    @Override
    public void onNodeError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node, @NonNull String logPrefix) {
        this.updateResponseTimes(node);
    }

    private void addToLiveNodeLists(@NonNull Node node) {
        if (!StringUtils.isBlank((String)this.localDc)) {
            if (this.filter.test(node)) {
                this.distanceReporter.setDistance(node, NodeDistance.LOCAL);
                if (node.getState() != NodeState.DOWN) {
                    this.liveNodesInLocalDc.add(node);
                    this.liveNodesInAllDC.add(node);
                }
            } else if (node.getState() == NodeState.UP || node.getState() == NodeState.UNKNOWN) {
                this.liveNodes.add(node);
                this.liveNodesInAllDC.add(node);
                LOG.debug("[{}] Adding {} as it belongs to the {} DC in Multi-DC/Region Setup", new Object[]{this.logPrefix, node, node.getDatacenter()});
                this.distanceReporter.setDistance(node, NodeDistance.REMOTE);
            } else {
                this.distanceReporter.setDistance(node, NodeDistance.IGNORED);
            }
        } else {
            this.distanceReporter.setDistance(node, NodeDistance.LOCAL);
            if (node.getState() != NodeState.DOWN) {
                this.liveNodesInAllDC.add(node);
            }
        }
    }

    private boolean handleNodeDownEvent(Node node) {
        boolean handleSuccess = false;
        if (this.liveNodesInAllDC.contains(node)) {
            this.liveNodesInAllDC.remove(node);
            handleSuccess = true;
        }
        if (this.liveNodesInLocalDc.contains(node)) {
            this.liveNodesInLocalDc.remove(node);
            handleSuccess = true;
        }
        if (this.liveNodes.contains(node)) {
            this.liveNodes.remove(node);
            handleSuccess = true;
        }
        return handleSuccess;
    }

    private ConsistencyLevel findConsistencyLevelForRequest(Request request) {
        Statement ycqlStatement;
        ConsistencyLevel statementConsistencyLevel = ConsistencyLevel.YB_STRONG;
        if (request instanceof Statement && (ycqlStatement = (Statement)request).getConsistencyLevel() != null) {
            statementConsistencyLevel = ycqlStatement.getConsistencyLevel();
        }
        return statementConsistencyLevel;
    }

    protected void updateResponseTimes(@NonNull Node node) {
        this.responseTimes.compute(node, (n, array) -> {
            long now = this.nanoTime();
            if (array == null) {
                array = new AtomicLongArray(1);
                array.set(0, now);
            } else if (array.length() == 1) {
                long previous = array.get(0);
                array = new AtomicLongArray(2);
                array.set(0, previous);
                array.set(1, now);
            } else {
                array.set(0, array.get(1));
                array.set(1, now);
            }
            return array;
        });
    }

    protected long nanoTime() {
        return System.nanoTime();
    }
}

