/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.jdbc.PgConnection;
import com.yugabyte.util.GT;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterAwareLoadBalancer {
    protected static final String GET_SERVERS_QUERY = "select * from yb_servers()";
    protected static final Logger LOGGER = Logger.getLogger("com.yugabyte.Driver");
    private static volatile ClusterAwareLoadBalancer instance;
    private long lastServerListFetchTime = 0L;
    private volatile ArrayList<String> servers = null;
    Map<String, Integer> hostToNumConnMap = new HashMap<String, Integer>();
    Set<String> unreachableHosts = new HashSet<String>();
    protected Map<String, String> hostPortMap = new HashMap<String, String>();
    protected Map<String, String> hostPortMapPublic = new HashMap<String, String>();
    protected ArrayList<String> currentPublicIps = new ArrayList();
    protected Boolean useHostColumn = null;
    public static int refreshListSeconds;
    public static boolean forceRefresh;
    protected static String columnToUseForHost;

    public static ClusterAwareLoadBalancer instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterAwareLoadBalancer getInstance() {
        if (instance != null) return instance;
        Class<ClusterAwareLoadBalancer> clazz = ClusterAwareLoadBalancer.class;
        synchronized (ClusterAwareLoadBalancer.class) {
            if (instance != null) return instance;
            instance = new ClusterAwareLoadBalancer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getPort(String host) {
        String port = this.hostPortMap.get(host);
        if (port == null) {
            port = this.hostPortMapPublic.get(host);
        }
        return port;
    }

    public synchronized String getLeastLoadedServer(List<String> failedHosts) {
        int min = Integer.MAX_VALUE;
        ArrayList<String> minConnectionsHostList = new ArrayList<String>();
        for (String h : this.hostToNumConnMap.keySet()) {
            if (failedHosts.contains(h)) continue;
            int currLoad = this.hostToNumConnMap.get(h);
            if (currLoad < min) {
                min = currLoad;
                minConnectionsHostList.clear();
                minConnectionsHostList.add(h);
                continue;
            }
            if (currLoad != min) continue;
            minConnectionsHostList.add(h);
        }
        String chosenHost = null;
        if (minConnectionsHostList.size() > 0) {
            int idx = ThreadLocalRandom.current().nextInt(0, minConnectionsHostList.size());
            chosenHost = (String)minConnectionsHostList.get(idx);
        }
        if (chosenHost != null) {
            this.updateConnectionMap(chosenHost, 1);
        } else if (this.useHostColumn == null) {
            ArrayList<String> newList = new ArrayList<String>();
            newList.addAll(this.currentPublicIps);
            if (!newList.isEmpty()) {
                this.useHostColumn = Boolean.FALSE;
                this.servers = newList;
                this.unreachableHosts.clear();
                for (String h : this.servers) {
                    if (this.hostToNumConnMap.containsKey(h)) continue;
                    this.hostToNumConnMap.put(h, 0);
                }
                return this.getLeastLoadedServer(failedHosts);
            }
        }
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Host chosen for new connection: " + chosenHost);
        return chosenHost;
    }

    public boolean needsRefresh() {
        boolean firstTime;
        if (forceRefresh) {
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Force Refresh is set to true");
            return true;
        }
        long currentTimeInMillis = System.currentTimeMillis();
        long diff = (currentTimeInMillis - this.lastServerListFetchTime) / 1000L;
        boolean bl = firstTime = this.servers == null;
        if (firstTime || diff > (long)refreshListSeconds) {
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Needs refresh as list of servers may be stale or being fetched for the first time");
            return true;
        }
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Refresh not required.");
        return false;
    }

    protected ArrayList<String> getCurrentServers(Connection conn) throws SQLException {
        InetAddress hostConnectedInetAddr;
        Statement st = conn.createStatement();
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Executing query: " + GET_SERVERS_QUERY + " to fetch list of servers");
        ResultSet rs = st.executeQuery(GET_SERVERS_QUERY);
        ArrayList<String> currentPrivateIps = new ArrayList<String>();
        String hostConnectedTo = ((PgConnection)conn).getQueryExecutor().getHostSpec().getHost();
        boolean isIpv6Addresses = hostConnectedTo.contains(":");
        if (isIpv6Addresses) {
            hostConnectedTo = hostConnectedTo.replace("[", "").replace("]", "");
        }
        try {
            hostConnectedInetAddr = InetAddress.getByName(hostConnectedTo);
        }
        catch (UnknownHostException e) {
            throw new PSQLException(GT.tr("Unexpected UnknownHostException for ${0} ", hostConnectedTo), PSQLState.UNKNOWN_STATE, (Throwable)e);
        }
        this.currentPublicIps.clear();
        while (rs.next()) {
            InetAddress publicHostInetAddr;
            InetAddress hostInetAddr;
            String host = rs.getString("host");
            String publicHost = rs.getString("public_ip");
            String port = rs.getString("port");
            String cloud = rs.getString("cloud");
            String region = rs.getString("region");
            String zone = rs.getString("zone");
            this.hostPortMap.put(host, port);
            this.hostPortMapPublic.put(publicHost, port);
            this.updateCurrentHostList(currentPrivateIps, host, publicHost, cloud, region, zone);
            try {
                hostInetAddr = InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                hostInetAddr = null;
            }
            try {
                publicHostInetAddr = !publicHost.isEmpty() ? InetAddress.getByName(publicHost) : null;
            }
            catch (UnknownHostException e) {
                publicHostInetAddr = null;
            }
            if (this.useHostColumn != null) continue;
            if (hostConnectedInetAddr.equals(hostInetAddr)) {
                this.useHostColumn = Boolean.TRUE;
                continue;
            }
            if (!hostConnectedInetAddr.equals(publicHostInetAddr)) continue;
            this.useHostColumn = Boolean.FALSE;
        }
        return this.getPrivateOrPublicServers(currentPrivateIps, this.currentPublicIps);
    }

    protected ArrayList<String> getPrivateOrPublicServers(ArrayList<String> privateHosts, ArrayList<String> publicHosts) {
        if (this.useHostColumn == null) {
            if (publicHosts.isEmpty()) {
                this.useHostColumn = Boolean.TRUE;
            }
            LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": Either private or public should have matched with one of the servers. Using private addresses.");
            return privateHosts;
        }
        ArrayList<String> currentHosts = this.useHostColumn != false ? privateHosts : publicHosts;
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": List of servers got {0}", currentHosts);
        return currentHosts;
    }

    protected void updateCurrentHostList(ArrayList<String> currentPrivateIps, String host, String publicIp, String cloud, String region, String zone) {
        currentPrivateIps.add(host);
        if (!publicIp.trim().isEmpty()) {
            this.currentPublicIps.add(publicIp);
        }
    }

    protected String getLoadBalancerType() {
        return "ClusterAwareLoadBalancer";
    }

    public synchronized boolean refresh(Connection conn) throws SQLException {
        if (!this.needsRefresh()) {
            return true;
        }
        long currTime = System.currentTimeMillis();
        this.servers = this.getCurrentServers(conn);
        if (this.servers == null) {
            return false;
        }
        this.lastServerListFetchTime = currTime;
        this.unreachableHosts.clear();
        for (String h : this.servers) {
            if (this.hostToNumConnMap.containsKey(h)) continue;
            this.hostToNumConnMap.put(h, 0);
        }
        return true;
    }

    public List<String> getServers() {
        return Collections.unmodifiableList(this.servers);
    }

    public synchronized void updateConnectionMap(String host, int incDec) {
        LOGGER.log(Level.FINE, this.getLoadBalancerType() + ": updating connection count for {0} by {1}", new String[]{host, String.valueOf(incDec)});
        Integer currentCount = this.hostToNumConnMap.get(host);
        if (currentCount == 0 && incDec < 0) {
            return;
        }
        if (currentCount == null && incDec > 0) {
            this.hostToNumConnMap.put(host, incDec);
        } else if (currentCount != null) {
            this.hostToNumConnMap.put(host, currentCount + incDec);
        }
    }

    public Set<String> getUnreachableHosts() {
        return this.unreachableHosts;
    }

    public synchronized void updateFailedHosts(String chosenHost) {
        this.unreachableHosts.add(chosenHost);
        this.hostToNumConnMap.remove(chosenHost);
    }

    protected String loadBalancingNodes() {
        return "all";
    }

    public void setForRefresh() {
        this.lastServerListFetchTime = 0L;
    }

    public void printHostToConnMap() {
        System.out.println("Current load on " + this.loadBalancingNodes() + " servers");
        System.out.println("-------------------");
        for (Map.Entry<String, Integer> e : this.hostToNumConnMap.entrySet()) {
            System.out.println(e.getKey() + " - " + e.getValue());
        }
    }

    static {
        refreshListSeconds = 300;
        forceRefresh = false;
        columnToUseForHost = null;
    }
}

