/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import com.yugabyte.ysql.TopologyAwareLoadBalancer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadBalanceProperties {
    private static final String SIMPLE_LB = "simple";
    private static final String LOAD_BALANCE_PROPERTY_KEY = "load-balance";
    private static final String TOPOLOGY_AWARE_PROPERTY_KEY = "topology-keys";
    private static final String PROPERTY_SEP = "&";
    private static final String EQUALS = "=";
    private static final Logger LOGGER = Logger.getLogger("com.yugabyte.Driver");
    public static final Map<String, ClusterAwareLoadBalancer> CONNECTION_MANAGER_MAP = new HashMap<String, ClusterAwareLoadBalancer>();
    private final String originalUrl;
    private final Properties originalProperties;
    private final Properties strippedProperties;
    private boolean hasLoadBalance;
    private final String ybURL;
    private String placements = null;

    public LoadBalanceProperties(String origUrl, Properties origProperties) {
        this.originalUrl = origUrl;
        this.originalProperties = origProperties;
        this.strippedProperties = (Properties)origProperties.clone();
        this.strippedProperties.remove(LOAD_BALANCE_PROPERTY_KEY);
        this.strippedProperties.remove(TOPOLOGY_AWARE_PROPERTY_KEY);
        this.ybURL = this.processURLAndProperties();
    }

    public String processURLAndProperties() {
        String[] urlParts = this.originalUrl.split(PROPERTY_SEP);
        StringBuilder sb = new StringBuilder();
        String loadBalancerKey = "load-balance=";
        String topologyKey = "topology-keys=";
        for (String part : urlParts) {
            String[] lbParts;
            if (sb.length() == 0) {
                sb.append(part);
                continue;
            }
            if (part.startsWith(loadBalancerKey)) {
                lbParts = part.split(EQUALS);
                if (lbParts.length < 2) {
                    LOGGER.log(Level.WARNING, "No value provided for load balance property. Ignoring it.");
                    continue;
                }
                String propValue = lbParts[1];
                if (!propValue.equalsIgnoreCase("true")) continue;
                this.hasLoadBalance = true;
                continue;
            }
            if (part.startsWith(topologyKey)) {
                lbParts = part.split(EQUALS);
                if (lbParts.length < 2) {
                    LOGGER.log(Level.WARNING, "No value provided for topology keys. Ignoring it.");
                    continue;
                }
                this.placements = lbParts[1];
                continue;
            }
            sb.append('&');
            sb.append(part);
        }
        if (this.originalProperties != null) {
            String propValue;
            if (this.originalProperties.containsKey(LOAD_BALANCE_PROPERTY_KEY) && (propValue = this.originalProperties.getProperty(LOAD_BALANCE_PROPERTY_KEY)).equals("true")) {
                this.hasLoadBalance = true;
            }
            if (this.originalProperties.containsKey(TOPOLOGY_AWARE_PROPERTY_KEY)) {
                this.placements = propValue = this.originalProperties.getProperty(TOPOLOGY_AWARE_PROPERTY_KEY);
            }
        }
        return sb.toString();
    }

    public String getOriginalURL() {
        return this.originalUrl;
    }

    public Properties getOriginalProperties() {
        return this.originalProperties;
    }

    public Properties getStrippedProperties() {
        return this.strippedProperties;
    }

    public boolean hasLoadBalance() {
        return this.hasLoadBalance;
    }

    public String getPlacements() {
        return this.placements;
    }

    public String getStrippedURL() {
        return this.ybURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterAwareLoadBalancer getAppropriateLoadBalancer() {
        if (!this.hasLoadBalance) {
            throw new IllegalStateException("This method is expected to be called only when load-balance is true");
        }
        ClusterAwareLoadBalancer ld = null;
        if (this.placements == null) {
            ld = CONNECTION_MANAGER_MAP.get(SIMPLE_LB);
            if (ld == null) {
                Map<String, ClusterAwareLoadBalancer> map = CONNECTION_MANAGER_MAP;
                synchronized (map) {
                    ld = CONNECTION_MANAGER_MAP.get(SIMPLE_LB);
                    if (ld == null) {
                        ld = ClusterAwareLoadBalancer.getInstance();
                        CONNECTION_MANAGER_MAP.put(SIMPLE_LB, ld);
                    }
                }
            }
        } else {
            ld = CONNECTION_MANAGER_MAP.get(this.placements);
            if (ld == null) {
                Map<String, ClusterAwareLoadBalancer> map = CONNECTION_MANAGER_MAP;
                synchronized (map) {
                    ld = CONNECTION_MANAGER_MAP.get(this.placements);
                    if (ld == null) {
                        ld = new TopologyAwareLoadBalancer(this.placements);
                        CONNECTION_MANAGER_MAP.put(this.placements, ld);
                    }
                }
            }
        }
        return ld;
    }
}

