/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte;

import com.yugabyte.PGProperty;
import com.yugabyte.jdbc.PgConnection;
import com.yugabyte.util.ExpressionProperties;
import com.yugabyte.util.GT;
import com.yugabyte.util.HostSpec;
import com.yugabyte.util.LogWriterHandler;
import com.yugabyte.util.PGPropertyPasswordParser;
import com.yugabyte.util.PGPropertyServiceParser;
import com.yugabyte.util.PGPropertyUtil;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import com.yugabyte.util.SharedTimer;
import com.yugabyte.util.URLCoder;
import com.yugabyte.util.internal.Nullness;
import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import com.yugabyte.ysql.LoadBalanceProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Driver
implements java.sql.Driver {
    private static @Nullable Driver registeredDriver;
    private static final Logger PARENT_LOGGER;
    private static final Logger LOGGER;
    private static final SharedTimer SHARED_TIMER;
    private static final String DEFAULT_PORT = "5433";
    private @Nullable Properties defaultProperties;
    private static @Nullable String loggerHandlerFile;

    private synchronized Properties getDefaultProperties() throws IOException {
        if (this.defaultProperties != null) {
            return this.defaultProperties;
        }
        try {
            this.defaultProperties = AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return Driver.this.loadDefaultProperties();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        return this.defaultProperties;
    }

    private Properties loadDefaultProperties() throws IOException {
        Properties merged = new Properties();
        try {
            PGProperty.USER.set(merged, System.getProperty("user.name"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl == null) {
            LOGGER.log(Level.FINE, "Can't find our classloader for the Driver; attempt to use the system class loader");
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            LOGGER.log(Level.WARNING, "Can't find a classloader for the Driver; not loading driver configuration from org/postgresql/driverconfig.properties");
            return merged;
        }
        LOGGER.log(Level.FINE, "Loading driver configuration via classloader {0}", cl);
        ArrayList<URL> urls = new ArrayList<URL>();
        Enumeration<URL> urlEnum = cl.getResources("com/yugabyte/driverconfig.properties");
        while (urlEnum.hasMoreElements()) {
            urls.add(urlEnum.nextElement());
        }
        for (int i = urls.size() - 1; i >= 0; --i) {
            URL url = (URL)urls.get(i);
            LOGGER.log(Level.FINE, "Loading driver configuration from: {0}", url);
            InputStream is = url.openStream();
            merged.load(is);
            is.close();
        }
        return merged;
    }

    @Override
    public @Nullable Connection connect(String url, @Nullable Properties info) throws SQLException {
        Properties defaults;
        if (url == null) {
            throw new SQLException("url is null");
        }
        if (!url.startsWith("jdbc:yugabytedb:")) {
            return null;
        }
        try {
            defaults = this.getDefaultProperties();
        }
        catch (IOException ioe) {
            throw new PSQLException(GT.tr("Error loading default settings from driverconfig.properties", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ioe);
        }
        Properties props = new Properties(defaults);
        if (info != null) {
            Set<String> e = info.stringPropertyNames();
            for (String propName : e) {
                String propValue = info.getProperty(propName);
                if (propValue == null) {
                    throw new PSQLException(GT.tr("Properties for the driver contains a non-string value for the key ", new Object[0]) + propName, PSQLState.UNEXPECTED_ERROR);
                }
                props.setProperty(propName, propValue);
            }
        }
        if ((props = Driver.parseURL(url, props)) == null) {
            return null;
        }
        try {
            this.setupLoggerFromProperties(props);
            LOGGER.log(Level.FINE, "Connecting with URL: {0}", url);
            long timeout = Driver.timeout(props);
            if (timeout <= 0L) {
                return Driver.makeConnection(url, props);
            }
            ConnectThread ct = new ConnectThread(url, props);
            Thread thread = new Thread((Runnable)ct, "PostgreSQL JDBC driver connection thread");
            thread.setDaemon(true);
            thread.start();
            return ct.getResult(timeout);
        }
        catch (PSQLException ex1) {
            LOGGER.log(Level.FINE, "Connection error: ", ex1);
            throw ex1;
        }
        catch (AccessControlException ace) {
            throw new PSQLException(GT.tr("Your security policy has prevented the connection from being attempted.  You probably need to grant the connect java.net.SocketPermission to the database server host and port that you wish to connect to.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ace);
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINE, "Unexpected connection error: ", ex2);
            throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, (Throwable)ex2);
        }
    }

    private void setupLoggerFromProperties(Properties props) {
        String driverLogLevel = PGProperty.LOGGER_LEVEL.get(props);
        if (driverLogLevel == null) {
            return;
        }
        if ("OFF".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.OFF);
            return;
        }
        if ("DEBUG".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINE);
        } else if ("TRACE".equalsIgnoreCase(driverLogLevel)) {
            PARENT_LOGGER.setLevel(Level.FINEST);
        }
        ExpressionProperties exprProps = new ExpressionProperties(props, System.getProperties());
        String driverLogFile = PGProperty.LOGGER_FILE.get(exprProps);
        if (driverLogFile != null && driverLogFile.equals(loggerHandlerFile)) {
            return;
        }
        for (Handler handlers : PARENT_LOGGER.getHandlers()) {
            handlers.close();
            PARENT_LOGGER.removeHandler(handlers);
            loggerHandlerFile = null;
        }
        Handler handler = null;
        if (driverLogFile != null) {
            try {
                handler = new FileHandler(driverLogFile);
                loggerHandlerFile = driverLogFile;
            }
            catch (Exception ex) {
                System.err.println("Cannot enable FileHandler, fallback to ConsoleHandler.");
            }
        }
        SimpleFormatter formatter = new SimpleFormatter();
        if (handler == null) {
            handler = DriverManager.getLogWriter() != null ? new LogWriterHandler(DriverManager.getLogWriter()) : (DriverManager.getLogStream() != null ? new StreamHandler(DriverManager.getLogStream(), formatter) : new ConsoleHandler());
        } else {
            handler.setFormatter(formatter);
        }
        Level loggerLevel = PARENT_LOGGER.getLevel();
        if (loggerLevel != null) {
            handler.setLevel(loggerLevel);
        }
        PARENT_LOGGER.setUseParentHandlers(false);
        PARENT_LOGGER.addHandler(handler);
    }

    private static Connection makeConnection(String url, Properties properties) throws SQLException {
        LoadBalanceProperties lbprops = new LoadBalanceProperties(url, properties);
        if (lbprops.hasLoadBalance()) {
            Connection conn = Driver.getConnectionBalanced(lbprops);
            if (conn != null) {
                return conn;
            }
            LOGGER.log(Level.WARNING, "Failed to apply load balance. Trying normal connection");
        }
        url = lbprops.getStrippedURL();
        properties = lbprops.getStrippedProperties();
        return new PgConnection(Driver.hostSpecs(properties), Driver.user(properties), Driver.database(properties), properties, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Connection getConnectionBalanced(LoadBalanceProperties lbprops) {
        LOGGER.log(Level.FINE, "GetConnectionBalanced called");
        ClusterAwareLoadBalancer loadBalancer = lbprops.getAppropriateLoadBalancer();
        Properties props = lbprops.getStrippedProperties();
        String url = lbprops.getStrippedURL();
        Set<String> unreachableHosts = loadBalancer.getUnreachableHosts();
        ArrayList<String> failedHosts = new ArrayList<String>(unreachableHosts);
        String chosenHost = loadBalancer.getLeastLoadedServer(failedHosts);
        PgConnection newConnection = null;
        Connection controlConnection = null;
        SQLException firstException = null;
        if (chosenHost == null) {
            boolean connectionCreated = false;
            boolean gotException = false;
            try {
                HostSpec[] hspec = Driver.hostSpecs(lbprops.getOriginalProperties());
                controlConnection = new PgConnection(hspec, Driver.user(lbprops.getOriginalProperties()), Driver.database(lbprops.getOriginalProperties()), props, url);
                connectionCreated = true;
                if (!loadBalancer.refresh(controlConnection)) {
                    LOGGER.log(Level.WARNING, "yb_servers() refresh failed in first attempt itself. Falling back to default behaviour");
                    Connection connection = null;
                    return connection;
                }
                controlConnection.close();
            }
            catch (SQLException ex) {
                if (PSQLState.UNDEFINED_FUNCTION.getState().equals(ex.getSQLState())) {
                    Connection connection = null;
                    return connection;
                }
                gotException = true;
            }
            finally {
                if (gotException && connectionCreated) {
                    try {
                        controlConnection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            chosenHost = loadBalancer.getLeastLoadedServer(failedHosts);
        }
        if (chosenHost == null) {
            return null;
        }
        while (chosenHost != null) {
            block34: {
                try {
                    props.setProperty("PGHOST", chosenHost);
                    String port = loadBalancer.getPort(chosenHost);
                    if (port != null) {
                        props.setProperty("PGPORT", port);
                    }
                    newConnection = new PgConnection(Driver.hostSpecs(props), Driver.user(lbprops.getOriginalProperties()), Driver.database(props), props, url);
                    newConnection.setLoadBalancer(loadBalancer);
                    if (!loadBalancer.refresh(newConnection)) {
                        LOGGER.log(Level.WARNING, "yb_servers() refresh returned no servers");
                        loadBalancer.updateConnectionMap(chosenHost, -1);
                        failedHosts.add(chosenHost);
                        loadBalancer.setForRefresh();
                        try {
                            newConnection.close();
                        }
                        catch (Exception exception) {}
                        break block34;
                    }
                    return newConnection;
                }
                catch (SQLException ex) {
                    loadBalancer.setForRefresh();
                    try {
                        newConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    failedHosts.add(chosenHost);
                    if (PSQLState.CONNECTION_UNABLE_TO_CONNECT.getState().equals(ex.getSQLState())) {
                        if (firstException == null) {
                            firstException = ex;
                        }
                        LOGGER.log(Level.FINE, "couldn't connect to " + chosenHost + ", adding it to failed host list");
                        loadBalancer.updateFailedHosts(chosenHost);
                    }
                    LOGGER.log(Level.WARNING, "got exception " + ex.getMessage() + ", while connecting to " + chosenHost);
                }
            }
            chosenHost = loadBalancer.getLeastLoadedServer(failedHosts);
        }
        return null;
    }

    @Override
    public boolean acceptsURL(String url) {
        return Driver.parseURL(url, null) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        Properties copy = new Properties(info);
        Properties parse = Driver.parseURL(url, copy);
        if (parse != null) {
            copy = parse;
        }
        PGProperty[] knownProperties = PGProperty.values();
        DriverPropertyInfo[] props = new DriverPropertyInfo[knownProperties.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = knownProperties[i].toDriverPropertyInfo(copy);
        }
        return props;
    }

    @Override
    public int getMajorVersion() {
        return 42;
    }

    @Override
    public int getMinorVersion() {
        return 3;
    }

    @Deprecated
    public static String getVersion() {
        return "PostgreSQL JDBC Driver 42.3.5-yb-1";
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static @Nullable Properties parseURL(String url, @Nullable Properties defaults) {
        String password;
        Properties result;
        Properties priority1Url = new Properties();
        Properties priority3Service = new Properties();
        String urlServer = url;
        String urlArgs = "";
        int qPos = url.indexOf(63);
        if (qPos != -1) {
            urlServer = url.substring(0, qPos);
            urlArgs = url.substring(qPos + 1);
        }
        if (!urlServer.startsWith("jdbc:yugabytedb:")) {
            LOGGER.log(Level.FINE, "JDBC URL must start with \"jdbc:yugabytedb:\" but was: {0}", url);
            return null;
        }
        if ((urlServer = urlServer.substring("jdbc:yugabytedb:".length())).equals("//") || urlServer.equals("///")) {
            urlServer = "";
        } else if (urlServer.startsWith("//")) {
            long slashCount = (urlServer = urlServer.substring(2)).chars().filter(ch -> ch == 47).count();
            if (slashCount > 1L) {
                LOGGER.log(Level.WARNING, "JDBC URL contains too many / characters: {0}", url);
                return null;
            }
            int slash = urlServer.indexOf(47);
            if (slash == -1) {
                LOGGER.log(Level.WARNING, "JDBC URL must contain a / at the end of the host or port: {0}", url);
                return null;
            }
            if (!urlServer.endsWith("/")) {
                String value = Driver.urlDecode(urlServer.substring(slash + 1));
                if (value == null) {
                    return null;
                }
                PGProperty.PG_DBNAME.set(priority1Url, value);
            }
            urlServer = urlServer.substring(0, slash);
            String[] addresses = urlServer.split(",");
            StringBuilder hosts = new StringBuilder();
            StringBuilder ports = new StringBuilder();
            for (String address : addresses) {
                int portIdx = address.lastIndexOf(58);
                if (portIdx != -1 && address.lastIndexOf(93) < portIdx) {
                    String portStr = address.substring(portIdx + 1);
                    ports.append(portStr);
                    CharSequence hostStr = address.subSequence(0, portIdx);
                    if (hostStr.length() == 0) {
                        hosts.append(PGProperty.PG_HOST.getDefaultValue());
                    } else {
                        hosts.append(hostStr);
                    }
                } else {
                    ports.append(PGProperty.PG_PORT.getDefaultValue());
                    hosts.append(address);
                }
                ports.append(',');
                hosts.append(',');
            }
            ports.setLength(ports.length() - 1);
            hosts.setLength(hosts.length() - 1);
            PGProperty.PG_HOST.set(priority1Url, hosts.toString());
            PGProperty.PG_PORT.set(priority1Url, ports.toString());
        } else {
            if (urlServer.startsWith("/")) {
                return null;
            }
            String value = Driver.urlDecode(urlServer);
            if (value == null) {
                return null;
            }
            priority1Url.setProperty(PGProperty.PG_DBNAME.getName(), value);
        }
        String[] args = urlArgs.split("&");
        String serviceName = null;
        for (String token : args) {
            if (token.isEmpty()) continue;
            int pos = token.indexOf(61);
            if (pos == -1) {
                priority1Url.setProperty(token, "");
                continue;
            }
            String pName = PGPropertyUtil.translatePGServiceToPGProperty(token.substring(0, pos));
            String pValue = Driver.urlDecode(token.substring(pos + 1));
            if (pValue == null) {
                return null;
            }
            if (PGProperty.SERVICE.getName().equals(pName)) {
                serviceName = pValue;
                continue;
            }
            priority1Url.setProperty(pName, pValue);
        }
        if (serviceName != null) {
            LOGGER.log(Level.FINE, "Processing option [?service={0}]", serviceName);
            result = PGPropertyServiceParser.getServiceProperties(serviceName);
            if (result == null) {
                LOGGER.log(Level.WARNING, "Definition of service [{0}] not found", serviceName);
                return null;
            }
            priority3Service.putAll((Map<?, ?>)result);
        }
        result = new Properties();
        result.putAll((Map<?, ?>)priority1Url);
        if (defaults != null) {
            defaults.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)result::putIfAbsent));
        }
        priority3Service.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)result::putIfAbsent));
        if (defaults != null) {
            defaults.stringPropertyNames().forEach(s -> result.putIfAbsent(s, Nullness.castNonNull(defaults.getProperty((String)s))));
        }
        result.putIfAbsent(PGProperty.PG_PORT.getName(), Nullness.castNonNull(PGProperty.PG_PORT.getDefaultValue()));
        result.putIfAbsent(PGProperty.PG_HOST.getName(), Nullness.castNonNull(PGProperty.PG_HOST.getDefaultValue()));
        if (PGProperty.USER.get(result) != null) {
            result.putIfAbsent(PGProperty.PG_DBNAME.getName(), Nullness.castNonNull(PGProperty.USER.get(result)));
        }
        if (!PGPropertyUtil.propertiesConsistencyCheck(result)) {
            return null;
        }
        if (PGProperty.PASSWORD.get(result) == null && (password = PGPropertyPasswordParser.getPassword(PGProperty.PG_HOST.get(result), PGProperty.PG_PORT.get(result), PGProperty.PG_DBNAME.get(result), PGProperty.USER.get(result))) != null && !password.isEmpty()) {
            PGProperty.PASSWORD.set(result, password);
        }
        return result;
    }

    private static @Nullable String urlDecode(String url) {
        try {
            return URLCoder.decode(url);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, "Url [{0}] parsing failed with error [{1}]", new Object[]{url, e.getMessage()});
            return null;
        }
    }

    private static HostSpec[] hostSpecs(Properties props) {
        String[] hosts = Nullness.castNonNull(props.getProperty("PGHOST")).split(",");
        String[] ports = Nullness.castNonNull(props.getProperty("PGPORT")).split(",");
        String localSocketAddress = props.getProperty("localSocketAddress");
        HostSpec[] hostSpecs = new HostSpec[hosts.length];
        for (int i = 0; i < hostSpecs.length; ++i) {
            hostSpecs[i] = new HostSpec(hosts[i], Integer.parseInt(ports[i]), localSocketAddress);
        }
        return hostSpecs;
    }

    private static String user(Properties props) {
        return props.getProperty("user", "");
    }

    private static String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    private static long timeout(Properties props) {
        String timeout = PGProperty.LOGIN_TIMEOUT.get(props);
        if (timeout != null) {
            try {
                return (long)(Float.parseFloat(timeout) * 1000.0f);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Couldn't parse loginTimeout value: {0}", timeout);
            }
        }
        return (long)DriverManager.getLoginTimeout() * 1000L;
    }

    public static SQLFeatureNotSupportedException notImplemented(Class<?> callClass, String functionName) {
        return new SQLFeatureNotSupportedException(GT.tr("Method {0} is not yet implemented.", callClass.getName() + "." + functionName), PSQLState.NOT_IMPLEMENTED.getState());
    }

    @Override
    public Logger getParentLogger() {
        return PARENT_LOGGER;
    }

    public static SharedTimer getSharedTimer() {
        return SHARED_TIMER;
    }

    public static void register() throws SQLException {
        if (Driver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        Driver registeredDriver = new Driver();
        DriverManager.registerDriver(registeredDriver);
        Driver.registeredDriver = registeredDriver;
    }

    public static void deregister() throws SQLException {
        if (registeredDriver == null) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        PARENT_LOGGER = Logger.getLogger("com.yugabyte");
        LOGGER = Logger.getLogger("com.yugabyte.Driver");
        SHARED_TIMER = new SharedTimer();
        try {
            Driver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ConnectThread
    implements Runnable {
        private final String url;
        private final Properties props;
        private @Nullable Connection result;
        private @Nullable Throwable resultException;
        private boolean abandoned;

        ConnectThread(String url, Properties props) {
            this.url = url;
            this.props = props;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Throwable error;
            Connection conn;
            try {
                conn = Driver.makeConnection(this.url, this.props);
                error = null;
            }
            catch (Throwable t) {
                conn = null;
                error = t;
            }
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this.abandoned) {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                } else {
                    this.result = conn;
                    this.resultException = error;
                    this.notify();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection getResult(long timeout) throws SQLException {
            long expiry = TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) + timeout;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this.result == null) {
                    if (this.resultException != null) {
                        if (this.resultException instanceof SQLException) {
                            this.resultException.fillInStackTrace();
                            throw (SQLException)this.resultException;
                        }
                        throw new PSQLException(GT.tr("Something unusual has occurred to cause the driver to fail. Please report this exception.", new Object[0]), PSQLState.UNEXPECTED_ERROR, this.resultException);
                    }
                    long delay = expiry - TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    if (delay <= 0L) {
                        this.abandoned = true;
                        throw new PSQLException(GT.tr("Connection attempt timed out.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    try {
                        this.wait(delay);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        this.abandoned = true;
                        throw new RuntimeException(GT.tr("Interrupted while attempting to connect.", new Object[0]));
                    }
                }
                return this.result;
            }
        }
    }
}

