/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.xa;

import com.yugabyte.core.BaseConnection;
import com.yugabyte.ds.common.BaseDataSource;
import com.yugabyte.xa.PGXAConnection;
import com.yugabyte.xa.PGXADataSourceFactory;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Reference;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGXADataSource
extends BaseDataSource
implements XADataSource {
    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword());
    }

    @Override
    public XAConnection getXAConnection(@Nullable String user, @Nullable String password) throws SQLException {
        Connection con = super.getConnection(user, password);
        return new PGXAConnection((BaseConnection)con);
    }

    @Override
    public String getDescription() {
        return "XA-enabled DataSource from PostgreSQL JDBC Driver 42.3.5-yb-1";
    }

    @Override
    protected Reference createReference() {
        return new Reference(this.getClass().getName(), PGXADataSourceFactory.class.getName(), null);
    }
}

