/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import com.yugabyte.ysql.TopologyAwareLoadBalancer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadBalanceProperties {
    private static final String SIMPLE_LB = "simple";
    public static final String LOAD_BALANCE_PROPERTY_KEY = "load-balance";
    public static final String TOPOLOGY_AWARE_PROPERTY_KEY = "topology-keys";
    public static final String REFRESH_INTERVAL_KEY = "yb-servers-refresh-interval";
    public static final String EXPLICIT_FALLBACK_ONLY_KEY = "explicit-fallback-only";
    private static final String PROPERTY_SEP = "&";
    private static final String EQUALS = "=";
    public static final String LOCATIONS_DELIMITER = ",";
    public static final String PREFERENCE_DELIMITER = ":";
    public static final int MAX_PREFERENCE_VALUE = 10;
    public static final int DEFAULT_REFRESH_INTERVAL = 300;
    public static final int MAX_REFRESH_INTERVAL = 600;
    private static final Logger LOGGER = Logger.getLogger("com.yugabyte.Driver");
    public static final Map<String, ClusterAwareLoadBalancer> CONNECTION_MANAGER_MAP = new HashMap<String, ClusterAwareLoadBalancer>();
    private final String originalUrl;
    private final Properties originalProperties;
    private final Properties strippedProperties;
    private boolean hasLoadBalance;
    private final String ybURL;
    private String placements = null;
    private int refreshInterval = -1;
    private boolean explicitFallbackOnly;

    public LoadBalanceProperties(String origUrl, Properties origProperties) {
        this.originalUrl = origUrl;
        this.originalProperties = origProperties;
        this.strippedProperties = (Properties)origProperties.clone();
        this.strippedProperties.remove(LOAD_BALANCE_PROPERTY_KEY);
        this.strippedProperties.remove(TOPOLOGY_AWARE_PROPERTY_KEY);
        this.ybURL = this.processURLAndProperties();
    }

    public String processURLAndProperties() {
        String[] urlParts = this.originalUrl.split("\\?");
        StringBuilder sb = new StringBuilder(urlParts[0]);
        if (urlParts.length == 2) {
            urlParts = urlParts[1].split(PROPERTY_SEP);
            String loadBalancerKey = "load-balance=";
            String topologyKey = "topology-keys=";
            String refreshIntervalKey = "yb-servers-refresh-interval=";
            String explicitFallbackOnlyKey = EXPLICIT_FALLBACK_ONLY_KEY;
            for (String part : urlParts) {
                String propValue;
                String[] lbParts;
                if (part.startsWith(loadBalancerKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length < 2) {
                        LOGGER.log(Level.WARNING, "No value provided for load balance property. Ignoring it.");
                        continue;
                    }
                    propValue = lbParts[1];
                    if (!propValue.equalsIgnoreCase("true")) continue;
                    this.hasLoadBalance = true;
                    continue;
                }
                if (part.startsWith(topologyKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2) {
                        LOGGER.log(Level.WARNING, "No valid value provided for topology keys. Ignoring it.");
                        continue;
                    }
                    this.placements = lbParts[1];
                    continue;
                }
                if (part.startsWith(refreshIntervalKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2) {
                        LOGGER.log(Level.WARNING, "No valid value provided for yb-servers-refresh-interval. Ignoring it.");
                        continue;
                    }
                    try {
                        this.refreshInterval = Integer.parseInt(lbParts[1]);
                        if (this.refreshInterval >= 0 && this.refreshInterval <= 600) continue;
                        this.refreshInterval = 300;
                    }
                    catch (NumberFormatException nfe) {
                        this.refreshInterval = 300;
                    }
                    continue;
                }
                if (part.startsWith(explicitFallbackOnlyKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2 || !(propValue = lbParts[1]).equalsIgnoreCase("true")) continue;
                    this.explicitFallbackOnly = true;
                    continue;
                }
                if (sb.toString().contains("?")) {
                    sb.append(PROPERTY_SEP);
                } else {
                    sb.append("?");
                }
                sb.append(part);
            }
        }
        if (this.originalProperties != null) {
            String propValue;
            if (this.originalProperties.containsKey(LOAD_BALANCE_PROPERTY_KEY) && (propValue = this.originalProperties.getProperty(LOAD_BALANCE_PROPERTY_KEY)).equalsIgnoreCase("true")) {
                this.hasLoadBalance = true;
            }
            if (this.originalProperties.containsKey(TOPOLOGY_AWARE_PROPERTY_KEY)) {
                this.placements = propValue = this.originalProperties.getProperty(TOPOLOGY_AWARE_PROPERTY_KEY);
            }
            if (this.originalProperties.containsKey(REFRESH_INTERVAL_KEY)) {
                propValue = this.originalProperties.getProperty(REFRESH_INTERVAL_KEY);
                try {
                    this.refreshInterval = Integer.parseInt(propValue);
                    if (this.refreshInterval < 0 || this.refreshInterval > 600) {
                        this.refreshInterval = 300;
                    }
                }
                catch (NumberFormatException nfe) {
                    this.refreshInterval = 300;
                }
            }
            if (this.originalProperties.containsKey(EXPLICIT_FALLBACK_ONLY_KEY) && (propValue = this.originalProperties.getProperty(EXPLICIT_FALLBACK_ONLY_KEY)).equalsIgnoreCase("true")) {
                this.explicitFallbackOnly = true;
            }
        }
        return sb.toString();
    }

    public String getOriginalURL() {
        return this.originalUrl;
    }

    public Properties getOriginalProperties() {
        return this.originalProperties;
    }

    public Properties getStrippedProperties() {
        return this.strippedProperties;
    }

    public boolean hasLoadBalance() {
        return this.hasLoadBalance;
    }

    public String getPlacements() {
        return this.placements;
    }

    public String getStrippedURL() {
        return this.ybURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterAwareLoadBalancer getAppropriateLoadBalancer() {
        if (!this.hasLoadBalance) {
            throw new IllegalStateException("This method is expected to be called only when load-balance is true");
        }
        ClusterAwareLoadBalancer ld = null;
        if (this.placements == null) {
            ld = CONNECTION_MANAGER_MAP.get(SIMPLE_LB);
            if (ld == null) {
                Map<String, ClusterAwareLoadBalancer> map = CONNECTION_MANAGER_MAP;
                synchronized (map) {
                    ld = CONNECTION_MANAGER_MAP.get(SIMPLE_LB);
                    if (ld == null) {
                        ld = ClusterAwareLoadBalancer.getInstance(this.refreshInterval);
                        CONNECTION_MANAGER_MAP.put(SIMPLE_LB, ld);
                    }
                }
            }
        } else {
            ld = CONNECTION_MANAGER_MAP.get(this.placements);
            if (ld == null) {
                Map<String, ClusterAwareLoadBalancer> map = CONNECTION_MANAGER_MAP;
                synchronized (map) {
                    ld = CONNECTION_MANAGER_MAP.get(this.placements);
                    if (ld == null) {
                        ld = new TopologyAwareLoadBalancer(this.placements);
                        CONNECTION_MANAGER_MAP.put(this.placements, ld);
                    }
                }
            }
        }
        System.setProperty(REFRESH_INTERVAL_KEY, String.valueOf(this.refreshInterval));
        System.setProperty(EXPLICIT_FALLBACK_ONLY_KEY, String.valueOf(this.explicitFallbackOnly));
        return ld;
    }
}

