/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.jdbc;

import com.yugabyte.core.BaseConnection;
import com.yugabyte.jdbc.AbstractBlobClob;
import com.yugabyte.jdbc.ResourceLock;
import com.yugabyte.largeobject.LargeObject;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class PgBlob
extends AbstractBlobClob
implements Blob {
    public PgBlob(BaseConnection conn, long oid) throws SQLException {
        super(conn, oid);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try (ResourceLock ignore = this.lock.obtain();){
            this.checkFreed();
            LargeObject subLO = this.getLo(false).copy();
            this.addSubLO(subLO);
            if (pos > Integer.MAX_VALUE) {
                subLO.seek64(pos - 1L, 0);
            } else {
                subLO.seek((int)pos - 1, 0);
            }
            InputStream inputStream = subLO.getInputStream(length);
            return inputStream;
        }
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        try (ResourceLock ignore = this.lock.obtain();){
            this.assertPosition(pos);
            this.getLo(true).seek((int)(pos - 1L));
            this.getLo(true).write(bytes, offset, len);
            int n = len;
            return n;
        }
    }
}

