/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.util;

import com.yugabyte.PGProperty;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PGPropertyUtil {
    private static final Logger LOGGER = Logger.getLogger(PGPropertyUtil.class.getName());

    private static @Nullable Integer convertPgPortToInt(String portStr) {
        try {
            int port = Integer.parseInt(portStr);
            if (port < 1 || port > 65535) {
                LOGGER.log(Level.WARNING, "JDBC URL port: {0} not valid (1:65535) ", portStr);
                return null;
            }
            return port;
        }
        catch (NumberFormatException ignore) {
            LOGGER.log(Level.WARNING, "JDBC URL invalid port number: {0}", portStr);
            return null;
        }
    }

    public static boolean propertiesConsistencyCheck(Properties properties) {
        int portCount;
        String hosts = PGProperty.PG_HOST.getOrDefault(properties);
        if (hosts == null) {
            LOGGER.log(Level.WARNING, "Property [{0}] can not be null", PGProperty.PG_HOST.getName());
            return false;
        }
        String ports = PGProperty.PG_PORT.getOrDefault(properties);
        if (ports == null) {
            LOGGER.log(Level.WARNING, "Property [{0}] can not be null", PGProperty.PG_PORT.getName());
            return false;
        }
        for (String portStr : ports.split(",")) {
            if (PGPropertyUtil.convertPgPortToInt(portStr) != null) continue;
            return false;
        }
        int hostCount = hosts.split(",").length;
        if (hostCount != (portCount = ports.split(",").length)) {
            LOGGER.log(Level.WARNING, "Properties [{0}] [{1}] must have same amount of values", new Object[]{PGProperty.PG_HOST.getName(), PGProperty.PG_PORT.getName()});
            LOGGER.log(Level.WARNING, "Property [{0}] ; value [{1}] ; count [{2}]", new Object[]{PGProperty.PG_HOST.getName(), hosts, hostCount});
            LOGGER.log(Level.WARNING, "Property [{0}] ; value [{1}] ; count [{2}]", new Object[]{PGProperty.PG_PORT.getName(), ports, portCount});
            return false;
        }
        return true;
    }

    public static String translatePGServiceToPGProperty(String serviceKey) {
        String testKey = "PG" + serviceKey.toUpperCase(Locale.ROOT);
        if (PGProperty.PG_HOST.getName().equals(testKey) || PGProperty.PG_PORT.getName().equals(testKey) || PGProperty.PG_DBNAME.getName().equals(testKey)) {
            return testKey;
        }
        return serviceKey;
    }

    public static String translatePGPropertyToPGService(String propertyKey) {
        if (PGProperty.PG_HOST.getName().equals(propertyKey) || PGProperty.PG_PORT.getName().equals(propertyKey) || PGProperty.PG_DBNAME.getName().equals(propertyKey)) {
            return propertyKey.substring(2).toLowerCase(Locale.ROOT);
        }
        return propertyKey;
    }
}

