/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.util;

import com.yugabyte.core.Utils;
import com.yugabyte.shaded.com.ongres.scram.common.ScramFunctions;
import com.yugabyte.shaded.com.ongres.scram.common.ScramMechanisms;
import com.yugabyte.shaded.com.ongres.scram.common.bouncycastle.base64.Base64;
import com.yugabyte.shaded.com.ongres.scram.common.stringprep.StringPreparations;
import com.yugabyte.util.MD5Digest;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Objects;

public class PasswordUtil {
    private static final int DEFAULT_ITERATIONS = 4096;
    private static final int DEFAULT_SALT_LENGTH = 16;

    private static SecureRandom getSecureRandom() {
        return SecureRandomHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeScramSha256(char[] password, int iterations, byte[] salt) {
        Objects.requireNonNull(password, "password");
        Objects.requireNonNull(salt, "salt");
        if (iterations <= 0) {
            throw new IllegalArgumentException("iterations must be greater than zero");
        }
        if (salt.length == 0) {
            throw new IllegalArgumentException("salt length must be greater than zero");
        }
        try {
            String passwordText = String.valueOf(password);
            byte[] saltedPassword = ScramFunctions.saltedPassword(ScramMechanisms.SCRAM_SHA_256, StringPreparations.SASL_PREPARATION, passwordText, salt, iterations);
            byte[] clientKey = ScramFunctions.clientKey(ScramMechanisms.SCRAM_SHA_256, saltedPassword);
            byte[] storedKey = ScramFunctions.storedKey(ScramMechanisms.SCRAM_SHA_256, clientKey);
            byte[] serverKey = ScramFunctions.serverKey(ScramMechanisms.SCRAM_SHA_256, saltedPassword);
            String string = "SCRAM-SHA-256$" + iterations + ":" + Base64.toBase64String(salt) + "$" + Base64.toBase64String(storedKey) + ":" + Base64.toBase64String(serverKey);
            return string;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeScramSha256(char[] password) {
        Objects.requireNonNull(password, "password");
        try {
            SecureRandom rng = PasswordUtil.getSecureRandom();
            byte[] salt = rng.generateSeed(16);
            String string = PasswordUtil.encodeScramSha256(password, 4096, salt);
            return string;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    @Deprecated
    public static String encodeMd5(String user, char[] password) {
        Objects.requireNonNull(user, "user");
        Objects.requireNonNull(password, "password");
        ByteBuffer passwordBytes = null;
        try {
            passwordBytes = StandardCharsets.UTF_8.encode(CharBuffer.wrap(password));
            byte[] userBytes = user.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passwordBytes);
            md.update(userBytes);
            byte[] digest = md.digest();
            byte[] encodedPassword = new byte[35];
            encodedPassword[0] = 109;
            encodedPassword[1] = 100;
            encodedPassword[2] = 53;
            MD5Digest.bytesToHex(digest, encodedPassword, 3);
            String string = new String(encodedPassword, StandardCharsets.UTF_8);
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to encode password with MD5", e);
        }
        finally {
            Arrays.fill(password, '\u0000');
            if (passwordBytes != null) {
                if (passwordBytes.hasArray()) {
                    Arrays.fill(passwordBytes.array(), (byte)0);
                } else {
                    int limit = passwordBytes.limit();
                    for (int i = 0; i < limit; ++i) {
                        passwordBytes.put(i, (byte)0);
                    }
                }
            }
        }
    }

    public static String encodePassword(String user, char[] password, String encryptionType) throws SQLException {
        Objects.requireNonNull(password, "password");
        Objects.requireNonNull(encryptionType, "encryptionType");
        switch (encryptionType) {
            case "on": 
            case "off": 
            case "md5": {
                return PasswordUtil.encodeMd5(user, password);
            }
            case "scram-sha-256": {
                return PasswordUtil.encodeScramSha256(password);
            }
        }
        Arrays.fill(password, '\u0000');
        throw new PSQLException("Unable to determine encryption type: " + encryptionType, PSQLState.SYSTEM_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genAlterUserPasswordSQL(String user, char[] password, String encryptionType) throws SQLException {
        try {
            String encodedPassword = PasswordUtil.encodePassword(user, password, encryptionType);
            StringBuilder sb = new StringBuilder();
            sb.append("ALTER USER ");
            Utils.escapeIdentifier(sb, user);
            sb.append(" PASSWORD '");
            Utils.escapeLiteral(sb, encodedPassword, true);
            sb.append("'");
            String string = sb.toString();
            return string;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    private static class SecureRandomHolder {
        static final SecureRandom INSTANCE = new SecureRandom();

        private SecureRandomHolder() {
        }
    }
}

