/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.LoadBalanceService;
import com.yugabyte.ysql.LoadBalancer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Logger;

public class ClusterAwareLoadBalancer
implements LoadBalancer {
    protected static final Logger LOGGER = Logger.getLogger("com.yugabyte." + ClusterAwareLoadBalancer.class.getName());
    private static volatile ClusterAwareLoadBalancer instance;
    private List<String> attempted = new ArrayList<String>();
    private final LoadBalanceService.LoadBalanceType loadBalance;
    private byte requestFlags;
    protected int refreshListSeconds = 300;

    @Override
    public int getRefreshListSeconds() {
        return this.refreshListSeconds;
    }

    public ClusterAwareLoadBalancer(LoadBalanceService.LoadBalanceType lb, int refreshInterval) {
        this.loadBalance = lb != null ? lb : LoadBalanceService.LoadBalanceType.FALSE;
        this.refreshListSeconds = refreshInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClusterAwareLoadBalancer getInstance(LoadBalanceService.LoadBalanceType lb, int refreshListSeconds) {
        if (instance != null) return instance;
        Class<ClusterAwareLoadBalancer> clazz = ClusterAwareLoadBalancer.class;
        synchronized (ClusterAwareLoadBalancer.class) {
            if (instance != null) return instance;
            instance = new ClusterAwareLoadBalancer(lb, refreshListSeconds);
            ClusterAwareLoadBalancer.instance.refreshListSeconds = refreshListSeconds >= 0 && refreshListSeconds <= 600 ? refreshListSeconds : 300;
            LOGGER.fine("Created a new cluster-aware LB instance with loadbalance = " + (Object)((Object)ClusterAwareLoadBalancer.instance.loadBalance) + " and refresh interval " + ClusterAwareLoadBalancer.instance.refreshListSeconds + " seconds");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": loadBalance = " + (Object)((Object)this.loadBalance) + ", refreshInterval = " + this.refreshListSeconds;
    }

    @Override
    public boolean isHostEligible(Map.Entry<String, LoadBalanceService.NodeInfo> e, Byte requestFlags) {
        return !this.attempted.contains(e.getKey()) && !e.getValue().isDown() && LoadBalanceService.isRightNodeType(this.loadBalance, e.getValue().getNodeType(), requestFlags);
    }

    @Override
    public synchronized String getLeastLoadedServer(boolean newRequest, List<String> failedHosts, ArrayList<String> timedOutHosts) {
        this.attempted = failedHosts;
        if (timedOutHosts != null) {
            this.attempted.addAll(timedOutHosts);
        }
        this.requestFlags = newRequest ? (byte)1 : this.requestFlags;
        LOGGER.fine("newRequest: " + newRequest + ", failedHosts: " + failedHosts + ", timedOutHosts: " + timedOutHosts + ", requestFlags: " + this.requestFlags);
        String chosenHost = null;
        while (true) {
            ArrayList<String> hosts = LoadBalanceService.getAllEligibleHosts(this, this.requestFlags);
            int min = Integer.MAX_VALUE;
            ArrayList<String> minConnectionsHostList = new ArrayList<String>();
            for (String h : hosts) {
                boolean wasTimedOutHost;
                boolean bl = wasTimedOutHost = timedOutHosts != null && timedOutHosts.contains(h);
                if (failedHosts.contains(h) || wasTimedOutHost) {
                    LOGGER.fine("Skipping failed host " + h + "(was timed out host=" + wasTimedOutHost + ")");
                    continue;
                }
                int currLoad = LoadBalanceService.getLoad(h);
                LOGGER.fine("Number of connections to " + h + ": " + currLoad);
                if (currLoad < min) {
                    min = currLoad;
                    minConnectionsHostList.clear();
                    minConnectionsHostList.add(h);
                    continue;
                }
                if (currLoad != min) continue;
                minConnectionsHostList.add(h);
            }
            if (!minConnectionsHostList.isEmpty()) {
                int idx = ThreadLocalRandom.current().nextInt(0, minConnectionsHostList.size());
                chosenHost = (String)minConnectionsHostList.get(idx);
            }
            if (chosenHost != null) {
                LoadBalanceService.incrementConnectionCount(chosenHost);
                break;
            }
            if (this.requestFlags != 1) break;
            this.requestFlags = 0;
        }
        LOGGER.fine("Host chosen for new connection: " + chosenHost);
        if (chosenHost == null && (this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_PRIMARY || this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_RR)) {
            throw new IllegalStateException("No node available in " + (this.loadBalance == LoadBalanceService.LoadBalanceType.ONLY_PRIMARY ? "primary" : "read-replica") + " cluster to connect to.");
        }
        return chosenHost;
    }
}

