/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.ysql;

import com.yugabyte.ysql.ClusterAwareLoadBalancer;
import com.yugabyte.ysql.LoadBalanceService;
import com.yugabyte.ysql.LoadBalancer;
import com.yugabyte.ysql.TopologyAwareLoadBalancer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoadBalanceProperties {
    public static final String LOAD_BALANCE_PROPERTY_KEY = "load-balance";
    public static final String TOPOLOGY_AWARE_PROPERTY_KEY = "topology-keys";
    public static final String REFRESH_INTERVAL_KEY = "yb-servers-refresh-interval";
    public static final String EXPLICIT_FALLBACK_ONLY_KEY = "fallback-to-topology-keys-only";
    public static final String FAILED_HOST_RECONNECT_DELAY_SECS_KEY = "failed-host-reconnect-delay-secs";
    public static final int DEFAULT_FAILED_HOST_TTL_SECONDS = 5;
    private static final String PROPERTY_SEP = "&";
    private static final String EQUALS = "=";
    public static final String LOCATIONS_DELIMITER = ",";
    public static final String PREFERENCE_DELIMITER = ":";
    public static final int MAX_PREFERENCE_VALUE = 10;
    public static final int DEFAULT_REFRESH_INTERVAL = 300;
    public static final int MAX_REFRESH_INTERVAL = 600;
    public static final int MAX_FAILED_HOST_RECONNECT_DELAY_SECS = 60;
    private static final Logger LOGGER = Logger.getLogger("com.yugabyte." + LoadBalanceProperties.class.getName());
    private static final Map<String, LoadBalancer> CONNECTION_MANAGER_MAP = new HashMap<String, LoadBalancer>();
    private static final Map<LoadBalancerKey, LoadBalanceProperties> loadBalancePropertiesMap = new ConcurrentHashMap<LoadBalancerKey, LoadBalanceProperties>();
    private final String originalUrl;
    private final Properties originalProperties;
    private LoadBalanceService.LoadBalanceType loadBalance = LoadBalanceService.LoadBalanceType.FALSE;
    private final String ybURL;
    private String placements = null;
    private int refreshInterval = -1;
    private boolean explicitFallbackOnly;
    private boolean refreshIntervalSpecified;
    private int failedHostReconnectDelaySecs = -1;
    private boolean failedHostReconnectDelaySpecified;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearConnectionManagerMap() {
        LOGGER.warning("Clearing CONNECTION_MANAGER_MAP for testing purposes");
        Map<String, LoadBalancer> map = CONNECTION_MANAGER_MAP;
        synchronized (map) {
            CONNECTION_MANAGER_MAP.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoadBalanceProperties getLoadBalanceProperties(String url, Properties properties) {
        LoadBalancerKey key = new LoadBalancerKey(url, properties);
        LoadBalanceProperties lbp = loadBalancePropertiesMap.get(key);
        if (lbp != null) return lbp;
        Class<LoadBalanceProperties> clazz = LoadBalanceProperties.class;
        synchronized (LoadBalanceProperties.class) {
            lbp = loadBalancePropertiesMap.get(key);
            if (lbp != null) return lbp;
            lbp = new LoadBalanceProperties(url, properties);
            loadBalancePropertiesMap.put(key, lbp);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lbp;
        }
    }

    private LoadBalanceProperties(String origUrl, Properties origProperties) {
        this.originalUrl = origUrl;
        this.originalProperties = (Properties)origProperties.clone();
        this.ybURL = this.processURLAndProperties();
    }

    public String processURLAndProperties() {
        String[] urlParts = this.originalUrl.split("\\?");
        StringBuilder sb = new StringBuilder(urlParts[0]);
        if (urlParts.length == 2) {
            urlParts = urlParts[1].split(PROPERTY_SEP);
            String loadBalancerKey = "load-balance=";
            String topologyKey = "topology-keys=";
            String refreshIntervalKey = "yb-servers-refresh-interval=";
            String explicitFallbackOnlyKey = "fallback-to-topology-keys-only=";
            String failedHostReconnectDelayKey = "failed-host-reconnect-delay-secs=";
            for (String part : urlParts) {
                String propValue;
                String[] lbParts;
                if (part.startsWith(loadBalancerKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length < 2) {
                        LOGGER.log(Level.WARNING, "No value provided for load balance property. Ignoring it.");
                        continue;
                    }
                    propValue = lbParts[1];
                    this.setLoadBalanceValue(propValue);
                    continue;
                }
                if (part.startsWith(topologyKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2) {
                        LOGGER.log(Level.WARNING, "No valid value provided for topology keys. Ignoring it.");
                        continue;
                    }
                    this.placements = lbParts[1];
                    continue;
                }
                if (part.startsWith(refreshIntervalKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2) {
                        LOGGER.log(Level.WARNING, "No valid value provided for yb-servers-refresh-interval. Ignoring it.");
                        continue;
                    }
                    this.refreshIntervalSpecified = true;
                    this.refreshInterval = this.parseAndGetValue(lbParts[1], 300, 600);
                    continue;
                }
                if (part.startsWith(explicitFallbackOnlyKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2 || !(propValue = lbParts[1]).equalsIgnoreCase("true")) continue;
                    this.explicitFallbackOnly = true;
                    continue;
                }
                if (part.startsWith(failedHostReconnectDelayKey)) {
                    lbParts = part.split(EQUALS);
                    if (lbParts.length != 2) {
                        LOGGER.log(Level.WARNING, "No valid value provided for failed-host-reconnect-delay-secs. Ignoring it.");
                        continue;
                    }
                    this.failedHostReconnectDelaySpecified = true;
                    this.failedHostReconnectDelaySecs = this.parseAndGetValue(lbParts[1], 5, 60);
                    continue;
                }
                if (sb.toString().contains("?")) {
                    sb.append(PROPERTY_SEP);
                } else {
                    sb.append("?");
                }
                sb.append(part);
            }
        }
        if (this.originalProperties != null) {
            String propValue;
            if (this.originalProperties.containsKey(LOAD_BALANCE_PROPERTY_KEY)) {
                propValue = this.originalProperties.getProperty(LOAD_BALANCE_PROPERTY_KEY);
                this.setLoadBalanceValue(propValue);
            }
            if (this.originalProperties.containsKey(TOPOLOGY_AWARE_PROPERTY_KEY)) {
                this.placements = propValue = this.originalProperties.getProperty(TOPOLOGY_AWARE_PROPERTY_KEY);
            }
            if (this.originalProperties.containsKey(REFRESH_INTERVAL_KEY)) {
                this.refreshIntervalSpecified = true;
                this.refreshInterval = this.parseAndGetValue(this.originalProperties.getProperty(REFRESH_INTERVAL_KEY), 300, 600);
            }
            if (this.originalProperties.containsKey(EXPLICIT_FALLBACK_ONLY_KEY) && (propValue = this.originalProperties.getProperty(EXPLICIT_FALLBACK_ONLY_KEY)).equalsIgnoreCase("true")) {
                this.explicitFallbackOnly = true;
            }
            if (this.originalProperties.containsKey(FAILED_HOST_RECONNECT_DELAY_SECS_KEY)) {
                this.failedHostReconnectDelaySpecified = true;
                this.failedHostReconnectDelaySecs = this.parseAndGetValue(this.originalProperties.getProperty(FAILED_HOST_RECONNECT_DELAY_SECS_KEY), 5, 60);
            }
        }
        return sb.toString();
    }

    private void setLoadBalanceValue(String value) {
        switch (value.toLowerCase(Locale.ROOT)) {
            case "true": 
            case "any": {
                this.loadBalance = LoadBalanceService.LoadBalanceType.ANY;
                break;
            }
            case "prefer-primary": {
                this.loadBalance = LoadBalanceService.LoadBalanceType.PREFER_PRIMARY;
                break;
            }
            case "prefer-rr": {
                this.loadBalance = LoadBalanceService.LoadBalanceType.PREFER_RR;
                break;
            }
            case "only-primary": {
                this.loadBalance = LoadBalanceService.LoadBalanceType.ONLY_PRIMARY;
                break;
            }
            case "only-rr": {
                this.loadBalance = LoadBalanceService.LoadBalanceType.ONLY_RR;
                break;
            }
            case "false": {
                this.loadBalance = LoadBalanceService.LoadBalanceType.FALSE;
                break;
            }
            default: {
                LOGGER.warning("Invalid value for load-balance: " + value + ", ignoring it.");
            }
        }
        LOGGER.fine("loadbalance value set to " + (Object)((Object)this.loadBalance));
    }

    private int parseAndGetValue(String propValue, int defaultValue, int maxValue) {
        try {
            int value = Integer.parseInt(propValue);
            if (value < 0 || value > maxValue) {
                LOGGER.warning("Provided value (" + value + ") is outside the permissible range, using the default value instead");
                return defaultValue;
            }
            return value;
        }
        catch (NumberFormatException nfe) {
            LOGGER.warning("Provided value (" + propValue + ") is invalid, using the default value instead");
            return defaultValue;
        }
    }

    public String getOriginalURL() {
        return this.originalUrl;
    }

    public Properties getOriginalProperties() {
        return this.originalProperties;
    }

    public boolean isLoadBalanceEnabled() {
        return this.loadBalance != LoadBalanceService.LoadBalanceType.FALSE;
    }

    public String getPlacements() {
        return this.placements;
    }

    public String getStrippedURL() {
        return this.ybURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoadBalancer getAppropriateLoadBalancer() {
        if (!this.isLoadBalanceEnabled()) {
            throw new IllegalStateException("This method is expected to be called only when load-balance is true");
        }
        if (this.refreshIntervalSpecified) {
            System.setProperty(REFRESH_INTERVAL_KEY, String.valueOf(this.refreshInterval));
        }
        if (this.failedHostReconnectDelaySpecified) {
            System.setProperty(FAILED_HOST_RECONNECT_DELAY_SECS_KEY, String.valueOf(this.failedHostReconnectDelaySecs));
        }
        LoadBalancer ld = null;
        if (this.placements == null) {
            ld = CONNECTION_MANAGER_MAP.get(this.loadBalance.name());
            if (ld == null) {
                LOGGER.fine("No LB found for " + (Object)((Object)this.loadBalance) + ", creating one ...");
                Map<String, LoadBalancer> map = CONNECTION_MANAGER_MAP;
                synchronized (map) {
                    ld = CONNECTION_MANAGER_MAP.get(this.loadBalance.name());
                    if (ld == null) {
                        ld = new ClusterAwareLoadBalancer(this.loadBalance, this.refreshInterval);
                        CONNECTION_MANAGER_MAP.put(this.loadBalance.name(), ld);
                    }
                }
            } else {
                LOGGER.fine("LB found for " + (Object)((Object)this.loadBalance) + ": " + ld);
            }
        } else {
            String key = this.loadBalance.name() + PROPERTY_SEP + this.placements + PROPERTY_SEP + String.valueOf(this.explicitFallbackOnly).toLowerCase(Locale.ROOT);
            ld = CONNECTION_MANAGER_MAP.get(key);
            if (ld == null) {
                LOGGER.fine("No LB found for " + (Object)((Object)this.loadBalance) + " and placements " + this.placements + " and fallback? " + this.explicitFallbackOnly + ", creating one ...");
                Map<String, LoadBalancer> map = CONNECTION_MANAGER_MAP;
                synchronized (map) {
                    ld = CONNECTION_MANAGER_MAP.get(key);
                    if (ld == null) {
                        ld = new TopologyAwareLoadBalancer(this.loadBalance, this.placements, this.explicitFallbackOnly);
                        CONNECTION_MANAGER_MAP.put(key, ld);
                    }
                }
            } else {
                LOGGER.fine("LB found for " + (Object)((Object)this.loadBalance) + " and placements " + this.placements + ": " + ld);
            }
        }
        return ld;
    }

    private static class LoadBalancerKey {
        private String url;
        private Properties properties;

        public LoadBalancerKey(String url, Properties properties) {
            this.url = url;
            this.properties = properties;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
            return result;
        }

        public boolean equals(Object other) {
            return other instanceof LoadBalancerKey && this.url != null && this.url.equals(((LoadBalancerKey)other).url) && this.properties != null && this.properties.equals(((LoadBalancerKey)other).properties);
        }
    }
}

