/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte;

import com.yugabyte.PGNotification;
import com.yugabyte.copy.CopyManager;
import com.yugabyte.fastpath.Fastpath;
import com.yugabyte.jdbc.AutoSave;
import com.yugabyte.jdbc.PreferQueryMode;
import com.yugabyte.largeobject.LargeObjectManager;
import com.yugabyte.replication.PGReplicationConnection;
import com.yugabyte.util.GT;
import com.yugabyte.util.PGobject;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import com.yugabyte.util.PasswordUtil;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface PGConnection {
    public Array createArrayOf(String var1, @Nullable Object var2) throws SQLException;

    public PGNotification[] getNotifications() throws SQLException;

    public PGNotification[] getNotifications(int var1) throws SQLException;

    public CopyManager getCopyAPI() throws SQLException;

    public LargeObjectManager getLargeObjectAPI() throws SQLException;

    @Deprecated
    public Fastpath getFastpathAPI() throws SQLException;

    @Deprecated
    public void addDataType(String var1, String var2);

    public void addDataType(String var1, Class<? extends PGobject> var2) throws SQLException;

    public void setPrepareThreshold(int var1);

    public int getPrepareThreshold();

    public void setDefaultFetchSize(int var1) throws SQLException;

    public int getDefaultFetchSize();

    public int getBackendPID();

    public void cancelQuery() throws SQLException;

    public String escapeIdentifier(String var1) throws SQLException;

    public String escapeLiteral(String var1) throws SQLException;

    public PreferQueryMode getPreferQueryMode();

    public AutoSave getAutosave();

    public void setAutosave(AutoSave var1);

    public PGReplicationConnection getReplicationAPI();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void alterUserPassword(String user, char[] newPassword, @Nullable String encryptionType) throws SQLException {
        try (Statement stmt = ((Connection)((Object)this)).createStatement();){
            if (encryptionType == null) {
                try (ResultSet rs = stmt.executeQuery("SHOW password_encryption");){
                    if (!rs.next()) {
                        throw new PSQLException(GT.tr("Expected a row when reading password_encryption but none was found", new Object[0]), PSQLState.NO_DATA);
                    }
                    encryptionType = rs.getString(1);
                    if (encryptionType == null) {
                        throw new PSQLException(GT.tr("SHOW password_encryption returned null value", new Object[0]), PSQLState.NO_DATA);
                    }
                }
            }
            String sql = PasswordUtil.genAlterUserPasswordSQL(user, newPassword, encryptionType);
            stmt.execute(sql);
        }
        finally {
            Arrays.fill(newPassword, '\u0000');
        }
    }

    public Map<String, String> getParameterStatuses();

    public @Nullable String getParameterStatus(String var1);

    public void setAdaptiveFetch(boolean var1);

    public boolean getAdaptiveFetch();
}

