/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.jdbc;

import com.yugabyte.PGProperty;
import com.yugabyte.util.GT;
import com.yugabyte.util.PSQLException;
import com.yugabyte.util.PSQLState;
import java.util.Properties;

public enum GSSEncMode {
    DISABLE("disable"),
    ALLOW("allow"),
    PREFER("prefer"),
    REQUIRE("require");

    private static final GSSEncMode[] VALUES;
    public final String value;

    private GSSEncMode(String value) {
        this.value = value;
    }

    public boolean requireEncryption() {
        return this.compareTo(REQUIRE) >= 0;
    }

    public static GSSEncMode of(Properties info) throws PSQLException {
        String gssEncMode = PGProperty.GSS_ENC_MODE.getOrDefault(info);
        if (gssEncMode == null) {
            return ALLOW;
        }
        for (GSSEncMode mode : VALUES) {
            if (!mode.value.equalsIgnoreCase(gssEncMode)) continue;
            return mode;
        }
        throw new PSQLException(GT.tr("Invalid gssEncMode value: {0}", gssEncMode), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    static {
        VALUES = GSSEncMode.values();
    }
}

