/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.jdbc;

import com.yugabyte.Driver;
import com.yugabyte.core.BaseConnection;
import com.yugabyte.jdbc.AbstractBlobClob;
import com.yugabyte.jdbc.ResourceLock;
import com.yugabyte.largeobject.LargeObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;

public class PgClob
extends AbstractBlobClob
implements Clob {
    public PgClob(BaseConnection conn, long oid) throws SQLException {
        super(conn, oid);
    }

    @Override
    public Reader getCharacterStream(long pos, long length) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "getCharacterStream(long, long)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public int setString(long pos, String str) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "setString(long,str)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public int setString(long pos, String str, int offset, int len) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "setString(long,String,int,int)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public OutputStream setAsciiStream(long pos) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "setAsciiStream(long)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public Writer setCharacterStream(long pos) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "setCharacterStream(long)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        try (ResourceLock ignore = this.lock.obtain();){
            Charset connectionCharset = Charset.forName(this.conn.getEncoding().name());
            InputStreamReader inputStreamReader = new InputStreamReader(this.getBinaryStream(), connectionCharset);
            return inputStreamReader;
        }
    }

    @Override
    public String getSubString(long i, int j) throws SQLException {
        try (ResourceLock ignore = this.lock.obtain();){
            this.assertPosition(i, j);
            LargeObject lo = this.getLo(false);
            lo.seek((int)i - 1);
            String string = new String(lo.read(j));
            return string;
        }
    }

    @Override
    public long position(String pattern, long start) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "position(String,long)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    @Override
    public long position(Clob pattern, long start) throws SQLException {
        ResourceLock ignore = this.lock.obtain();
        try {
            this.checkFreed();
            throw Driver.notImplemented(this.getClass(), "position(Clob,start)");
        }
        catch (Throwable throwable) {
            if (ignore != null) {
                try {
                    ignore.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }
}

